<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bannerDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class admin_bannerWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	var $serialNo;		// 選択中の項目のシリアル番号
	var $bannerId;		// 選択中のバナーID
//	var $bannerItemId;	// 選択中のバナー項目ID
//	var $mode;			// 画面モード
	var $dispIdArray;	// 表示中のバナー項目ID

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bannerDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);		// 処理分岐
		if ($task == 'banneritem'){
			return 'admin_banneritemlist.tmpl.html';
		} else if ($task == 'selbanneritem'){// バナー項目選択画面
			return 'admin_selbanneritem.tmpl.html';
		} else {
			return 'admin_bannerlist.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);		// 処理分岐
		if ($task == 'banneritem'){
			return $this->createBannerItemList($request, $param);
		} else if ($task == 'selbanneritem'){	// バナー項目選択画面
			return $this->createSelBannerItem($request, $param);
		} else {
			return $this->createBannerList($request, $param);
		}
	}
	/**
	 * バナー一覧画面作成
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createBannerList($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$defaultLang = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		$this->bannerId = $request->trimValueOf('bannerid');		// 選択中のバナーID
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		$act = $request->trimValueOf('act');
		$bannerItem = $request->trimValueOf('item_banner');
		$name = $request->trimValueOf('item_name');
		$dispType = $request->trimValueOf('item_disptype');	// 表示方法
		$dispDirect = $request->trimValueOf('item_dispdirect');	// 表示方向
		$dispCount = $request->trimValueOf('item_dispcount');	// 表示項目数
		$dispAlign = $request->trimValueOf('item_dispalign');	// 表示位置
		
		if ($act == 'select'){		// 項目選択の場合
			if ($this->bannerId == 0){		// コンテンツIDが0のときは、新規追加モードにする
				//$this->mode = 'add';
				$name = '';
				$bannerItem = '';	// バナー項目ID
				$dispCount = '';	// 表示項目数
				$dispType = 0;	// 表示方法
				$dispDirect = 0;	// 表示方向
				$dispAlign = 0;		// 表示位置
			} else {
				// 登録済みのバナー定義を取得
				$ret = $this->db->getBannerByBannerId($this->bannerId, $row);
				if ($ret){
					// 取得値を設定
					$name = $row['bd_name'];		// 名前
					$updateUser = $this->convertToDispString($row['lu_name']);// 更新者
					$updateDt = $this->convertToDispDateTime($row['bd_update_dt']);// 更新日時
					$bannerItem = $this->convertToDispString($row['bd_item_id']);	// バナー項目ID
					$dispCount = $this->convertToDispString($row['bd_disp_item_count']);	// 表示項目数
					$dispType = $row['bd_disp_type'];				// 表示方法
					$dispDirect = $row['bd_disp_direction'];		// 表示方向
					$dispAlign = $row['bd_disp_align'];		// 表示位置
				}
			}
			// 選択中のコンテンツIDを設定
			//$this->tmpl->addVar("_widget", "bannerId", $this->bannerId);
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($dispCount, '表示項目数');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addBanner($name, $bannerItem, $dispType, $dispDirect, $dispAlign, $dispCount, $userInfo->userId, $newBannerId);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					$this->bannerId = $newBannerId;		// バナーIDを更新
					
					// 値を再取得
					$ret = $this->db->getBannerByBannerId($this->bannerId, $row);
					if ($ret){
						// 取得値を設定
						$name = $row['bd_name'];	// 名前
						$updateUser = $this->convertToDispString($row['lu_name']);// 更新者
						$updateDt = $this->convertToDispDateTime($row['bd_update_dt']);// 更新日時
						$bannerItem = $this->convertToDispString($row['bd_item_id']);	// バナー項目ID
						$dispCount = $this->convertToDispString($row['bd_disp_item_count']);	// 表示項目数
						$dispType = $row['bd_disp_type'];				// 表示方法
						$dispDirect = $row['bd_disp_direction'];		// 表示方向
						$dispAlign = $row['bd_disp_align'];		// 表示位置
					}
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkNumeric($dispCount, '表示項目数');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateBannerByBannerId($this->bannerId, $name, $bannerItem, $dispType, $dispDirect, $dispAlign, $dispCount, $userInfo->userId);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 値を再取得
					$ret = $this->db->getBannerByBannerId($this->bannerId, $row);
					if ($ret){
						// 取得値を設定
						$name = $row['bd_name'];	// 名前
						$updateUser = $this->convertToDispString($row['lu_name']);// 更新者
						$updateDt = $this->convertToDispDateTime($row['bd_update_dt']);// 更新日時
						$bannerItem = $this->convertToDispString($row['bd_item_id']);	// バナー項目ID
						$dispCount = $this->convertToDispString($row['bd_disp_item_count']);	// 表示項目数
						$dispType = $row['bd_disp_type'];				// 表示方法
						$dispDirect = $row['bd_disp_direction'];		// 表示方向
						$dispAlign = $row['bd_disp_align'];		// 表示位置
					}
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}				
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->bannerId) || $this->bannerId == 0){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delBanner($this->bannerId, $userInfo->userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else {	// 初期画面表示のとき
			// 新規入力を選択状態にする
			$this->bannerId = 0;
		}
					
		// 入力フィールドの設定、共通項目のデータ設定
		if ($this->bannerId == 0){
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
		} else {
			// データ更新、削除ボタン表示
			$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// デフォルト言語以外はデータ削除
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
		}
		
		// バナーリストを取得
		$this->db->getBannerList(array($this, 'itemListLoop'));
		
		// 表示方法、表示方向
		$selected = '';
		if ($dispType == 0) $selected = 'selected';
		$row = array(
			'value'    => '0',				// 表示方法
			'name'     => '順次',			// 名称
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('disp_type', $row);
		$this->tmpl->parseTemplate('disp_type', 'a');
		$selected = '';
		if ($dispType == 1) $selected = 'selected';
		$row = array(
			'value'    => '1',				// 表示方法
			'name'     => 'ランダム',			// 名称
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('disp_type', $row);
		$this->tmpl->parseTemplate('disp_type', 'a');
		$selected = '';
		if ($dispDirect == 0) $selected = 'selected';
		$this->tmpl->addVar("_widget", "direct_v_selecter", $selected);	// 縦表示
		$selected = '';
		if ($dispDirect == 1) $selected = 'selected';
		$this->tmpl->addVar("_widget", "direct_h_selecter", $selected);	// 横表示
		
		// 表示位置
		switch ($dispAlign){
			case 0:		// 指定なし
				$this->tmpl->addVar("_widget", "disp_align_none", 'selected');
				break;
			case 1:		// 左寄せ
				$this->tmpl->addVar("_widget", "disp_align_left", 'selected');
				break;	
			case 2:		// 中央
				$this->tmpl->addVar("_widget", "disp_align_center", 'selected');
				break;	
			case 3:		// 右寄せ
				$this->tmpl->addVar("_widget", "disp_align_right", 'selected');
				break;
		}
		
		// 画面モードの設定
		//$this->tmpl->addVar("_widget", "mode", $this->mode);
		
		// 選択中のバナーIDを設定
		$this->tmpl->addVar("_widget", "banner_id", $this->bannerId);
		if ($this->bannerId == 0){		// バナーIDが0のときは新規とする
			$this->tmpl->addVar("_widget", "sel_item_id", '新規');			// コンテンツID
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// コンテンツIDが0のときは新規追加をチェック状態にする
		} else {
			$this->tmpl->addVar("_widget", "sel_item_id", $this->bannerId);			// コンテンツID
		}
		$this->tmpl->addVar("_widget", "item_name", $name);		// 名前
		$this->tmpl->addVar("_widget", "banner_item", $bannerItem);	// バナー項目ID
		$this->tmpl->addVar("_widget", "disp_count", $dispCount);	// 表示項目数
		if (!empty($updateUser)) $this->tmpl->addVar("_widget", "update_user", $updateUser);	// 更新者
		if (!empty($updateDt)) $this->tmpl->addVar("_widget", "update_dt", $updateDt);	// 更新日時
	}
	/**
	 * バナー項目一覧
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createBannerItemList($request, &$param)
	{
		global $gEnvManager;
			
		// ユーザ情報、表示言語
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$defaultLang = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		if (empty($this->serialNo)) $this->serialNo = 0;
		
		$name = $request->trimValueOf('item_name');
		$linkUrl = $request->trimValueOf('item_link_url');
		$imageUrl = $request->trimValueOf('item_image_url');
		$image = $request->trimValueOf('item_image');
		$admin_note = $request->trimValueOf('item_admin_note');
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;			// 表示するかどうか
		$imageWidth = $request->trimValueOf('item_width');
		$imageHeight = $request->trimValueOf('item_height');
		$imageAlt = '';
		$srcHtml = '';
		
		if ($act == 'select'){		// 項目選択の場合
			if ($this->serialNo == 0){		// シリアル番号が0のときは、新規追加モードにする
				// 入力値初期化
				$name = '';		// 名前
				$linkUrl = '';		// リンク先
				$imageUrl = '';		// 画像URL
				$admin_note = '';		// 管理者用備考
				$visible = 1;		// デフォルトは表示状態
				$imageWidth = '';
				$imageHeight = '';
			} else {
				// 登録済みのバナー定義を取得
				$ret = $this->db->getBannerItemBySerial($this->serialNo, $row);
				if ($ret){
					// 取得値を設定
					$itemId = $row['bi_id'];		// ID
					$name = $row['bi_name'];		// 名前
					$linkUrl = $row['bi_link_url'];		// リンク先
					$imageUrl = $row['bi_image_url'];		// 画像URL
					$admin_note = $row['bi_admin_note'];		// 管理者用備考
					$visible = $row['bi_visible'];		// 表示
					$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
					$updateDt = $this->convertToDispDateTime($row['bi_create_dt']);	// 更新日時
					$imageWidth = $row['bi_image_width'];		// 画像幅
					$imageHeight = $row['bi_image_height'];		// 画像高さ
					$imageAlt = $row['bi_image_alt'];		// 画像テキスト
					$srcHtml = $row['bi_html'];		// HTML
				}
			}
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			//$this->checkNumeric($dispCount, '表示項目数');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// 画像タグの作成
				$html = '';
				if (!empty($imageUrl)){
					if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
						//$imageUrl = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRoot($gEnvManager->getDocumentRoot() . $imageUrl);
						$imageUrl = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRoot($gEnvManager->getDocumentRootUrl() . $imageUrl);
					}
					$html = '<img src="' . M3_TAG_START . M3_TAG_MACRO_IMG_URL . M3_TAG_END . '" width="' . $imageWidth . '" height="' . $imageHeight . '" />';
				}
				
				$ret = $this->db->updateBannerItem(0, $name, $admin_note, $imageUrl, $linkUrl, $imageWidth, $imageHeight, $imageAlt, $html, $visible, $startdt, $enddt, $userInfo->userId, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					// 入力値初期化
					$name = '';		// 名前
					$linkUrl = '';		// リンク先
					$imageUrl = '';		// 画像URL
					$admin_note = '';		// 管理者用備考
					$visible = 1;		// デフォルトは表示状態
					$imageWidth = '';
					$imageHeight = '';
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			
			if (!ValueCheck::isNumeric($imageWidth)){		// 数値かどうかのチェック
				$this->setAppErrorMsg('画像の幅は数字で指定してください');
			}
			if (!ValueCheck::isNumeric($imageHeight)){		// 数値かどうかのチェック
				$this->setAppErrorMsg('画像の高さは数字で指定してください');
			}			
			
			//$this->checkNumeric($dispCount, '表示項目数');
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// 画像タグの作成
				$html = '';
				if (!empty($imageUrl)){
					if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
						//$imageUrl = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRoot($gEnvManager->getDocumentRoot() . $imageUrl);
						$imageUrl = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRoot($gEnvManager->getDocumentRootUrl() . $imageUrl);
					}
					$html = '<img src="' . M3_TAG_START . M3_TAG_MACRO_IMG_URL . M3_TAG_END . '" width="' . $imageWidth . '" height="' . $imageHeight . '" />';
				}
				$ret = $this->db->updateBannerItem($this->serialNo, $name, $admin_note, $imageUrl, $linkUrl, $imageWidth, $imageHeight, $imageAlt, $html, $visible, $startdt, $enddt, $userInfo->userId, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 登録済みのバナー定義を取得
					$this->serialNo = $newSerial;
					$ret = $this->db->getBannerItemBySerial($this->serialNo, $row);
					if ($ret){
						// 取得値を設定
						$itemId = $row['bi_id'];		// ID
						$name = $row['bi_name'];		// 名前
						$linkUrl = $row['bi_link_url'];		// リンク先
						$imageUrl = $row['bi_image_url'];		// 画像URL
						$admin_note = $row['bi_admin_note'];		// 管理者用備考
						$visible = $row['bi_visible'];		// 表示
						$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
						$updateDt = $this->convertToDispDateTime($row['bi_create_dt']);	// 更新日時
						$imageWidth = $row['bi_image_width'];		// 画像幅
						$imageHeight = $row['bi_image_height'];		// 画像高さ
						$imageAlt = $row['bi_image_alt'];		// 画像テキスト
						$srcHtml = $row['bi_html'];		// HTML
					}
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				// IDを取得
				$ret = $this->db->getBannerItemBySerial($this->serialNo, $row);
				if ($ret){
					// 取得値を設定
					$itemId = $row['bi_id'];		// ID
				}
				$ret = $this->db->delBannerItem($this->serialNo, $userInfo->userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else {	// 初期表示
			// 入力値初期化
			$name = '';		// 名前
			$linkUrl = '';		// リンク先
			$imageUrl = '';		// 画像URL
			$admin_note = '';		// 名前
			$visible = 1;		// デフォルトは表示状態
			$imageWidth = '';
			$imageHeight = '';
		}
		// #### バナー項目リストを作成 ####
		$this->db->getBannerItemList(array($this, 'bannerItemListLoop'));

		// #### 更新、新規登録部をを作成 ####
		// 入力フィールドの設定、共通項目のデータ設定
		if ($this->serialNo == 0){
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
		} else {
			// データ更新、削除ボタン表示
			$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// デフォルト言語以外はデータ削除
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
		}
		// 選択中のバナーIDを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		if ($this->serialNo == 0){		// シリアル番号が0のときは新規とする
			$this->tmpl->addVar("_widget", "item_id", '新規');			// バナー項目ID
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// 新規追加をチェック状態にする
		} else {
			$this->tmpl->addVar("_widget", "item_id", $itemId);
		}
		$this->tmpl->addVar("_widget", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "image_url", $imageUrl);		// 画像イメージURL
		$this->tmpl->addVar("_widget", "link_url", $linkUrl);		// リンク先
		$this->tmpl->addVar("_widget", "admin_note", $admin_note);		// 備考
		$visibleStr = '';
		if ($visible){	// 項目の表示
			$visibleStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "visible", $visibleStr);		// 表示状態
		if (!empty($updateUser)) $this->tmpl->addVar("_widget", "update_user", $updateUser);	// 更新者
		if (!empty($updateDt)) $this->tmpl->addVar("_widget", "update_dt", $updateDt);	// 更新日時
		
		// バナー表示イメージの作成
		$destImg = '';
		if (empty($imageUrl)){
			$destImg = '<img id="preview_img" style="display:none;" />';
			//$destImg .= $html = '<img id="preview_img" width="0" height="0" />';
		} else {
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl);
			$destImg = '<img id="preview_img" src="' . $imgUrl . '" ';
			if (!empty($imageWidth) && $imageWidth > 0) $destImg .= 'width="' . $imageWidth . '"';
			if (!empty($imageHeight) && $imageHeight > 0) $destImg .= ' height="' . $imageHeight. '"';
			$destImg .= ' />';
		}
		$this->tmpl->addVar("_widget", "image", $destImg);
		$this->tmpl->addVar("_widget", "width", $imageWidth);
		$this->tmpl->addVar("_widget", "height", $imageHeight);
		
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "widget_sc_url", $gEnvManager->getCurrentWidgetScriptsUrl());
		$this->tmpl->addVar("_widget", "image_path", $gEnvManager->getRootUrl() . '/resource/');		// 画像の格納場所
		
		// バナー項目IDを設定
		$idArray = '';
		if (!empty($this->dispIdArray)) $idArray = implode($this->dispIdArray, ',');
		$this->tmpl->addVar("_widget", "item_serials", $idArray);
	}
	/**
	 * バナー項目選択画面
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createSelBannerItem($request, &$param)
	{
		global $gEnvManager;
			
		// ユーザ情報、表示言語
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$defaultLang = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		// #### バナー項目リストを作成 ####
		$this->db->getBannerItemList(array($this, 'bannerItemListLoop'));
		
		// バナー項目IDを設定
		$idArray = '';
		if (!empty($this->dispIdArray)) $idArray = implode($this->dispIdArray, ',');
		$this->tmpl->addVar("_widget", "item_id", $idArray);
	}
	
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['bd_id']);
		$selected = '';
		if ($id == $this->bannerId){
			$selected = 'checked';
		}
		// 表示方法
		$dispType = '';
		switch ($fetchedRow['bd_disp_type']){
			case 0:
				$dispType = '順次';
				break;
			case 1:
				$dispType = 'ランダム';
				break;
		}
		// 表示方向
		$dispDirect = '';
		switch ($fetchedRow['bd_disp_direction']){
			case 0:
				$dispDirect = '縦';
				break;
			case 1:
				$dispDirect = '横';
				break;
		}		
		
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $serial,												// シリアル番号
			'id' => $id,														// ID
			'name' => $this->convertToDispString($fetchedRow['bd_name']),		// 名前
			'banner_item' => $this->convertToDispString($fetchedRow['bd_item_id']),		// バナー項目ID
			'disp_type' => $dispType,											// 表示タイプ
			'disp_direct' => $dispDirect,										// 表示方向
			'disp_count' => $fetchedRow['bd_disp_item_count'],					// 表示項目数
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['bd_update_dt']),	// 更新日時
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function bannerItemListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$serial = $this->convertToDispString($fetchedRow['bi_serial']);
		$selected = '';
		if ($serial == $this->serialNo){
			$selected = 'checked';
		}
		$visible = '';
		if ($fetchedRow['bi_visible']){	// 項目の表示
			$visible = 'checked';
		}
		// ファイル名取得
		$partArray = explode('/', $fetchedRow['bi_image_url']);
		if (count($partArray) > 0) $filename = $partArray[count($partArray)-1];
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $serial,								// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['bi_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['bi_name']),		// 名前
			'filename' => $filename,
//			'banner_item' => $this->convertToDispString($fetchedRow['bd_item_id']),		// バナー項目ID
//			'disp_type' => $dispType,											// 表示タイプ
//			'disp_direct' => $dispDirect,										// 表示方向
//			'disp_count' => $fetchedRow['bd_disp_item_count'],					// 表示項目数
			'visible' => $visible,											// 項目の表示
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['bi_create_dt']),	// 更新日時
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// バナー項目IDを保存
		$this->dispIdArray[] = $fetchedRow['bi_id'];
		//$this->dispIdArray[] = $fetchedRow['bi_serial'];
		return true;
	}
}
?>