<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/viewDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class ec_mainProductWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $viewStyle;		// 表示スタイル
	private $categoryId;		// カテゴリーID
	private $productId;			// 製品ID
	private $defaultImageSWidth;		// 画像小幅
	private $defaultImageSHeight;		// 画像小高さ
	private $defaultImageMWidth;		// 画像中幅
	private $defaultImageMHeight;		// 画像中高さ
	private $productExists;				// 商品が存在するかどうか
	private $subcategoryExists;				// サブカテゴリーが存在するかどうか
	private $currentPageUrl;			// 現在のページURL
	private $ecObj;					// EC共通ライブラリオブジェクト
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const STANDARD_PRICE = 'selling';		// 通常価格
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	const PRODUCT_STATUS_NEW = 'new';		// 商品ステータス新規
	const PRODUCT_STATUS_SUGGEST = 'suggest';		// 商品ステータスおすすめ
	const DEFAULT_TAX_TYPE = 'sales';			// デフォルト税種別
	const VIEW_STYLE_SMALL = 'small';			// 表示スタイル(小)
	const VIEW_STYLE_MEDIUM = 'medium';			// 表示スタイル(中)
	const THIS_WIDGET_ID = 'ec_main';		// ウィジェットID
	const DEFAULT_LIST_COUNT = 5;			// 最大リスト表示数
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new viewDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		$value = $request->trimValueOf('product');
		if ($act == 'inputbasketbylist'){		// 商品リストからの選択の場合
			return 'main.tmpl.html';
		} else {
			if (empty($value)){		// 商品一覧のとき
				return 'main.tmpl.html';
			} else {			// 商品詳細表示
				return 'main_detail.tmpl.html';
			}
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gInstanceManager;
		global $gAccessManager;
		
		// 現在日時を取得
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間

		// ユーザ情報、表示言語
		//$userInfo		= $gEnvManager->getCurrentUserInfo();
		$currentLang	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		
		// 表示モードを取得
		$this->viewStyle = $request->trimValueOf(M3_REQUEST_PARAM_VIEW_STYLE);		// 表示モード
		if (empty($this->viewStyle)) $this->viewStyle = self::VIEW_STYLE_MEDIUM;
		
		// 現在のページURL
		$this->currentPageUrl = $gEnvManager->createCurrentPageUrl();
		
		// 画像情報を取得
		$this->defaultImageSWidth = 0;
		$this->defaultImageSHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_SMALL, $row);
		if ($ret){
			$this->defaultImageSWidth = $row['is_width'];
			$this->defaultImageSHeight = $row['is_height'];
		}
		$this->defaultImageMWidth = 0;
		$this->defaultImageMHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_MEDIUM, $row);
		if ($ret){
			$this->defaultImageMWidth = $row['is_width'];
			$this->defaultImageMHeight = $row['is_height'];
		}
		$this->defaultImageLWidth = 0;
		$this->defaultImageLHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_LARGE, $row);
		if ($ret){
			$this->defaultImageLWidth = $row['is_width'];
			$this->defaultImageLHeight = $row['is_height'];
		}
				
		// パラメータを取得
		$this->categoryId = $request->trimValueOf('category');	// カテゴリーID
		$this->productId = $request->trimValueOf('product');			// 製品ID
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		$quantity = $request->trimValueOf('item_quantity');		// 数量
		if (empty($quantity)) $quantity = 1;
		
		// DBの保存設定値を取得
		$maxListCount = self::DEFAULT_LIST_COUNT;
		$serializedParam = $gInstanceManager->getSytemDbObject()->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$maxListCount = $dispInfo->maxListCount;		// リスト最大表示数
		}
		
		$act = $request->trimValueOf('act');
		if ($act == 'inputbasket' || $act == 'inputbasketbylist'){			// カートに入れる処理の場合
			// クッキー読み込み、カートIDを取得
			$cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
			if ($cartId == ''){	// カートIDが設定されていないとき
				// カートIDを生成
				$cartId = $this->ecObj->createCartId();
			}
			$request->setCookieValue(M3_COOKIE_CART_ID, $cartId);

			// ####### カートに商品を追加 ########
			// 商品名と価格を取得
			if (!empty($this->productId)){
				// カートの情報を取得
				$cart_serial = 0;		// カートシリアル番号
				$cart_item_serial = 0;	// カート商品シリアル番号
				$userId = $gEnvManager->getCurrentUserId();
				$ret = $this->db->getCartHead($cartId, $currentLang, $row);
				if ($ret){
					$cart_serial = $row['sh_serial'];
					if ($userId == 0) $userId = $row['sh_id'];
				}
				
				// 商品情報を取得
				$isValidItem = true;		// 現在のカートのデータが有効かどうか
				$ret = $this->db->getProductByProductId($this->productId, $currentLang, $row, $row2, $row3, $row4);
				if ($ret){
					// 価格を取得
					$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
					$price = $priceArray['pp_price'];	// 価格
					$currency = $priceArray['pp_currency_id'];	// 通貨
					$taxType = $row['pt_tax_type_id'];					// 税種別			

					// 価格作成
					$this->ecObj->setCurrencyType($currency, $currentLang);		// 通貨設定
					$this->ecObj->setTaxType($taxType, $currentLang);		// 税種別設定
					$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
				} else {		// 商品情報が取得できないときは、カートの商品をキャンセル
					$isValidItem = false;
				}
				// カートにある商品を取得
				if ($isValidItem && $cart_serial > 0){
					$ret = $this->db->getCartItem($cart_serial, $this->productId, $cartItemRow);
					if ($ret){		// 取得できたときは価格をチェック
						if ($cartItemRow['si_available']){		// データが有効のとき
							// 価格が変更されているときはカートの商品を無効にする
							$cart_item_currency = $cartItemRow['si_currency_id'];
							$cart_item_quantity = $cartItemRow['si_quantity'];
							$cart_item_price = $cartItemRow['si_subtotal'];
							$cart_item_serial = $cartItemRow['si_serial'];
							
							if ($cart_item_currency != $currency) $isValidItem = false;		// 通貨が変更のときはレコードを無効化
							if ($totalPrice * $cart_item_quantity != $cart_item_price) $isValidItem = false;		// 価格が変更のときはレコードを無効化
						} else {
							$isValidItem = false;
						}
					}
				}
				// カート商品情報を更新
				if ($isValidItem){
					// カートに商品を追加
					$ret = $this->db->addProductToCart($cart_serial, $cart_item_serial, $cartId, $this->productId, $currentLang, $currency, $totalPrice, $quantity, $userId);
					/*if ($ret){		// データ更新成功のとき
						$this->setGuidanceMsg('データを更新しました');
					} else {
						$this->setAppErrorMsg('データ更新に失敗しました');
					}*/
				} else {
					// カート商品の無効化
					$ret = $this->db->voidProductInCart($cart_serial, $cart_item_serial);
					/*if ($ret){		// データ更新成功のとき
						$this->setGuidanceMsg('データを更新しました');
					} else {
						$this->setAppErrorMsg('データ更新に失敗しました');
					}*/
				}
			}
			// 商品一覧からの選択の場合は製品IDをリセット
			if ($act == 'inputbasketbylist') $this->productId = 0;
		}
		if (empty($this->productId)){		// 商品一覧表示のとき
			// カテゴリーリストを取得
			if (!empty($this->categoryId)) $this->db->getCategoryList($this->categoryId, $currentLang, array($this, 'categoryListLoop'));
	
			// 指定カテゴリーの商品を取得
			if (!empty($this->categoryId)){
				// 総数を取得
				$totalCount = $this->db->getProductCountByCategoryId($this->categoryId, $currentLang, 1);
				$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数
			
				// 表示するページ番号の修正
				if ($pageNo < 1) $pageNo = 1;
				if ($pageNo > $pageCount) $pageNo = $pageCount;

				// 商品リストを表示
				$this->db->getProductByCategoryId($this->categoryId, $currentLang, 1, $maxListCount, ($pageNo -1) * $maxListCount, array($this, 'productListLoop'));
			
				// ページング用リンク作成
				$pageLink = '';
				if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
					for ($i = 1; $i <= $pageCount; $i++){
						$linkUrl = $this->currentPageUrl . '&category=' . $this->categoryId . '&page=' . $i;
						if ($i == $pageNo){
							$link = '&nbsp;' . $i;
						} else {
							$link = '&nbsp;<a href="' . $linkUrl . '" >' . $i . '</a>';
						}
						$pageLink .= $link;
					}
				}
				$this->tmpl->addVar("show_productlist", "page_link", $pageLink);
			}
		
			// サブカテゴリーと商品リストの表示制御
			// サブカテゴリーがあるかチェック
			if ($this->subcategoryExists) $this->tmpl->setAttribute('show_subcategory', 'visibility', 'visible');
			// 商品があるかチェック
			if ($this->productExists) $this->tmpl->setAttribute('show_productlist', 'visibility', 'visible');
			// 登録項目がないとき
			if (!empty($this->categoryId) && !$this->subcategoryExists && !$this->productExists) $this->tmpl->setAttribute('no_item_message', 'visibility', 'visible');
		} else {		// 商品詳細表示のとき
			$ret = $this->db->getProductByProductId($this->productId, $currentLang, $row, $row2, $row3, $row4);
			if ($ret){
				// 取得値を設定
				//$this->serialNo = $row['pt_serial'];		// シリアル番号
				$this->productId = $row['pt_id'];	// 商品ID
				//$this->langId = $row['pt_language_id'];

				$unitTypeId = $row['pt_unit_type_id'];	// 単位
				// 単位情報を取得
				$unitType = '';
				if ($this->db->getUnitTypeRecord($unitTypeId, $currentLang, $unitRow)){
					$unitType = $unitRow['ut_symbol'];
				}
				$unitQuantity = $row['pt_unit_quantity'];		// 数量
				$description = $row['pt_description'];			// 説明
				$description_short = $row['pt_description_short'];		// 簡易説明
				//$keyword = $row['pt_search_keyword'];					// 検索キーワード
				$url = $row['pt_site_url'];							// 詳細情報URL
				$this->taxType = $row['pt_tax_type_id'];					// 税種別
				//$adminNote = $row['pt_admin_note'];		// 管理者用備考
			
				// 価格を取得
				$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
				$price = $priceArray['pp_price'];	// 価格
				$currency = $priceArray['pp_currency_id'];	// 通貨
				$taxType = $row['pt_tax_type_id'];					// 税種別
				$lang = $row['pt_language_id'];					// 言語				

				// 表示額作成
				$this->ecObj->setCurrencyType($currency, $lang);		// 通貨設定
				$this->ecObj->setTaxType($taxType, $lang);		// 税種別設定
				$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
			
				// 画像を取得
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
				$imageUrl_s = $imageArray['im_url'];	// URL
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
				$imageUrl_m = $imageArray['im_url'];	// URL
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
				$imageUrl_l = $imageArray['im_url'];	// URL
							
				// 商品ステータスを取得
				$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
				$new = $statusArray['ps_value'];
				$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
				$suggest = $statusArray['ps_value'];
			
				// 画像中
				$destImg_m = '';
				if ($this->viewStyle == self::VIEW_STYLE_MEDIUM){
					if (empty($imageUrl_m)){
						$destImg_m = '<img id="preview_img_medium" style="display:none;" ';
						$destImg_m .= 'width="' . $this->defaultImageMWidth . '" ';
						$destImg_m .= 'height="' . $this->defaultImageMHeight . '" ';
						$destImg_m .= '/>';
					} else {
						// URLマクロ変換
						$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_m);
						$destImg_m = '<img id="preview_img_medium" src="' . $imgUrl . '" ';
						$destImg_m .= 'width="' . $this->defaultImageMWidth . '"';
						$destImg_m .= ' height="' . $this->defaultImageMHeight . '"';
						$destImg_m .= ' />';
					}
				}
				// 画像大
				$destImg_l = '';
				if ($this->viewStyle == self::VIEW_STYLE_MEDIUM){
					if (empty($imageUrl_l)){
						$destImg_l = '<img id="preview_img_large" style="display:none;" ';
						$destImg_l .= 'width="' . $this->defaultImageLWidth . '" ';
						$destImg_l .= 'height="' . $this->defaultImageLHeight . '" ';
						$destImg_l .= '/>';
					} else {
						// URLマクロ変換
						$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_l);
						$destImg_l = '<img id="preview_img_large" src="' . $imgUrl . '" ';
						$destImg_l .= 'width="' . $this->defaultImageLWidth . '"';
						$destImg_l .= ' height="' . $this->defaultImageLHeight . '"';
						$destImg_l .= ' />';
					}
				}
			
				$this->tmpl->addVar("_widget", "name", $row['pt_name']);		// 名前
				$this->tmpl->addVar("_widget", "code", $row['pt_code']);		// 商品コード
				$this->tmpl->addVar("_widget", "unit_type", $unitType);		// 単位タイプ
				$this->tmpl->addVar("_widget", "quantity", '1');		// 数量デフォルト値
				$this->tmpl->addVar("_widget", "description", $row['pt_description']);		// 説明
				$this->tmpl->addVar("_widget", "desc_short", $row['pt_description_short']);		// 簡易説明		

				$this->tmpl->addVar("_widget", "url", $url);				// 詳細情報URL
				//$this->tmpl->addVar("_widget", "admin_note", $adminNote);			// 管理者用備考
				$this->tmpl->addVar("_widget", "disp_total_price", $dispPrice);		// 税込み価格
				$this->tmpl->addVar("_widget", "image_m", $destImg_m);		// 画像
				$this->tmpl->addVar("_widget", "image_l", $destImg_l);		// 画像
			}
		}
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function categoryListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// リンクを作成
		$name = $this->convertToDispString($fetchedRow['pc_name']);		// 名前
		$linkUrl = $this->currentPageUrl . '&category=' . $fetchedRow['pc_id'];
		$link = '<a href="' . $linkUrl . '" >' . $name . '</a>';
		
		$row = array(
			'category_link' => $link
		);
		$this->tmpl->addVars('subcategory', $row);
		$this->tmpl->parseTemplate('subcategory', 'a');
		
		// 表示中のコンテンツIDを保存
		//$this->dispContIdArray[] = $fetchedRow['pc_id'];
		
		$this->subcategoryExists = true;				// サブカテゴリーが存在するかどうか
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['pt_id']);
		$selected = '';
		if ($id == $this->productId){
			$selected = 'checked';
		}
		
		$visible = '';
		if ($fetchedRow['pt_visible']){	// 項目の表示
			$visible = 'checked';
		}
		
		// 商品の詳細情報を取得
		$ret = $this->db->getProductBySerial($fetchedRow['pt_serial'], $row, $row2, $row3, $row4);
		if ($ret){
		/*
			// 取得値を設定
			$this->productId = $row['pt_id'];	// 商品ID
			$this->langId = $row['pt_language_id'];
			$name = $row['pt_name'];		// 名前
			$code = $row['pt_code'];		// 商品コード
			$index = $row['pt_sort_order'];	// 表示順
			$visible = $row['pt_visible'];	// 表示状態
			$this->unitTypeId = $row['pt_unit_type_id'];	// 単位
			$unitQuantity = $row['pt_unit_quantity'];		// 数量
			$description = $row['pt_description'];			// 説明
			$description_short = $row['pt_description_short'];		// 簡易説明
			$keyword = $row['pt_search_keyword'];					// 検索キーワード
			$url = $row['pt_site_url'];							// 詳細情報URL
			
			$adminNote = $row['pt_admin_note'];		// 管理者用備考
			$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
			$updateDt = $this->convertToDispDateTime($row['pt_create_dt']);	// 更新日時
*/			
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
			$lang = $row['pt_language_id'];					// 言語

			// 表示額作成
			$this->ecObj->setCurrencyType($currency, $lang);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $lang);		// 税種別設定
			$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
			
			// 画像を取得
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
			$imageUrl_s = $imageArray['im_url'];	// URL
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
			$imageUrl_m = $imageArray['im_url'];	// URL
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
			$imageUrl_l = $imageArray['im_url'];	// URL
						
			// 商品ステータスを取得
			$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
			$new = $statusArray['ps_value'];
			$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
			$suggest = $statusArray['ps_value'];
		}
					
		// 画像小
		$destImg_s = '';
		if ($this->viewStyle == self::VIEW_STYLE_SMALL){
			if (empty($imageUrl_s)){
				$destImg_s = '<img id="preview_img_small" style="display:none;" ';
				$destImg_s .= 'width="' . $this->defaultImageSWidth . '" ';
				$destImg_s .= 'height="' . $this->defaultImageSHeight . '" ';
				$destImg_s .= '/>';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_s);
				$destImg_s = '<img id="preview_img_small" src="' . $imgUrl . '" ';
				$destImg_s .= 'width="' . $this->defaultImageSWidth . '"';
				$destImg_s .= ' height="' . $this->defaultImageSHeight . '"';
				$destImg_s .= ' />';
			}
		}
		// 画像中
		$destImg_m = '';
		if ($this->viewStyle == self::VIEW_STYLE_MEDIUM){
			if (empty($imageUrl_m)){
				$destImg_m = '<img id="preview_img_medium" style="display:none;" ';
				$destImg_m .= 'width="' . $this->defaultImageMWidth . '" ';
				$destImg_m .= 'height="' . $this->defaultImageMHeight . '" ';
				$destImg_m .= '/>';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_m);
				$destImg_m = '<img id="preview_img_medium" src="' . $imgUrl . '" ';
				$destImg_m .= 'width="' . $this->defaultImageMWidth . '"';
				$destImg_m .= ' height="' . $this->defaultImageMHeight . '"';
				$destImg_m .= ' />';
			}
		}
		// 画像大
		$destImg_l = '';
		if ($this->viewStyle == self::VIEW_STYLE_MEDIUM){
			if (empty($imageUrl_l)){		// 画像が空のとき
				$destImg_l = '<img id="preview_img_large" style="display:none;" ';
				$destImg_l .= 'width="' . $this->defaultImageLWidth . '" ';
				$destImg_l .= 'height="' . $this->defaultImageLHeight . '" ';
				$destImg_l .= '/>';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_l);
				$imageUrl_l = $imgUrl;
				$destImg_l = '<img id="preview_img_large" src="' . $imgUrl . '" ';
				$destImg_l .= 'width="' . $this->defaultImageLWidth . '"';
				$destImg_l .= ' height="' . $this->defaultImageLHeight . '"';
				$destImg_l .= ' />';
			}
		}
		// 商品詳細リンクを作成
		$name = '詳細';		// 名前
		$linkUrl = $this->currentPageUrl . '&product=' . $fetchedRow['pt_id'];
		$link = '<a href="' . $linkUrl . '" >' . $name . '</a>';
		
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['pt_serial']),	// シリアル番号
			'id' => $id,			// ID
			'image_s' => $destImg_s,		// 画像
			'image_m' => $destImg_m,		// 画像
			'image_l_url' => $imageUrl_l,		// 画像URL
			'name' => $this->convertToDispString($fetchedRow['pt_name']),		// 名前
			'code' => $this->convertToDispString($fetchedRow['pt_code']),		// 商品コード
			'disp_total_price' => $dispPrice,				// 税込み価格
			'description_short' => $row['pt_description_short'],				// 簡易説明
			'product_link' => $link												// 商品詳細リンク
		);
		$this->tmpl->addVars('productlist', $row);
		$this->tmpl->parseTemplate('productlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->dispContIdArray[] = $fetchedRow['pt_id'];
		
		$this->productExists = true;				// 商品が存在するかどうか
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 画像取得
	 *
	 * @param array  	$srcRows			画像リスト
	 * @param string	$imageType			画像タイプ
	 * @return array						取得した行
	 */
	function getImage($srcRows, $sizeType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['im_size_id'] == $sizeType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 商品ステータス取得
	 *
	 * @param array  	$srcRows			取得行
	 * @param string	$type			商品ステータスタイプ
	 * @return array						取得した行
	 */
	function getStatus($srcRows, $type)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['ps_type'] == $type){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
