<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
//require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_mainRegistDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_mainMemberDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class ec_mainRegmemberWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $state;		// 都道府県
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const THIS_WIDGET_ID = 'ec_main';
	const USE_EMAIL		= 'use_email';		// EMAIL機能が使用可能かどうか
	const SHOP_EMAIL	= 'shop_email';		// ショップEmailアドレス
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
	const REGIST_MEMBER_FORM = 'regist_member';		// パスワード送信用フォーム
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		//$this->db = new ec_mainRegistDb();
		$this->db = new ec_mainMemberDb();
		$this->mainDb = new ec_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'regmember.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gMailManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$currentLang	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$firstname = $request->trimValueOf('item_firstname');			// 名前(名)
		$familyname = $request->trimValueOf('item_familyname');			// 名前(姓)
		$firstnameKana = $request->trimValueOf('item_firstname_kana');		// 名前カナ(名)
		$familynameKana = $request->trimValueOf('item_familyname_kana');	// 名前カナ(姓)
		$zipcode = $request->trimValueOf('item_zipcode');	// 郵便番号
		$this->state = $request->trimValueOf('item_state');	// 都道府県
		$address = $request->trimValueOf('item_address');	// 住所
		$phone = $request->trimValueOf('item_phone');	// 電話番号
		$fax = $request->trimValueOf('item_fax');	// FAX
		$email = $request->trimValueOf('item_email');	// Email
		$email2 = $request->trimValueOf('item_email2');	// Email確認用
			
		$act = $request->trimValueOf('act');
		if ($act == 'check'){			// 会員情報エラーチェック	
			$this->checkInput($familyname, '名前(姓)');		
			$this->checkInput($firstname, '名前(名)');
			$this->checkInput($familynameKana, '名前カナ(姓)');
			$this->checkInput($firstnameKana, '名前カナ(名)');
			$this->checkSingleByte($zipcode, '郵便番号');
			$this->checkNumeric($this->state, '都道府県');
			$this->checkInput($address, '住所');	
			$this->checkSingleByte($phone, '電話番号');
			if (!empty($fax)) $this->checkSingleByte($fax, 'FAX');// 空のときはチェックしない
			$this->checkMailAddress($email, 'Eメール');
			$this->checkMailAddress($email2, 'Eメール(確認)');
			if ($this->getMsgCount() == 0){			// メールアドレスのチェック
				if ($email != $email2){
					$this->setAppErrorMsg('Eメールアドレスに誤りがあります');
				} else if ($this->sysDb->isExistsAccount($email)){// メールアドレスがログインIDとして既に登録されているかチェック
					$this->setAppErrorMsg('このEメールアドレスは既に登録されています');
				}
			}
			
			// エラーなしの場合は、確認画面へ
			if ($this->getMsgCount() == 0){
				// 入力値を変更不可にする
				$this->tmpl->addVar("_widget", "firstname_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "familyname_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "firstname_kana_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "familyname_kana_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "zipcode_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "address_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "phone_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "fax_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "email_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "email2_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "state_disabled", 'readonly');
				
				// 確認ボタンを表示
				$this->tmpl->addVar("_widget", "message", 'この内容で登録しますか？');		// 確認メッセージ
				$this->tmpl->setAttribute('show_confirm', 'visibility', 'visible');
			} else {
				// 入力完了ボタンを表示
				$this->tmpl->setAttribute('show_input', 'visibility', 'visible');
			}
		} else if ($act == 'regist'){			// 会員情報登録
			// パスワード生成
			$password = $this->makePassword();

			// トランザクションスタート
			$this->db->startTransaction();
			
			// アカウントの重複チェック
			$ret = !$this->sysDb->isExistsAccount($email);

			// ログインユーザを作成
			if ($ret){
				$userId = 0;
				$ret = $this->db->addUser(0/* 仮会員 */, $familyname . $firstname, $email, $password, self::THIS_WIDGET_ID, $userId, $now, $loginUserId);		// 新規ログインユーザIDを取得
			}

			// 住所登録
			if ($ret) $ret = $this->db->updateAddress(0, $langId, '', $zipcode, $this->state, $address, '', $phone, $fax, $countryId, $userId, $now, $addressId);

			// 個人情報登録
			$gender = 0;		// 未設定
			$birthday = $gEnvManager->getInitValueOfTimestamp();
			if ($ret) $ret = $this->db->updatePersonInfo(0, $langId, $firstname, $familyname, $firstnameKana, $familynameKana, $gender, $birthday, $email, '', $addressId, $userId, $now, $personalInfoId);

			// 仮会員情報を登録
			if ($ret) $ret = $this->db->addTmpMember($langId, 1, 0, $personalInfoId, $loginUserId, $loginUserId, $now);
			
			// トランザクション終了
			$ret = $this->db->endTransaction();
			if ($ret){
				// ####### 会員登録完了のメールを送信する #######
				
				// 入力値を変更不可にする
				$this->tmpl->addVar("_widget", "firstname_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "familyname_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "firstname_kana_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "familyname_kana_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "zipcode_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "address_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "phone_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "fax_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "email_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "email2_disabled", 'readonly');
				$this->tmpl->addVar("_widget", "state_disabled", 'readonly');
				
				// メール送信許可のときはメールを送信
				if ($this->mainDb->getConfig(self::USE_EMAIL) == '1'){
					$fromAddress = $this->mainDb->getConfig(self::AUTO_EMAIL_SENDER);	// 自動送信送信元
					$toAddress = $email;			// eメール(ログインアカウント)
					$mailParam = array();
					$mailParam['PASSWORD'] = $password;
					$ret = $gMailManager->sendFormMail(1, self::THIS_WIDGET_ID, $toAddress, $fromAddress, '', '', self::REGIST_MEMBER_FORM, $mailParam);// 自動送信
					$this->tmpl->addVar("_widget", "message", '登録完了しました。指定のメールアドレス宛てにパスワードが送信されます。<br>再度ログインしてください。');
				} else {
					$this->tmpl->addVar("_widget", "message", '登録完了しました。再度ログインしてください。パスワード:' . $password);
				}
					
				// ログイン画面への遷移ボタンを表示
				$this->tmpl->setAttribute('show_complete', 'visibility', 'visible');
			} else {
				$this->tmpl->addVar("_widget", "message", '登録に失敗しました。再度実行してください。');		// 確認メッセージ
				
				// 入力完了ボタンを表示
				$this->tmpl->setAttribute('show_input', 'visibility', 'visible');
			}
		} else {		// 初期状態のとき
			// 入力完了ボタンを表示
			$this->tmpl->setAttribute('show_input', 'visibility', 'visible');
		}
		// 入力値を戻す
		$this->tmpl->addVar("_widget", "firstname", $firstname);
		$this->tmpl->addVar("_widget", "familyname", $familyname);
		$this->tmpl->addVar("_widget", "firstname_kana", $firstnameKana);
		$this->tmpl->addVar("_widget", "familyname_kana", $familynameKana);
		$this->tmpl->addVar("_widget", "zipcode", $zipcode);
		$this->tmpl->addVar("_widget", "address", $address);
		$this->tmpl->addVar("_widget", "phone", $phone);
		$this->tmpl->addVar("_widget", "fax", $fax);
		$this->tmpl->addVar("_widget", "email", $email);
		$this->tmpl->addVar("_widget", "email2", $email2);
			
		// 都道府県を設定
		$this->db->getAllState('JPN', $langId, array($this, 'stateLoop'));
		
		$this->tmpl->addVar("_widget", "login_url", $gEnvManager->createCurrentPageUrl() . '&task=login');		// ログイン用URL
//		$this->tmpl->addVar("_widget", "input_url", $gEnvManager->getCurrentScriptUrl() . '?sub=shop&task=input');		// 入力用URL
		$this->tmpl->addVar("_widget", "regist_url", $gEnvManager->createCurrentPageUrl() . '&task=regmember');		// 会員登録用URL
	}
	/**
	 * 取得した都道府県をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function stateLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['gz_id'] == $this->state){		// 選択中の都道府県
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['gz_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['gz_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('state_list', $row);
		$this->tmpl->parseTemplate('state_list', 'a');
		return true;
	}
}
?>
