<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_product_displayDb.php');

class admin_ec_product_displayWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	var $categoryId;		// カテゴリーID
	var $categoryPathArray;	// 選択中のカテゴリーの階層
	private $selSubIndex;		// 選択中の表題インデックス
	private $idArray = array();		// 表示中のID
	private $currentSubList = array();		// 現在の選択中の表題に属する商品項目リスト
	private $imgSize;			// 選択中の画像サイズ
	const MAX_HIER_LEVEL = 20;		// カテゴリー階層最大値
	const DEFAULT_ROW_COUNT = 2;			// 表示する行の数
	const DEFAULT_COLUMN_COUNT = 3;			// 表示する列の数
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_product_displayDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userInfo		= $gEnvManager->getCurrentUserInfo();
		$this->langId	= $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得

		// デフォルト値設定
		$this->selIndex = 0;			// 現在の表題
		$title = 'おすすめ';	// タイトル
		$detailLabel = 'もっと詳しく...';	// 詳細へのリンク
		$isVisibleAnytime = 0;		// 常に表示するかどうか
		$rowCount = self::DEFAULT_ROW_COUNT;			// 表示する行の数
		$columnCount = self::DEFAULT_COLUMN_COUNT;			// 表示する列の数
		$this->imgSize = self::PRODUCT_IMAGE_MEDIUM;				// 選択中の画像サイズ
		$nameVisible = 1;			// 商品名表示
		$codeVisible = 0;			// 商品コード表示
		$priceVisible = 1;			// 商品価格表示
		$descVisible = 0;			// 商品説明表示
		$imgVisible = 1;			// 商品画像表示
		$detailVisible = 0;			// 詳細ボタン表示
		
		$viewStyleType = 0;		// 表示形式(0=画像+商品名称,1=画像+商品説明)
		$useComment = 0;		// コメント欄を表示するかどうか
		$commentPos = 0;		// コメント欄の位置(0=下、1=上)
			
		// 保存値を取得
		$paramObj = $this->getWidgetParamObj();
		if (empty($paramObj)){
			$paramObj = array();
			$paramObj[] = new stdClass;
			$paramObj[0]->title	= $title;// タイトル
			$paramObj[0]->detailLabel	= $detailLabel;// 詳細へのリンク
			$paramObj[0]->rowCount	= $rowCount;			// 表示する行の数
			$paramObj[0]->columnCount	= $columnCount;			// 表示する列の数
			$paramObj[0]->imgSize	= $this->imgSize;				// 選択中の画像サイズ
			$paramObj[0]->nameVisible	= $nameVisible;			// 商品名表示
			$paramObj[0]->codeVisible	= $codeVisible;			// 商品コード表示
			$paramObj[0]->priceVisible	= $priceVisible;			// 商品価格表示
			$paramObj[0]->descVisible	= $descVisible;			// 商品説明表示
			$paramObj[0]->imgVisible	= $imgVisible;			// 商品画像表示
			$paramObj[0]->detailVisible	= $detailVisible;			// 詳細ボタン表示
		} else {
			// 格納領域が小さいときは拡大
			for ($i = 0; $i < $this->selIndex - count($paramObj) + 1; $i++){
				$newObj = new stdClass;
				$newObj->title	= $title;// タイトル
				$newObj->detailLabel	= $detailLabel;// 詳細へのリンク
				$newObj->rowCount	= $rowCount;			// 表示する行の数
				$newObj->columnCount	= $columnCount;			// 表示する列の数
				$newObj->imgSize	= $this->imgSize;				// 選択中の画像サイズ
				$newObj->nameVisible	= $nameVisible;			// 商品名表示
				$newObj->codeVisible	= $codeVisible;			// 商品コード表示
				$newObj->priceVisible	= $priceVisible;			// 商品価格表示
				$newObj->descVisible	= $descVisible;			// 商品説明表示
				$newObj->imgVisible	= $imgVisible;			// 商品画像表示
				$newObj->detailVisible	= $detailVisible;			// 詳細ボタン表示
				$paramObj[] = $newObj;
			}
			$this->currentSubList = $paramObj[$this->selIndex]->subList;
			$title			= $paramObj[$this->selIndex]->title;// タイトル
			$detailLabel	= $paramObj[$this->selIndex]->detailLabel;// 詳細へのリンク
			$rowCount		= $paramObj[$this->selIndex]->rowCount;			// 表示する行の数
			$columnCount	= $paramObj[$this->selIndex]->columnCount;			// 表示する列の数
			$this->imgSize	= $paramObj[$this->selIndex]->imgSize;				// 選択中の画像サイズ
			$nameVisible	= $paramObj[$this->selIndex]->nameVisible;			// 商品名表示
			$codeVisible	= $paramObj[$this->selIndex]->codeVisible;			// 商品コード表示
			$priceVisible	= $paramObj[$this->selIndex]->priceVisible;			// 商品価格表示
			$descVisible	= $paramObj[$this->selIndex]->descVisible;			// 商品説明表示
			$imgVisible		= $paramObj[$this->selIndex]->imgVisible;			// 商品画像表示
			$detailVisible	= $paramObj[$this->selIndex]->detailVisible;			// 詳細ボタン表示
		}

		$this->selIndex = $request->trimValueOf('selindex');		// 選択中の表示タイプインデックス
		if (empty($this->selIndex)) $this->selIndex = 0;
		$this->categoryId = $request->trimValueOf('categoryid');	// カテゴリーID
		if (empty($this->categoryId)) $this->categoryId = 0;
		$index = $request->trimValueOf('index');		// 処理対象項目インデックス
		
		$act = $request->trimValueOf('act');
		if ($act == 'selcategory'){		// カテゴリー選択の場合
		} else if ($act == 'addtosub'){		// おすすめに追加の場合
			// 最大表示順を取得
			$viewIndex = 0;
			if (count($this->currentSubList)){
				for ($i = 0; $i < count($this->currentSubList); $i++){
					$subObj = $this->currentSubList[$i];
					$index = intval($subObj->index);
					if ($index > $viewIndex) $viewIndex = $index;
				}
			}
			
			$listedItem = explode(',', $request->trimValueOf('idlist'));
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_select';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				// お勧めに追加
				if ($itemValue){
					$subObj = new stdClass;
					$subObj->id = $listedItem[$i];
					$subObj->index = $viewIndex +1;
					$viewIndex++;
					$this->currentSubList[] = $subObj;
				}
			}
			// 表示順に項目をソートする
			usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
			// オブジェクトを保存
			$paramObj[$this->selIndex]->subList = $this->currentSubList;
			$ret = $this->updateWidgetParamObj($paramObj);
			if (!$ret) $this->setMsg(self::MSG_APP_ERR, 'おすすめ追加に失敗しました');
		} else if ($act == 'updatelist'){	// おすすめリストを更新のとき
			for ($i = 0; $i < count($this->currentSubList); $i++){
				$itemName = 'item' . $i . '_view_index';
				$itemValue = $request->trimValueOf($itemName);
				$this->checkNumeric($itemValue, '表示順');
				if ($this->getMsgCount() == 0){			// エラーのないとき
					$subObj = $this->currentSubList[$i];
					$subObj->index = $itemValue;
				} else {
					break;
				}
			}
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 表示順に項目をソートする
				usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
				// オブジェクトを保存
				$paramObj[$this->selIndex]->subList = $this->currentSubList;
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'deleteline'){	// おすすめリスト項目削除のとき
			// おすすめ項目を削除
			array_splice($this->currentSubList, $index, 1);
			
			// 表示順に項目をソートする
			usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
			// オブジェクトを保存
			$paramObj[$this->selIndex]->subList = $this->currentSubList;
			$ret = $this->updateWidgetParamObj($paramObj);
			if ($ret){
				$this->setMsg(self::MSG_GUIDANCE, 'おすすめ項目を削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'おすすめ項目削除に失敗しました');
			}
		} else if ($act == 'update'){		// 設定更新のとき
			// 入力値を取得
			$title	= $request->trimValueOf('item_title');			// ヘッダタイトル
			$detailLabel	= $request->trimValueOf('item_detail_label');// 詳細へのリンク
			$rowCount		= $request->trimValueOf('item_row');			// 表示する行の数
			$columnCount	= $request->trimValueOf('item_column');			// 表示する列の数
			$this->imgSize	= $request->trimValueOf('item_img_size');				// 選択中の画像サイズ
			$nameVisible	= ($request->trimValueOf('item_name_visible') == 'on') ? 1 : 0;			// 商品名表示
			$codeVisible	= ($request->trimValueOf('item_code_visible') == 'on') ? 1 : 0;			// 商品コード表示
			$priceVisible	= ($request->trimValueOf('item_price_visible') == 'on') ? 1 : 0;			// 商品価格表示
			$descVisible	= ($request->trimValueOf('item_desc_visible') == 'on') ? 1 : 0;			// 商品説明表示
			$imgVisible		= ($request->trimValueOf('item_img_visible') == 'on') ? 1 : 0;			// 商品画像表示
			$detailVisible	= ($request->trimValueOf('item_detail_visible') == 'on') ? 1 : 0;			// 詳細ボタン表示
			
			// 入力値のエラーチェック
			$this->checkNumeric($rowCount, '行数');
			$this->checkNumeric($columnCount, '列数');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj[$this->selIndex]->title	= $title;// タイトル
				$paramObj[$this->selIndex]->detailLabel	= $detailLabel;// 詳細へのリンク
				$paramObj[$this->selIndex]->rowCount	= $rowCount;			// 表示する行の数
				$paramObj[$this->selIndex]->columnCount	= $columnCount;			// 表示する列の数
				$paramObj[$this->selIndex]->imgSize	= $this->imgSize;				// 選択中の画像サイズ
				$paramObj[$this->selIndex]->nameVisible	= $nameVisible;			// 商品名表示
				$paramObj[$this->selIndex]->codeVisible	= $codeVisible;			// 商品コード表示
				$paramObj[$this->selIndex]->priceVisible	= $priceVisible;			// 商品価格表示
				$paramObj[$this->selIndex]->descVisible	= $descVisible;			// 商品説明表示
				$paramObj[$this->selIndex]->imgVisible	= $imgVisible;			// 商品画像表示
				$paramObj[$this->selIndex]->detailVisible	= $detailVisible;			// 詳細ボタン表示				
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else {		// 初期表示の場合
			// 入力値初期化
			$this->categoryId = 0;		// ID
		}
		// #### カテゴリーリストを作成 ####
		if ($this->categoryId == 0){
			$this->categoryPathArray = array();
		} else {
			$this->categoryPathArray = $this->createCategoryPath($this->categoryId);			// カテゴリーパスを作成
		}
		$categoryHtml =  $this->createCategoryTreeList($this->langId);
		$this->tmpl->addVar("_widget", "category_list", $categoryHtml);
		
		// #### 商品リストを作成 ####
		if ($this->categoryId == -1){
			$this->db->getProductByCategoryId(0/*カテゴリー未設定*/, $this->langId, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		} else if ($this->categoryId != 0){
			$this->db->getProductByCategoryId($this->categoryId, $this->langId, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		}

		// 商品カテゴリー名を設定
		$categoryName = '未選択';
		if ($this->categoryId == -1){
			$categoryName = '[カテゴリー外]';
		} else if ($this->categoryId != 0){
			$ret = $this->db->getCategoryByCategoryId($this->categoryId, $this->langId, $row);
			if ($ret) $categoryName = $row['pc_name'];
		}
		$this->tmpl->addVar("_widget", "category_name", $categoryName);
		
		// 表示項目のIDを設定
		$this->tmpl->addVar("_widget", "id_list", implode($this->idArray, ','));
		
		// お勧め選択項目を設定
		$this->createSubList();
		
		// 画像選択メニュー作成
		$this->createImgMenu();
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "category_id", $this->categoryId);	// カテゴリーID
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "detail_label",	$detailLabel);// 詳細へのリンク
		$this->tmpl->addVar("_widget", "row",	$rowCount);// 表示する行の数
		$this->tmpl->addVar("_widget", "column",	$columnCount);// 表示する列の数
		if ($nameVisible) $this->tmpl->addVar('_widget', 'NAME_VISIBLE',	'checked');	// 商品名表示
		if ($codeVisible) $this->tmpl->addVar('_widget', 'CODE_VISIBLE',	'checked');			// 商品コード表示
		if ($priceVisible) $this->tmpl->addVar('_widget', 'PRICE_VISIBLE',	'checked');			// 商品価格表示
		if ($descVisible) $this->tmpl->addVar('_widget', 'DESC_VISIBLE',	'checked');			// 商品説明表示
		if ($imgVisible) $this->tmpl->addVar('_widget', 'IMG_VISIBLE',	'checked');			// 商品画像表示
		if ($detailVisible) $this->tmpl->addVar('_widget', 'DETAIL_VISIBLE',	'checked');			// 詳細ボタン表示
		
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * ルートカテゴリーから指定したカテゴリーまでのパスを取得
	 *
	 * @param int $categoryId				カテゴリーID
	 * @return array						カテゴリーパス
	 */
	function createCategoryPath($categoryId)
	{
		global $gEnvManager;
		$pathArray = array();
		$pCategory = $categoryId;
		$pathArray[] = $pCategory;
		
		// カテゴリー最大階層まで親階層を検索
		for ($i = 0; $i < self::MAX_HIER_LEVEL; $i++){
			$ret = $this->db->getCategoryByCategoryId($pCategory, $this->langId, $row);
			if ($ret){
				$pCategory = $row['pc_parent_id'];// 親カテゴリー取得
				$pathArray[] = $pCategory;
				if ($pCategory == 0) break;
			}
		}
		return array_reverse($pathArray);
	}
	/**
	 * カテゴリーツリーリスト作成
	 *
	 * @param string	$langId				言語ID
	 * @return string						カテゴリーリスト表示用HTML
	 */
	function createCategoryTreeList($langId)
	{
		$listHtml = '';
		$this->createCategoryTreeListLoop(0, $langId, $listHtml);
		
		// カテゴリー外のカテゴリーを追加
		if ($this->categoryId == -1){
			$openStr = 'open="1"';
			$selectStr = 'select="1"';
		}
		$listHtml .= '<item text="[カテゴリー外]" id="-1" ' . $openStr . ' ' . $selectStr . '>' . M3_NL;
		$listHtml .= '</item>' . M3_NL;
		return $listHtml;
	}
	/**
	 * カテゴリーツリーリスト作成
	 *
	 * @param int       $parentId			親カテゴリーID
	 * @param string	$langId				言語ID
	 * @param array     $destArray			ツリー化したカテゴリー
	 * @return なし	
	 */
	function createCategoryTreeListLoop($parentId, $langId, &$listHtml)
	{
		$arraySize = $this->db->getChildCategoryWithRows($parentId, $langId, $rows);
		for ($i = 0; $i < $arraySize; $i++){
			$id = $rows[$i]['pc_id'];
			
			// カテゴリーパス上の項目のときは、フォルダをオープン状態にする
			$openStr = '';
			$selectStr = '';	// 選択カテゴリー
			$pathCount = count($this->categoryPathArray);	// 選択中のカテゴリーの階層
			for ($j = 0; $j < $pathCount; $j++){
				if ($id == $this->categoryPathArray[$j]){
					$openStr = 'open="1"';
					if ($j == $pathCount -1) $selectStr = 'select="1"';
					break;
				}
			}
			$listHtml .= '<item text="' . $rows[$i]['pc_name'] . '" id="' . $id . '" ' . $openStr . ' ' . $selectStr . '>' . M3_NL;
			$this->createCategoryTreeListLoop($id, $langId, $listHtml);
			$listHtml .= '</item>' . M3_NL;
		}
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['pt_id']);
		
		$visible = '';
		if ($fetchedRow['pt_visible']){	// 項目の表示
			$visible = 'checked';
		}
		$row = array(
			'index' => $index,											// 項目インデックス
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['pt_serial']),	// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['pt_name']),		// 名前
			'code' => $this->convertToDispString($fetchedRow['pt_code']),		// 商品コード
			'view_index' => $this->convertToDispString($fetchedRow['pt_sort_order']),		// 表示順
			'lang' => $lang,													// 対応言語
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['pt_create_dt']),	// 更新日時
			'visible' => $visible											// メニュー項目表示制御
		);
		$this->tmpl->addVars('productlist', $row);
		$this->tmpl->parseTemplate('productlist', 'a');
		
		// IDを保存
		$this->idArray[] = $id;
		return true;
	}
	/**
	 * おすすめ項目リスト作成
	 *
	 * @return なし						
	 */
	function createSubList()
	{
		for ($i = 0; $i < count($this->currentSubList); $i++){
			$subObj = $this->currentSubList[$i];
			$id = $subObj->id;
			
			// 行カラーの設定
			$lineColor = '';
			if ($i % 2 != 0){
				$lineColor = 'class="even"';		// 偶数行
			}
			// 商品情報を取得
			$ret = $this->db->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
			if ($ret){
				$name = $this->convertToDispString($row['pt_name']);		// 名前
			} else {
				$name = '商品情報取得不可';
			}
			$visible = '';
			if ($row['pt_visible']) $visible = 'checked';
			$row = array(
				'no' => $i + 1,											// 項目番号
				'index' => $i,											// 項目インデックス
				'line_color' => $lineColor,											// 行のカラー
				'id' => $id,			// ID
				'name' => $name,		// 名前
				'code' => $this->convertToDispString($row['pt_code']),		// 商品コード
				'view_index' => $subObj->index,		// 表示順
				'visible' => $visible											// メニュー項目表示制御
			);
			$this->tmpl->addVars('currentsublist', $row);
			$this->tmpl->parseTemplate('currentsublist', 'a');
		}
	}
	/**
	 * 画像サイズ選択メニュー作成
	 *
	 * @return なし						
	 */
	function createImgMenu()
	{
		$name = '小';
		$value = self::PRODUCT_IMAGE_SMALL;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
		
		$name = '中';
		$value = self::PRODUCT_IMAGE_MEDIUM;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
		
		$name = '大';
		$value = self::PRODUCT_IMAGE_LARGE;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
	}
	/**
	 * オブジェクトをindexメンバーの値で昇順にソートする
	 *
	 * @param object  	$obj1			比較するオブジェクト1
	 * @param object	$obj2			比較するオブジェクト2
	 * @return int						同じとき0、1が2より大きいとき1,1がより小さいとき-1を返す
	 */
	function sortOrderByIndex($obj1, $obj2)
	{
		if ($obj1->index == $obj2->index) return 0;
		return ($obj1->index < $obj2->index) ? -1 : 1;
	}
}
?>
