<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_product_newDb.php');

class ec_product_newWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	private $ecObj;					// EC共通ライブラリオブジェクト
	private $currentPageUrl;			// 現在のページURL
	private $outputHtml;			// HTML出力
	private $defaultImageSWidth;
	private $defaultImageSHeight;
	private $defaultImageMWidth;
	private $defaultImageMHeight;
	private $defaultImageLWidth;
	private $defaultImageLHeight;
	const STANDARD_PRICE = 'selling';		// 通常価格
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const THIS_WIDGET_ID = 'ec_product_new';		// ウィジェットID
	const MAX_VIEW_ITEM_COUNT = 6;				// 最大表示数
	const MAX_VIEW_ITEM_COUNT_ON_LINE = 3;		// 1行の最大項目数
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
				
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_product_newDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		// 商品や商品カテゴリーが表示されているときは表示しない
		$categoryId = $request->trimValueOf('category');	// カテゴリーID
		$productId = $request->trimValueOf('product');			// 製品ID
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($categoryId) && empty($productId) && empty($task)){
			return 'main.tmpl.html';
		} else {
			return 'main_none.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;

		// 商品や商品カテゴリーが表示されているときは表示しない
		$categoryId = $request->trimValueOf('category');	// カテゴリーID
		$productId = $request->trimValueOf('product');			// 製品ID
		if (!empty($categoryId) || !empty($productId)) return;
		
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		
		// 現在のページURL
		$this->currentPageUrl = $gEnvManager->createCurrentPageUrl();
		
		// 画像情報を取得
		$this->defaultImageSWidth = 0;
		$this->defaultImageSHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_SMALL, $row);
		if ($ret){
			$this->defaultImageSWidth = $row['is_width'];
			$this->defaultImageSHeight = $row['is_height'];
		}
		$this->defaultImageMWidth = 0;
		$this->defaultImageMHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_MEDIUM, $row);
		if ($ret){
			$this->defaultImageMWidth = $row['is_width'];
			$this->defaultImageMHeight = $row['is_height'];
		}
		$this->defaultImageLWidth = 0;
		$this->defaultImageLHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_LARGE, $row);
		if ($ret){
			$this->defaultImageLWidth = $row['is_width'];
			$this->defaultImageLHeight = $row['is_height'];
		}
		
		// 新着商品を取得
		$this->db->getNewItem($this->langId, array($this, 'newItemLoop'));
		
		// 新着商品を埋め込む
		$this->tmpl->addVar("_widget", "new_items", $this->outputHtml);
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function newItemLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 商品を取得
		$ret = $this->db->getProductByProductId($fetchedRow['pt_id'], $this->langId, $row, $row2, $row3, $row4);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
		}
		
		// 価格を取得
		$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
		$price = $priceArray['pp_price'];	// 価格
		$currency = $priceArray['pp_currency_id'];	// 通貨
		$taxType = $row['pt_tax_type_id'];					// 税種別
		$lang = $row['pt_language_id'];					// 言語				

		// 表示額作成
		$this->ecObj->setCurrencyType($currency, $lang);		// 通貨設定
		$this->ecObj->setTaxType($taxType, $lang);		// 税種別設定
		$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
		
		// 通貨情報を取得
		$ret = $this->db->getCurrency($currency, $this->langId, $currencyRow);
		if ($ret){
			$prePrice = $this->convertToDispString($currencyRow['cu_symbol']);
			$postPrice = $this->convertToDispString($currencyRow['cu_post_symbol']);
		}
		
		// 画像を取得
		$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
		$imageUrl_s = $imageArray['im_url'];	// URL
		$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
		$imageUrl_m = $imageArray['im_url'];	// URL
		$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
		$imageUrl_l = $imageArray['im_url'];	// URL
		
		// 画像中
		$destImg_m = '';
		if (empty($imageUrl_m)){
			$destImg_m = '<img id="preview_img_medium" style="display:none;" ';
			$destImg_m .= 'width="' . $this->defaultImageMWidth . '" ';
			$destImg_m .= 'height="' . $this->defaultImageMHeight . '" ';
			$destImg_m .= 'style="border:0" />';
		} else {
			// URLマクロ変換
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_m);
			$destImg_m = '<img id="preview_img_medium" src="' . $imgUrl . '" ';
			$destImg_m .= 'width="' . $this->defaultImageMWidth . '"';
			$destImg_m .= ' height="' . $this->defaultImageMHeight . '" ';
			$destImg_m .= 'style="border:0" />';
		}
		// 画像大
		$destImg_l = '';
		if (empty($imageUrl_l)){		// 画像が空のとき
			$destImg_l = '<img id="preview_img_large" style="display:none;" ';
			$destImg_l .= 'width="' . $this->defaultImageLWidth . '" ';
			$destImg_l .= 'height="' . $this->defaultImageLHeight . '" ';
			$destImg_l .= 'style="border:0"/>';
		} else {
			// URLマクロ変換
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_l);
			$imageUrl_l = $imgUrl;
			$destImg_l = '<img id="preview_img_large" src="' . $imgUrl . '" ';
			$destImg_l .= 'width="' . $this->defaultImageLWidth . '"';
			$destImg_l .= ' height="' . $this->defaultImageLHeight . '" ';
			$destImg_l .= 'style="border:0"/>';
		}
		
		// 商品詳細へのリンク
		$url  = '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_FIND_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . self::TARGET_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_FROM . '=' . self::THIS_WIDGET_ID;		// 送信元
		$url .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode('product=' . $fetchedRow['pt_id']);
		
		//$imgSpan = '<span onmousemove="m3_showImageToolTip(event,\'' . $imageUrl_l . '\');return false" onmouseout="m3_hideImageToolTip();"><a href="' . $url . '">' . $destImg_m . '</a>' . '</span>';
		$imgSpan = '<a href="' . $url . '">' . $destImg_m . '</a>';
		$nameLink = '<a href="' . $url . '">' . $name . '</a>';
		$itemStr = '<div>' . $imgSpan . '</div><div>' . $nameLink . '</div><div>' . $prePrice . $dispPrice . $postPrice . '</div>';
		
		$colNo = $index % self::MAX_VIEW_ITEM_COUNT_ON_LINE;
		if ($colNo == 0){// 左端のとき
			$this->outputHtml .= '<tr><td>';
			$this->outputHtml .= $itemStr;
			$this->outputHtml .= '</td>';
		} else if ($colNo == self::MAX_VIEW_ITEM_COUNT_ON_LINE -1){// 右端のとき
			$this->outputHtml .= '<td>';
			$this->outputHtml .= $itemStr;
			$this->outputHtml .= '</td></tr>';
		} else {
			$this->outputHtml .= '<td>';
			$this->outputHtml .= $itemStr;
			$this->outputHtml .= '</td>';
		}
		
		// 表示最大項目数以上のときは終了
		if ($index >= self::MAX_VIEW_ITEM_COUNT -1){
			if ($colNo < self::MAX_VIEW_ITEM_COUNT_ON_LINE -1){
				for ($i = 0; $i < self::MAX_VIEW_ITEM_COUNT_ON_LINE - $colNo -1; $i++){
					$this->outputHtml .= '<td></td>';
				}
				$this->outputHtml .= '</tr>';
			}
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 画像取得
	 *
	 * @param array  	$srcRows			画像リスト
	 * @param string	$imageType			画像タイプ
	 * @return array						取得した行
	 */
	function getImage($srcRows, $sizeType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['im_size_id'] == $sizeType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
