<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class custom_headerWidgetContainer extends BaseWidgetContainer
{
	const DEFAULT_BG_COLOR = '#FFCC00';			// バックグランドデフォルトカラー
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;
		
		$title = 'title';	// ヘッダタイトル
		$desc = 'description';	// ヘッダ説明
		$url = 'http://www.sample.com';	// ヘッダURL
		$bgcolor = self::DEFAULT_BG_COLOR;					// ヘッダバックグランドカラー
		//$width	= 717;		// ヘッダの幅
		//$height	= 158;		// ヘッダの高さ
		$width	= 100;		// ヘッダの幅
		$height	= 100;		// ヘッダの高さ
		$widthType = 0;		// ヘッダの幅単位
		$heightType = 0;		// ヘッダの高さ単位
		$titleFontsize	= 30;// タイトルのフォントサイズ
		$descFontsize	= 14;// 説明のフォントサイズ
		$urlFontsize	= 18;	// URLのフォントサイズ
				
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$title	= $paramObj->title;			// ヘッダタイトル
			$desc	= $paramObj->desc;	// ヘッダ説明
			$url	= $paramObj->url;	// ヘッダURL
			$bgcolor = $paramObj->bgcolor;		// ヘッダバックグランドカラー
			$width	= $paramObj->width;		// ヘッダの幅
			$height	= $paramObj->height;		// ヘッダの高さ
			$widthType = $paramObj->widthType;		// ヘッダの幅単位
			$heightType = $paramObj->heightType;		// ヘッダの高さ単位
			$titleFontsize	= $paramObj->titleFontsize;// タイトルのフォントサイズ
			$descFontsize	= $paramObj->descFontsize;// 説明のフォントサイズ
			$urlFontsize	= $paramObj->urlFontsize;	// URLのフォントサイズ
			$imageUrl	= $paramObj->imageUrl;							// 画像へのパス
		}

		// 表示データ埋め込み
//		$this->tmpl->addVar("_widget", "IMAGE_URL", $gEnvManager->getCurrentWidgetRootUrl() . '/images');
//		$image = 'url(' . $gEnvManager->getCurrentWidgetRootUrl() . '/images/header-bg.gif)';
		if (!empty($imageUrl)){
			$image = 'url(' . $imageUrl . ')';
			$this->tmpl->addVar("_widget", "image", $image);		// 画像
		}
		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "desc",	$desc);
		$this->tmpl->addVar("_widget", "url",	$url);
		$this->tmpl->addVar("_widget", "bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "title_fontsize",	$titleFontsize);
		$this->tmpl->addVar("_widget", "desc_fontsize",	$descFontsize);
		$this->tmpl->addVar("_widget", "url_fontsize",	$urlFontsize);
		// 高さ、幅の単位
		$widthMark = '';
		if (empty($widthType)){		// ヘッダの幅単位
			$widthMark = '%';
		} else {
			$widthMark = 'px';
		}
		$this->tmpl->addVar("_widget", "width_type", $widthMark);
		$heightMark = '';
		if (empty($heightType)){		// ヘッダの高さ単位
			$heightMark = '%';
		} else {
			$heightMark = 'px';
		}
		$this->tmpl->addVar("_widget", "height_type", $heightMark);
	}
}
?>
