<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/productDb.php');

class admin_ec_mainImageuploadWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const IMAGE_DIR = 'product';		// 画像アップロード先ディレクトリ名
	const STANDARD_PRICE = 'selling';		// 通常価格
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	const PRODUCT_IMAGE_SIZE_SMALL = 's';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_SIZE_MEDIUM = 'm';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_SIZE_LARGE = 'l';		// 大サイズ商品画像ID
	const PRODUCT_STATUS_NEW = 'new';		// 商品ステータス新規
	const PRODUCT_STATUS_SUGGEST = 'suggest';		// 商品ステータスおすすめ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new productDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_imageupload.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gLogManager;
		
		$userId		= $gEnvManager->getCurrentUserId();
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		// 画像アップロードディレクトリ
		$imgDir = $gEnvManager->getSystemRootPath() . '/resource/image/' . self::IMAGE_DIR;
		
		$act = $request->trimValueOf('act');
		if ($act == 'uploadfile'){		// ファイルアップロードのとき
			// 出力バッファを切り替え
			ob_end_clean();

			// ファイルのアップロード処理
			if (isset($_FILES["Filedata"]) && is_uploaded_file($_FILES['Filedata']['tmp_name'])){		// アップロードファイルがある場合
				$uploadFilename = $_FILES['Filedata']['name'];		// アップロードされたファイルのファイル名取得
				
				// ファイルを保存するサーバディレクトリを指定
				$tmpFile = tempnam(M3_SYSTEM_WORK_DIR_PATH, M3_SYSTEM_WORK_UPLOAD_FILENAME_HEAD);
	
				// アップされたテンポラリファイルを保存ディレクトリにコピー
				$ret = move_uploaded_file($_FILES['Filedata']['tmp_name'], $tmpFile);
				if ($ret){
					// ファイルを移動。ファイルが存在する場合は上書き
					$imgFile = $imgDir . DIRECTORY_SEPARATOR . $uploadFilename;
					$ret = rename($tmpFile, $imgFile);
					if ($ret){		// 画像アップロード完了のとき
						// ファイル名を解析し、商品情報に登録
						list($code, $tmp) = explode('_', $uploadFilename);
						list($size, $tmp) = explode('.', $tmp);
						$size = strtolower($size); // サイズは大文字小文字を区別しない

						// 登録済み商品を取得
						$ret = $this->db->getProductByProductCode($code, $defaultLang, $row, $row2, $row3, $row4);
						if ($ret){
							// 取得値を設定
							$serialNo = $row['pt_serial'];		// シリアル番号
							$name = $row['pt_name'];		// 名前
							$categoryId	= $row['pt_category_id'];	// 商品カテゴリーID
							$index = $row['pt_sort_order'];	// 表示順
							$visible = $row['pt_visible'];	// 表示状態
							$unitTypeId = $row['pt_unit_type_id'];	// 単位
							$unitQuantity = $row['pt_unit_quantity'];		// 数量
							$description = $row['pt_description'];			// 説明
							$description_short = $row['pt_description_short'];		// 簡易説明
							$keyword = $row['pt_search_keyword'];					// 検索キーワード
							$url = $row['pt_site_url'];							// 詳細情報URL
							$taxType = $row['pt_tax_type_id'];					// 税種別
							$adminNote = $row['pt_admin_note'];		// 管理者用備考
						
							// 価格、通貨を取得
							$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
							$price = $priceArray['pp_price'];	// 価格
							$currency = $priceArray['pp_currency_id'];	// 通貨
		
							// 画像を取得
							$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
							$imageUrl_s = $imageArray['im_url'];	// URL
							$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
							$imageUrl_m = $imageArray['im_url'];	// URL
							$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
							$imageUrl_l = $imageArray['im_url'];	// URL
							
							// アップロードされたファイルで更新
							switch ($size){
								case self::PRODUCT_IMAGE_SIZE_SMALL:		// 小サイズ商品画像ID
									$imageUrl_s = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootPath($imgFile);
									break;
								case self::PRODUCT_IMAGE_SIZE_MEDIUM:		// 中サイズ商品画像ID
									$imageUrl_m = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootPath($imgFile);
									break;
								case self::PRODUCT_IMAGE_SIZE_LARGE:		// 大サイズ商品画像ID
									$imageUrl_l = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootPath($imgFile);
									break;
							}
						
							// 商品ステータスを取得
							$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
							$new = $statusArray['ps_value'];
							$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
							$suggest = $statusArray['ps_value'];
							
							// 価格情報の作成
							$priceArray = array();
							$startDt = $gEnvManager->getInitValueOfTimestamp();
							$endDt = $gEnvManager->getInitValueOfTimestamp();
							$priceArray[] = array(self::STANDARD_PRICE, $currency, $price, $startDt, $endDt);		// 単品商品で追加
		
							// 画像情報の作成
							$imageArray = array();
							if (!empty($imageUrl_s)) $imageArray[] = array(self::PRODUCT_IMAGE_SMALL, '', $imageUrl_s);		// 商品画像小追加
							if (!empty($imageUrl_m)) $imageArray[] = array(self::PRODUCT_IMAGE_MEDIUM, '', $imageUrl_m);		// 商品画像中追加
							if (!empty($imageUrl_l)) $imageArray[] = array(self::PRODUCT_IMAGE_LARGE, '', $imageUrl_l);		// 商品画像大追加
		
							// 商品ステータス情報の作成
							// flashからのアップロードでは、クッキーが送られてこないので$userIdが0になる
							$statusArray = array();
							$statusArray[] = array(self::PRODUCT_STATUS_NEW, $new);		// 新着
							$statusArray[] = array(self::PRODUCT_STATUS_SUGGEST, $suggest);		// おすすめ				
							$ret = $this->db->updateProduct($serialNo, $name, $code, $categoryId, $index, $visible, $unitTypeId, $unitQuantity,
																$description, $description_short, $keyword, $url, $taxType, $adminNote, 
																$priceArray, $imageArray, $statusArray, $userId, $newSerial);
						}
					} else {
						// エラーの場合は作成ファイルを削除
						unlink($tmpFile);
					}
				}
				if (!$ret){			// エラー発生のとき
					header("HTTP/1.1 500 File Upload Error");
				}
			} else {			// アップロードファイルがないとき
				header("HTTP/1.1 500 File Upload Error");
				if (isset($_FILES["Filedata"])) echo $_FILES["Filedata"]["error"];
			}
			
			// バッファ内容を出力
			ob_end_flush();
			exit(0);		// スクリプト終了
		}
		// インストール先ディレクトリ
		$this->tmpl->addVar("_widget", "image_dir", $imgDir);
		
		// アップロード実行用URL
		$this->tmpl->addVar("_widget", "upload_url", $gEnvManager->getAdminUrl() . '/index.php');
		
		$this->tmpl->addVar("_widget", "param_cmd", M3_REQUEST_CMD_CONFIG_WIDGET);
		$this->tmpl->addVar("_widget", "param_widget", $gEnvManager->getCurrentWidgetId());
		$this->tmpl->addVar("_widget", "param_task", 'imageupload');
		$this->tmpl->addVar("_widget", "param_act", 'uploadfile');
		$this->tmpl->addVar("_widget", "param_key", $gEnvManager->getAdminKey());// 管理者キー
		
		// ルートURL
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 画像取得
	 *
	 * @param array  	$srcRows			画像リスト
	 * @param string	$imageType			画像タイプ
	 * @return array						取得した行
	 */
	function getImage($srcRows, $sizeType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['im_size_id'] == $sizeType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 商品ステータス取得
	 *
	 * @param array  	$srcRows			取得行
	 * @param string	$type			商品ステータスタイプ
	 * @return array						取得した行
	 */
	function getStatus($srcRows, $type)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['ps_type'] == $type){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
