<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainMemberDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_mainDb.php');

class ec_mainLoginWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $memberDb;
	private $orderDb;	// DB接続オブジェクト
	private $ecMailObj;	// メール連携オブジェクト
	const MAIL_OBJ_ID = 'ecmail';
	const EC_LIB_ID = "eclib";		// EC共通ライブラリオブジェクトID
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		//$this->db = new ec_mainOrderDb();
		$this->mainDb = new ec_mainDb();
		$this->memberDb = new ec_mainMemberDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
		$this->orderDb = new ec_mainOrderDb();
		
		// メール連携オブジェクト取得
		$this->ecMailObj = $gInstanceManager->getObject(self::MAIL_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'login.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gAccessManager;
		global $gPageManager;
		global $gInstanceManager;

		$langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$forward = $request->trimValueOf(M3_REQUEST_PARAM_FORWARD);		// 画面遷移用パラメータ

		// ログイン画面からデフォルトの遷移先は配送入力画面。変更する場合は、「forward」パラメータを設定する
		// ログイン状態を取得
		if ($gEnvManager->isCurrentUserLogined()){
			if (empty($forward)){
				// 既にログイン中のときは、配送先指定画面へ
				$deliveryPage = $gEnvManager->createCurrentPageUrl() . '&task=delivery';
				//$deliveryPage = $gEnvManager->createCurrentPageUrl();
				$gPageManager->redirect($deliveryPage);
			} else {
				$forwardPage = $gEnvManager->createCurrentPageUrl() . '&' . $forward;
				$gPageManager->redirect($forwardPage);
			}
			return;
		}
		if ($act == 'ec_login'){			// 会員ログインのとき
			// アカウント、パスワード取得
			$account = $request->trimValueOf('ec_account');
			$password = $request->trimValueOf('password');

			// ユーザ認証
			if ($gAccessManager->userLoginByAccount($account, $password)){
				// 初回ログインのときは、仮会員を正会員にする
				$userId = $gEnvManager->getCurrentUserId();
				if ($userId != 0){
					//$ret = $this->orderDb->makeTmpMemberToProperMember($userId);
					$ret = $gInstanceManager->getObject(self::EC_LIB_ID)->makeTmpMemberToProperMember($userId);
					if ($ret){
						$this->sysDb->makeNormalLoginUser($userId);// 一般ログインユーザに設定
					
						// ######## 会員登録のメールをイントラネット側に送信 ########
						$this->ecMailObj->sendMemberInfoToBackoffice(0/*新規登録*/, $userId);
					}
				}
				if (empty($forward)){
					// 配送先指定画面へ
					$deliveryPage = $gEnvManager->createCurrentPageUrl() . '&task=delivery';
					//$deliveryPage = $gEnvManager->createCurrentPageUrl();
					$gPageManager->redirect($deliveryPage);
				} else {
					$forwardPage = $gEnvManager->createCurrentPageUrl() . '&' . $forward;
					$gPageManager->redirect($forwardPage);
				}
				return;
			} else {
				// ログイン状態を削除
				$gAccessManager->userLogout();
				
				$this->tmpl->addVar("_widget", "message", 'ログインに失敗しました');
			}
		} else if ($act == 'ec_login_by_mail'){			// 会員ログインのとき
			// メールからのアクセスの場合は、ログイン後最初にパスワードを変更する
			$account = $request->trimValueOf('account');
			$pwd = $request->trimValueOf('pwd');
			//$forward = 'task=';		// トップ画面へ遷移
			$forward = 'task=changepwd';		// パスワードを変更
			
			$this->tmpl->addVar("_widget", "ec_account", $account);
			$this->tmpl->addVar("_widget", "ec_password", $pwd);
			$this->tmpl->addVar("_widget", "savepwd", $pwd);
			//$this->tmpl->addVar('_widget', 'password_readonly', 'readonly');
			$this->tmpl->setAttribute('field_regmember', 'visibility', 'hidden');// 会員登録への遷移を削除
		}
		$this->tmpl->addVar("_widget", "forward", $forward);		// 遷移先を維持
		// ディレクトリを設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
}
?>
