<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class admin_ec_mainProductWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	var $serialNo;			// シリアル番号
	var $categoryId;		// カテゴリーID
	var $productId;			// 商品ID
	var $categoryPathArray;	// 選択中のカテゴリーの階層
	var $unitTypeId;		// 選択単位
	var $currency;			// 通貨
	var $taxType;			// 税種別
	private $ecObj;			// 共通ECオブジェクト
	const MAX_HIER_LEVEL = 20;		// カテゴリー階層最大値
	const STANDARD_PRICE = 'selling';		// 通常価格
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	const PRODUCT_STATUS_NEW = 'new';		// 商品ステータス新規
	const PRODUCT_STATUS_SUGGEST = 'suggest';		// 商品ステータスおすすめ
	const DEFAULT_TAX_TYPE = 'sales';			// デフォルト税種別
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const CSV_FILE_HEAD = 'product_';		// CSVファイル名
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new productDb();
		
		// EC用共通オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
		$this->ecObj->initByDefault();		// デフォルト値で初期化
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_product.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userId		= $gEnvManager->getCurrentUserId();
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		
		// 画像情報を取得
		$defaultImageSWidth = 0;
		$defaultImageSHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_SMALL, $row);
		if ($ret){
			$defaultImageSWidth = $row['is_width'];
			$defaultImageSHeight = $row['is_height'];
		}
		$defaultImageMWidth = 0;
		$defaultImageMHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_MEDIUM, $row);
		if ($ret){
			$defaultImageMWidth = $row['is_width'];
			$defaultImageMHeight = $row['is_height'];
		}
		$defaultImageLWidth = 0;
		$defaultImageLHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_LARGE, $row);
		if ($ret){
			$defaultImageLWidth = $row['is_width'];
			$defaultImageLHeight = $row['is_height'];
		}
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');			// 選択項目のシリアル番号
		if (empty($this->serialNo)) $this->serialNo = 0;
		$this->categoryId = $request->trimValueOf('categoryid');	// カテゴリーID
		if (empty($this->categoryId)) $this->categoryId = 0;
		$this->productId = $request->trimValueOf('productid');	// 商品ID
		if (empty($this->productId)) $this->productId = 0;
		$this->currency = $request->trimValueOf('item_currency');		// 通貨
		if (empty($this->currency)) $this->currency	= $this->ecObj->getDefaultCurrency();		// 通貨
		
		// 編集中の項目
		$name	= $request->trimValueOf('item_name');		// 商品名
		$code	= $request->trimValueOf('item_code');		// 商品コード
		$index	= $request->trimValueOf('item_index');		// 表示順
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;			// 表示するかどうか
		$this->unitTypeId = $request->trimValueOf('item_unit_type');		// 選択単位
		$unitQuantity = $request->trimValueOf('item_unit_quantity');		// 数量
		$description = $request->valueOf('item_description');			// 説明
		$description_short = $request->valueOf('item_desc_short');		// 簡易説明
		$keyword = $request->valueOf('item_keyword');					// 検索キーワード
		$url = $request->valueOf('item_url');							// 詳細情報URL
		$this->taxType = $request->valueOf('item_tax_type');					// 税種別
		$adminNote = $request->trimValueOf('item_admin_note');		// 管理者用備考
		$price = $request->trimValueOf('item_price');		// 価格
		
		// 画像のパスをマクロ表記パスに直す
		$imageUrl_s = $request->trimValueOf('imageurl_s');		// 小画像

		if (!empty($imageUrl_s)){
			if (strncmp($imageUrl_s, '/', 1) == 0){		// 相対パス表記のとき
				$imageUrl_s = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl_s);
			}
		}
		$imageUrl_m = $request->trimValueOf('imageurl_m');		// 中画像
		if (!empty($imageUrl_m)){
			if (strncmp($imageUrl_m, '/', 1) == 0){		// 相対パス表記のとき
				$imageUrl_m = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl_m);
			}
		}
		$imageUrl_l = $request->trimValueOf('imageurl_l');		// 大画像
		if (!empty($imageUrl_l)){
			if (strncmp($imageUrl_l, '/', 1) == 0){		// 相対パス表記のとき
				$imageUrl_l = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl_l);
			}
		}
		$new = ($request->trimValueOf('item_new') == 'on') ? 1 : 0;		// 新規
		$suggest = ($request->trimValueOf('item_suggest') == 'on') ? 1 : 0;		// おすすめ
		$this->langId = $request->trimValueOf('item_lang');				// 現在メニューで選択中の言語
		if (empty($this->langId)) $this->langId = $defaultLang;			// 言語が選択されていないときは、デフォルト言語を設定
		
		if ($act == 'selcategory'){		// カテゴリー選択の場合
			// 指定のカテゴリーの商品一覧表示し、入力欄を初期化する
			$this->serialNo = 0;			// 選択項目のシリアル番号
			$this->productId = 0;	// 商品ID
			$this->langId = $defaultLang;
			$name = '';		// 名前
			$code = '';		// 商品コード
			$index = '';	// 表示順
			$visible = 1;	// 表示状態
			$new = 0;// 新規
			$suggest = 0;// おすすめ
			$price = '';	// 価格
			$this->currency	= $this->ecObj->getDefaultCurrency();		// 通貨
			$this->unitTypeId = '';	// 単位
			$unitQuantity = 1;		// 数量
			$description = '';			// 説明
			$description_short = '';		// 簡易説明
			$keyword = '';					// 検索キーワード
			$url = '';							// 詳細情報URL
			$this->taxType	= self::DEFAULT_TAX_TYPE;		// 税種別
			$adminNote = '';		// 管理者用備考
			$updateUser = '';	// 更新者
			$updateDt = '';	// 更新日時
			$imageUrl_s = '';		// 商品画像小
			$imageUrl_m = '';		// 商品画像中
			$imageUrl_l = '';		// 商品画像大
		} else if ($act == 'select'){		// 項目選択の場合
			if ($this->serialNo == 0){		// シリアル番号が0のときは、新規追加モードにする
				// 入力値初期化
				$this->serialNo = 0;		// シリアル番号
				$this->productId = 0;	// 商品ID
				$this->langId = $defaultLang;
				$name = '';		// 名前
				$code = '';		// 商品コード
				$index = '';	// 表示順
				$visible = 1;	// 表示状態
				$new = 0;// 新規
				$suggest = 0;// おすすめ
				$price = '';	// 価格
				$this->currency	= $this->ecObj->getDefaultCurrency();		// 通貨
				$this->unitTypeId = '';	// 単位
				$unitQuantity = 1;		// 数量
				$description = '';			// 説明
				$description_short = '';		// 簡易説明
				$keyword = '';					// 検索キーワード
				$url = '';							// 詳細情報URL
				$this->taxType	= self::DEFAULT_TAX_TYPE;		// 税種別
				$adminNote = '';		// 管理者用備考
				$updateUser = '';	// 更新者
				$updateDt = '';	// 更新日時	
				$imageUrl_s = '';		// 商品画像小
				$imageUrl_m = '';		// 商品画像中
				$imageUrl_l = '';		// 商品画像大
			} else {
				// データ再取得
				$ret = $this->db->getProductBySerial($this->serialNo, $row, $row2, $row3, $row4);
				if ($ret){
					// 取得値を設定
					$this->productId = $row['pt_id'];	// 商品ID
					$this->langId = $row['pt_language_id'];
					$name = $row['pt_name'];		// 名前
					$code = $row['pt_code'];		// 商品コード
					$index = $row['pt_sort_order'];	// 表示順
					$visible = $row['pt_visible'];	// 表示状態
					$this->unitTypeId = $row['pt_unit_type_id'];	// 単位
					$unitQuantity = $row['pt_unit_quantity'];		// 数量
					$description = $row['pt_description'];			// 説明
					$description_short = $row['pt_description_short'];		// 簡易説明
					$keyword = $row['pt_search_keyword'];					// 検索キーワード
					$url = $row['pt_site_url'];							// 詳細情報URL
					$this->taxType = $row['pt_tax_type_id'];					// 税種別
					$adminNote = $row['pt_admin_note'];		// 管理者用備考
					$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
					$updateDt = $this->convertToDispDateTime($row['pt_create_dt']);	// 更新日時
					
					// 価格を取得
					$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
					$price = $priceArray['pp_price'];	// 価格
					$this->currency = $priceArray['pp_currency_id'];	// 通貨
					
					// 画像を取得
					$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
					$imageUrl_s = $imageArray['im_url'];	// URL
					$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
					$imageUrl_m = $imageArray['im_url'];	// URL
					$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
					$imageUrl_l = $imageArray['im_url'];	// URL
										
					// 商品ステータスを取得
					$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
					$new = $statusArray['ps_value'];
					$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
					$suggest = $statusArray['ps_value'];
				}
			}
		} else if ($act == 'selectlang'){		// 言語選択の場合
			// 登録済み商品を取得
			$ret = $this->db->getProductByProductId($this->productId, $this->langId, $row, $row2, $row3, $row4);
			if ($ret){
				// 取得値を設定
				$this->serialNo = $row['pt_serial'];		// シリアル番号
				$this->productId = $row['pt_id'];	// 商品ID
				$this->langId = $row['pt_language_id'];
				$name = $row['pt_name'];		// 名前
				$code = $row['pt_code'];		// 商品コード
				$index = $row['pt_sort_order'];	// 表示順
				$visible = $row['pt_visible'];	// 表示状態
				$this->unitTypeId = $row['pt_unit_type_id'];	// 単位
				$unitQuantity = $row['pt_unit_quantity'];		// 数量
				$description = $row['pt_description'];			// 説明
				$description_short = $row['pt_description_short'];		// 簡易説明
				$keyword = $row['pt_search_keyword'];					// 検索キーワード
				$url = $row['pt_site_url'];							// 詳細情報URL
				$this->taxType = $row['pt_tax_type_id'];					// 税種別
				$adminNote = $row['pt_admin_note'];		// 管理者用備考
				$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
				$updateDt = $this->convertToDispDateTime($row['pt_create_dt']);	// 更新日時
				
				// 価格を取得
				$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
				$price = $priceArray['pp_price'];	// 価格
				$this->currency = $priceArray['pp_currency_id'];	// 通貨
				
				// 画像を取得
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
				$imageUrl_s = $imageArray['im_url'];	// URL
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
				$imageUrl_m = $imageArray['im_url'];	// URL
				$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
				$imageUrl_l = $imageArray['im_url'];	// URL
								
				// 商品ステータスを取得
				$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
				$new = $statusArray['ps_value'];
				$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
				$suggest = $statusArray['ps_value'];
			} else {	// 指定した言語のデータがないとき
				// デフォルト値を設定
				$this->serialNo = 0;
				$name = '';		// 名前
			}
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, '商品名');
			$this->checkInput($code, '商品コード');
			$this->checkNumeric($index, '表示順');
			$this->checkNumericF($unitQuantity, '数量');
			$this->checkNumericF($price, '商品価格');
			if (empty($this->unitTypeId)) $this->setUserErrorMsg('販売単位が選択されていません');

			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// カテゴリー外のときは、カテゴリーIDを0にする
				if ($this->categoryId == -1){
					$categoryId = 0;
				} else {
					$categoryId = $this->categoryId;
				}
				// 価格情報の作成
				$priceArray = array();
				$startDt = $gEnvManager->getInitValueOfTimestamp();
				$endDt = $gEnvManager->getInitValueOfTimestamp();
				$priceArray[] = array(self::STANDARD_PRICE, $this->currency, $price, $startDt, $endDt);		// 単品商品で追加
				
				// 画像情報の作成
				$imageArray = array();
				if (!empty($imageUrl_s)) $imageArray[] = array(self::PRODUCT_IMAGE_SMALL, '', $imageUrl_s);		// 商品画像小追加
				if (!empty($imageUrl_m)) $imageArray[] = array(self::PRODUCT_IMAGE_MEDIUM, '', $imageUrl_m);		// 商品画像中追加
				if (!empty($imageUrl_l)) $imageArray[] = array(self::PRODUCT_IMAGE_LARGE, '', $imageUrl_l);		// 商品画像大追加
								
				// 商品ステータス情報の作成
				$statusArray = array();
				$statusArray[] = array(self::PRODUCT_STATUS_NEW, $new);		// 新着
				$statusArray[] = array(self::PRODUCT_STATUS_SUGGEST, $suggest);		// おすすめ
				if ($this->serialNo == 0 && $this->productId == 0){		// シリアル番号が0、商品IDが0のときは、新規商品追加モードにする
					$ret = $this->db->addProduct(0, $this->langId, $name, $code, 1, $categoryId, $index, $visible, $this->unitTypeId, $unitQuantity,
													$description, $description_short, $keyword, $url, $this->taxType, $adminNote, 
													$priceArray, $imageArray, $statusArray, $userId, $newSerial);
				} else {
					$ret = $this->db->addProduct($this->productId, $this->langId, $name, $code, 1, $categoryId, $index, $visible, $this->unitTypeId, $unitQuantity,
													$description, $description_short, $keyword, $url, $this->taxType, $adminNote, 
													$priceArray, $imageArray, $statusArray, $userId, $newSerial);
				}
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					// シリアル番号更新
					$this->serialNo = $newSerial;
					
					// データ再取得
					$ret = $this->db->getProductBySerial($this->serialNo, $row, $row2, $row3, $row4);
					if ($ret){
						// 取得値を設定
						$this->productId = $row['pt_id'];	// 商品ID
						$this->langId = $row['pt_language_id'];
						$name = $row['pt_name'];		// 名前
						$code = $row['pt_code'];		// 商品コード
						$index = $row['pt_sort_order'];	// 表示順
						$visible = $row['pt_visible'];	// 表示状態
						$this->unitTypeId = $row['pt_unit_type_id'];	// 単位
						$unitQuantity = $row['pt_unit_quantity'];		// 数量
						$description = $row['pt_description'];			// 説明
						$description_short = $row['pt_description_short'];		// 簡易説明
						$keyword = $row['pt_search_keyword'];					// 検索キーワード
						$url = $row['pt_site_url'];							// 詳細情報URL
						$this->taxType = $row['pt_tax_type_id'];					// 税種別
						$adminNote = $row['pt_admin_note'];		// 管理者用備考
						$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
						$updateDt = $this->convertToDispDateTime($row['pt_create_dt']);	// 更新日時
						
						// 価格を取得
						$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
						$price = $priceArray['pp_price'];	// 価格
						$this->currency = $priceArray['pp_currency_id'];	// 通貨
						
						// 画像を取得
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
						$imageUrl_s = $imageArray['im_url'];	// URL
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
						$imageUrl_m = $imageArray['im_url'];	// URL
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
						$imageUrl_l = $imageArray['im_url'];	// URL
												
						// 商品ステータスを取得
						$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
						$new = $statusArray['ps_value'];
						$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
						$suggest = $statusArray['ps_value'];
					}
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '商品名');
			$this->checkInput($code, '商品コード');
			$this->checkNumeric($index, '表示順');
			$this->checkNumericF($unitQuantity, '数量');
			$this->checkNumericF($price, '商品価格');
			if (empty($this->unitTypeId)) $this->setUserErrorMsg('販売単位が選択されていません');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// カテゴリー外のときは、カテゴリーIDを0にする
				if ($this->categoryId == -1){
					$categoryId = 0;
				} else {
					$categoryId = $this->categoryId;
				}
				
				// 価格情報の作成
				$priceArray = array();
				$startDt = $gEnvManager->getInitValueOfTimestamp();
				$endDt = $gEnvManager->getInitValueOfTimestamp();
				$priceArray[] = array(self::STANDARD_PRICE, $this->currency, $price, $startDt, $endDt);		// 単品商品で追加
				
				// 画像情報の作成
				$imageArray = array();
				if (!empty($imageUrl_s)) $imageArray[] = array(self::PRODUCT_IMAGE_SMALL, '', $imageUrl_s);		// 商品画像小追加
				if (!empty($imageUrl_m)) $imageArray[] = array(self::PRODUCT_IMAGE_MEDIUM, '', $imageUrl_m);		// 商品画像中追加
				if (!empty($imageUrl_l)) $imageArray[] = array(self::PRODUCT_IMAGE_LARGE, '', $imageUrl_l);		// 商品画像大追加
				
				// 商品ステータス情報の作成
				$statusArray = array();
				$statusArray[] = array(self::PRODUCT_STATUS_NEW, $new);		// 新着
				$statusArray[] = array(self::PRODUCT_STATUS_SUGGEST, $suggest);		// おすすめ				
				$ret = $this->db->updateProduct($this->serialNo, $name, $code, $categoryId, $index, $visible, $this->unitTypeId, $unitQuantity,
													$description, $description_short, $keyword, $url, $this->taxType, $adminNote, 
													$priceArray, $imageArray, $statusArray, $userId, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 登録済みのカテゴリーを取得
					$this->serialNo = $newSerial;
					
					// データ再取得
					$ret = $this->db->getProductBySerial($this->serialNo, $row, $row2, $row3, $row4);
					if ($ret){
						// 取得値を設定
						$this->productId = $row['pt_id'];	// 商品ID
						$this->langId = $row['pt_language_id'];
						$name = $row['pt_name'];		// 名前
						$code = $row['pt_code'];		// 商品コード
						$index = $row['pt_sort_order'];	// 表示順
						$visible = $row['pt_visible'];	// 表示状態
						$this->unitTypeId = $row['pt_unit_type_id'];	// 単位
						$unitQuantity = $row['pt_unit_quantity'];		// 数量
						$description = $row['pt_description'];			// 説明
						$description_short = $row['pt_description_short'];		// 簡易説明
						$keyword = $row['pt_search_keyword'];					// 検索キーワード
						$url = $row['pt_site_url'];							// 詳細情報URL
						$this->taxType = $row['pt_tax_type_id'];					// 税種別
						$adminNote = $row['pt_admin_note'];		// 管理者用備考
						$updateUser = $this->convertToDispString($row['lu_name']);	// 更新者
						$updateDt = $this->convertToDispDateTime($row['pt_create_dt']);	// 更新日時
						
						// 価格を取得
						$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
						$price = $priceArray['pp_price'];	// 価格
						$this->currency = $priceArray['pp_currency_id'];	// 通貨
						
						// 画像を取得
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
						$imageUrl_s = $imageArray['im_url'];	// URL
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
						$imageUrl_m = $imageArray['im_url'];	// URL
						$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
						$imageUrl_l = $imageArray['im_url'];	// URL
												
						// 商品ステータスを取得
						$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
						$new = $statusArray['ps_value'];
						$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
						$suggest = $statusArray['ps_value'];
					}
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delProduct($this->serialNo, $userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'deleteid'){		// ID項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delProductById($this->serialNo, $userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'upload'){		// CSVアップロード
			if (is_uploaded_file($_FILES['upfile']['tmp_name'])) {
				$uploadFilename = $_FILES['upfile']['name'];		// アップロードされたファイルのファイル名取得
				
				// ファイルを保存するサーバディレクトリを指定
				$tmpFile = tempnam(M3_SYSTEM_WORK_DIR_PATH, M3_SYSTEM_WORK_UPLOAD_FILENAME_HEAD);
	
				// アップされたテンポラリファイルを保存ディレクトリにコピー
				$ret = move_uploaded_file($_FILES['upfile']['tmp_name'], $tmpFile);
				if ($ret){
					$addCount = 0;		// 追加項目数
					$updateCount = 0;	// 更新商品数
					$colCount = 0;		// カラム数
					
					// トランザクションスタート
					$this->db->startTransaction();
					
					// ファイルオープン
					$fp = fopen($tmpFile, "r");
					
					// データ読み込み
					//while (($data = fgetByCsv($fp)) !== false){
					while (($data = fgetByCsvWithTab($fp)) !== false){
						if ($colCount == 0) $colCount = count($data);		// カラム数
						
						// ヘッダ読み飛ばし
						if (trim($data[0]) == '商品名') continue;
						if ($colCount != count($data)) continue;		// カラム数が合わない行も読み飛ばす
						
						// データをDBに格納する
						$name		= trim($data[0]);	// 商品名
						$code		= trim($data[1]);	// 商品コード
						$unitTypeId = $this->db->getUnitTypeIdByName($defaultLang, trim($data[2]));	// 販売単位
						$price		= trim($data[3]);	// 販売価格(税抜)
						$priceWithTax		= trim($data[4]);	// 販売価格(税込)
						$taxType	= $this->db->getTaxTypeIdByName($defaultLang, trim($data[5]));		// 税種別
						$description_short	= trim($data[6]);	// 簡易説明
						$categoryId			= trim($data[7]);	// 商品カテゴリーID
						
						// 価格の計算、税抜価格を優先する
						if (empty($price)){
							// 税込価格から税抜価格を求める
							if (empty($priceWithTax)){
								$price = 0;
							} else {
								$rate = $this->ecObj->getTaxRate(self::DEFAULT_TAX_TYPE, $this->langId);
								if ($rate > 0) $price = $priceWithTax / (1 + $rate / 100);
							}
						}
						$price = $this->ecObj->getCurrencyPrice($price);	// 端数調整
						
						// その他の値
						$index = 0;
						$visible = 1;
						$new		= 0;		// 新規かどうか
						$suggest	= 0;		// お勧めかどうか
						$unitQuantity = 1;		// 単位数量
						$description = '';
						$keyword = '';
						$url = '';
						$adminNote = '';
						
						// データのエラーチェック
						// エラーなしの場合は、データを登録
						if ($this->getMsgCount() == 0){
							// 商品コードを見て、新規登録か更新かを判断
							$updateRecord = false;
							if ($this->db->isExistsProductCode($code)) $updateRecord = true;
							
							if ($updateRecord){		// 既存項目の更新のとき
								// 登録済み商品を取得
								$ret = $this->db->getProductByProductCode($code, $this->langId, $row, $row2, $row3, $row4);
								if ($ret){
									// 取得値を設定
									$serialNo = $row['pt_serial'];		// シリアル番号
									if (empty($name)) $name = $row['pt_name'];		// 名前
									
									$index = $row['pt_sort_order'];	// 表示順
									$visible = $row['pt_visible'];	// 表示状態
									$unitTypeId = $row['pt_unit_type_id'];	// 単位
									$unitQuantity = $row['pt_unit_quantity'];		// 数量
									$description = $row['pt_description'];			// 説明
									//$description_short = $row['pt_description_short'];		// 簡易説明
									$keyword = $row['pt_search_keyword'];					// 検索キーワード
									$url = $row['pt_site_url'];							// 詳細情報URL
									$taxType = $row['pt_tax_type_id'];					// 税種別
									$adminNote = $row['pt_admin_note'];		// 管理者用備考
				
									// 通貨を取得
									$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
									$currency = $priceArray['pp_currency_id'];	// 通貨
				
									// 画像を取得
									$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
									$imageUrl_s = $imageArray['im_url'];	// URL
									$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
									$imageUrl_m = $imageArray['im_url'];	// URL
									$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
									$imageUrl_l = $imageArray['im_url'];	// URL
								
									// 商品ステータスを取得
									$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_NEW);// 新規
									$new = $statusArray['ps_value'];
									$statusArray = $this->getStatus($row4, self::PRODUCT_STATUS_SUGGEST);// おすすめ
									$suggest = $statusArray['ps_value'];
									
									// 価格情報の作成
									$priceArray = array();
									$startDt = $gEnvManager->getInitValueOfTimestamp();
									$endDt = $gEnvManager->getInitValueOfTimestamp();
									$priceArray[] = array(self::STANDARD_PRICE, $currency, $price, $startDt, $endDt);		// 単品商品で追加
				
									// 画像情報の作成
									$imageArray = array();
									if (!empty($imageUrl_s)) $imageArray[] = array(self::PRODUCT_IMAGE_SMALL, '', $imageUrl_s);		// 商品画像小追加
									if (!empty($imageUrl_m)) $imageArray[] = array(self::PRODUCT_IMAGE_MEDIUM, '', $imageUrl_m);		// 商品画像中追加
									if (!empty($imageUrl_l)) $imageArray[] = array(self::PRODUCT_IMAGE_LARGE, '', $imageUrl_l);		// 商品画像大追加
				
									// 商品ステータス情報の作成
									$statusArray = array();
									$statusArray[] = array(self::PRODUCT_STATUS_NEW, $new);		// 新着
									$statusArray[] = array(self::PRODUCT_STATUS_SUGGEST, $suggest);		// おすすめ				
									$ret = $this->db->updateProduct($serialNo, $name, $code, $categoryId, $index, $visible, $unitTypeId, $unitQuantity,
																		$description, $description_short, $keyword, $url, $taxType, $adminNote, 
																		$priceArray, $imageArray, $statusArray, $userId, $newSerial);
									if ($ret) $updateCount++;	// 更新商品数
								} else {		// 該当の商品が存在しないとき
									$msg = 'この商品コードの商品が見つかりません(' . $code . ')';
									$this->setAppErrorMsg($msg);
								}
							} else {
								// 価格情報の作成
								$priceArray = array();
								$startDt = $gEnvManager->getInitValueOfTimestamp();
								$endDt = $gEnvManager->getInitValueOfTimestamp();
								$priceArray[] = array(self::STANDARD_PRICE, $this->currency, $price, $startDt, $endDt);		// 単品商品で追加
				
								// 画像情報の作成
								$imageArray = array();
								//if (!empty($imageUrl_s)) $imageArray[] = array(self::PRODUCT_IMAGE_SMALL, '', $imageUrl_s);		// 商品画像小追加
								//if (!empty($imageUrl_m)) $imageArray[] = array(self::PRODUCT_IMAGE_MEDIUM, '', $imageUrl_m);		// 商品画像中追加
								//if (!empty($imageUrl_l)) $imageArray[] = array(self::PRODUCT_IMAGE_LARGE, '', $imageUrl_l);		// 商品画像大追加
								
								// 商品ステータス情報の作成
								$statusArray = array();
								$statusArray[] = array(self::PRODUCT_STATUS_NEW, $new);		// 新着
								$statusArray[] = array(self::PRODUCT_STATUS_SUGGEST, $suggest);		// おすすめ
								$ret = $this->db->addProduct(0, $this->langId, $name, $code, 1/*単品商品*/, $categoryId, $index, $visible, $unitTypeId, $unitQuantity,
																	$description, $description_short, $keyword, $url, $taxType, $adminNote, 
																	$priceArray, $imageArray, $statusArray, $userId, $newSerial);
								if ($ret) $addCount++;
							}
						}
					}
					// ファイルを閉じる
					fclose($fp);
					
					// トランザクション終了
					$ret = $this->db->endTransaction();
					if ($ret && $this->getMsgCount() == 0){
						$this->setGuidanceMsg('データを' . $addCount . '件追加しました');
						$this->setGuidanceMsg('データを' . $updateCount . '件更新しました');
					} else {
						$this->setAppErrorMsg('データ追加に失敗しました');
					}
				}
				// テンポラリファイル削除
				unlink($tmpFile);
			} else {
				$msg = 'アップロードファイルが見つかりません(要因：アップロード可能なファイルのMaxサイズを超えている可能性があります - ' . $gSystemManager->getMaxFileSizeForUpload() . 'バイト)';
				$this->setAppErrorMsg($msg);
			}
		} else if ($act == 'download'){		// CSVダウンロード
			// ダウンロード時のデフォルトファイル名
			$down_file = self::CSV_FILE_HEAD . date("YmdHi") . '.txt';
			
			// ヘッダ部を作成
			$buf = array();
			$buf[] = '商品名';
			$buf[] = '商品コード';
			$buf[] = '販売単位';
			$buf[] = '販売価格(税抜)';
			$buf[] = '販売価格(税込)';
			$buf[] = '税種別';
			$buf[] = '簡易説明';
			$buf[] = '商品カテゴリーID';
			$delim = $gEnvManager->getDefaultCsvDelimCode();		// CSV区切りコードを取得
			$this->csvData[] = implode($delim, $buf) . $gEnvManager->getDefaultCsvNLCode();
		
			// 商品リストを取得
			$this->db->getAllProduct(array($this, 'productCsvListLoop'));
			
			// CSVの出力
			ob_end_clean();
			header ("Content-Type: application/force-download");
			header ("Content-Disposition: attachment; filename=" . $down_file);
			header ("Content-Description: File Transfer");
			header ("Content-Length: " . strlen(join("", $this->csvData)));
			foreach ($this->csvData as $mval) {
			    echo mb_convert_encoding($mval, 'SJIS-win');
			    flush();
			    ob_flush();
			    usleep(10000);
			}
			ob_end_flush();
			exit();		// スクリプト終了
		} else {	// 初期表示
			// 入力値初期化
			$this->serialNo = 0;		// シリアル番号
			$this->categoryId = 0;		// ID
			$this->langId = $defaultLang;
			$name = '';		// 名前
			$code = '';		// 商品コード
			$index = '';	// 表示順
			$visible = 1;	// 表示状態
			$new = 0;// 新規
			$suggest = 0;// おすすめ
			$price = '';	// 価格
			$this->currency	= $this->ecObj->getDefaultCurrency();		// 通貨
			$this->unitTypeId = '';	// 単位
			$unitQuantity = 1;		// 数量
			$description = '';			// 説明
			$description_short = '';		// 簡易説明
			$keyword = '';					// 検索キーワード
			$url = '';							// 詳細情報URL
			$this->taxType	= self::DEFAULT_TAX_TYPE;		// 税種別
			$adminNote = '';		// 管理者用備考
			$updateUser = '';	// 更新者
			$updateDt = '';	// 更新日時
			$imageUrl_s = '';		// 商品画像小
			$imageUrl_m = '';		// 商品画像中
			$imageUrl_l = '';		// 商品画像大
		}
		// #### カテゴリーリストを作成 ####
		if ($this->categoryId == 0){
			$this->categoryPathArray = array();
		} else {
			$this->categoryPathArray = $this->createCategoryPath($this->categoryId);			// カテゴリーパスを作成
		}
		$categoryHtml =  $this->createCategoryTreeList($defaultLang);
		$this->tmpl->addVar("_widget", "category_list", $categoryHtml);
		
		// #### 商品リストを作成 ####
		//if ($this->categoryId != 0) $this->db->getProductByCategoryId($this->categoryId, $defaultLang, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		if ($this->categoryId == -1){		// カテゴリー外のとき
			$this->db->getProductByCategoryId(0/*カテゴリー未設定*/, $defaultLang, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		} else if ($this->categoryId != 0){
			$this->db->getProductByCategoryId($this->categoryId, $defaultLang, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		}
			
		// 商品カテゴリー名を設定
		$categoryName = '未選択';
		if ($this->categoryId == -1){
			$categoryName = '[カテゴリー外]';
		} else if ($this->categoryId != 0){
			$ret = $this->db->getCategoryByCategoryId($this->categoryId, $defaultLang, $row);
			if ($ret) $categoryName = $row['pc_name'];
		}
		$this->tmpl->addVar("_widget", "category_name", $categoryName);
		
		// #### 更新、新規登録部をを作成 ####
		// パラメータパターン
		// シリアル番号(0=未登録データ、0以外=登録済みデータ)
		// カテゴリーID(0=カテゴリー未選択、0以外=カテゴリー選択)
		// 商品ID(0=商品未選択、0以外=商品選択)
		
		// 選択中のカテゴリーIDを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		if ($this->serialNo == 0 && $this->productId == 0){		// シリアル番号、商品IDが0のときは新規とする
		//if ($this->serialNo == 0){		// シリアル番号が0のときは新規とする
			if ($this->categoryId == 0){	// カテゴリーが選択されていないときはメッセージ
				$this->tmpl->addVar("_widget", "id", '商品カテゴリーが選択されていません');
				$this->tmpl->addVar("_widget", "name_disabled", 'disabled');		// 商品名入力不可
				$this->tmpl->addVar("_widget", "code_disabled", 'disabled');		// 商品コード入力不可
			} else {
				$this->tmpl->addVar("_widget", "id", '新規');
			}
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// 新規追加をチェック状態にする
		
			// デフォルト言語を最初に登録
			$this->tmpl->addVar("default_lang", "default_lang", $defaultLangName);
			$this->tmpl->setAttribute('default_lang', 'visibility', 'visible');
		} else {
			$this->tmpl->addVar("_widget", "id", $this->productId);
		
			// 言語選択メニューを作成
			$this->db->getAllLang(array($this, 'langLoop'));
			$this->tmpl->setAttribute('select_lang', 'visibility', 'visible');
		}
		// 各種価格を求める
		$price = $this->ecObj->getCurrencyPrice($price);	// 端数調整
		$this->ecObj->setCurrencyType($this->currency, $this->langId);		// 通貨設定
		$this->ecObj->setTaxType($this->taxType, $this->langId);		// 税種別設定
		$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
		
		$this->tmpl->addVar("_widget", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "code", $code);		// 商品コード
		$this->tmpl->addVar("_widget", "index", $index);		// 表示順
		$this->tmpl->addVar("_widget", "unit_quantity", $unitQuantity);		// 数量
		$this->tmpl->addVar("_widget", "description", $description);		// 説明
		$this->tmpl->addVar("_widget", "desc_short", $description_short);		// 簡易説明		
		$this->tmpl->addVar("_widget", "keyword", $keyword);		// 検索キーワード
		$this->tmpl->addVar("_widget", "url", $url);				// 詳細情報URL
		$this->tmpl->addVar("_widget", "admin_note", $adminNote);			// 管理者用備考
		$this->tmpl->addVar("_widget", "price", $price);		// 価格
		$this->tmpl->addVar("_widget", "price_with_tax", $dispPrice);		// 税込価格
		
		$visibleStr = '';
		if ($visible){	// 項目の表示
			$visibleStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "visible", $visibleStr);		// 表示状態
		$visibleStr = '';
		if ($new){	// 新規
			$visibleStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "new", $visibleStr);
		$visibleStr = '';
		if ($suggest){	// おすすめ
			$visibleStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "suggest", $visibleStr);
		if (!empty($updateUser)) $this->tmpl->addVar("_widget", "update_user", $updateUser);	// 更新者
		if (!empty($updateDt)) $this->tmpl->addVar("_widget", "update_dt", $updateDt);	// 更新日時

		// 単位タイプ選択メニュー作成
		$this->db->getUnitType($defaultLang, array($this, 'unitTypeLoop'));

		// 通貨タイプ選択メニュー作成
		$this->db->getCurrency($defaultLang, array($this, 'currencyLoop'));

		// 課税タイプ選択メニューの作成
		$this->db->getTaxType($defaultLang, array($this, 'taxTypeLoop'));

		// 商品画像プレビューの作成
		// 画像小
		$destImg = '';
		if (empty($imageUrl_s)){
			$destImg = '<img id="preview_img_small" style="display:none;" ';
			$destImg .= 'width="' . $defaultImageSWidth . '" ';
			$destImg .= 'height="' . $defaultImageSHeight . '" ';
			$destImg .= '/>';
		} else {
			// URLマクロ変換
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_s);
			$destImg = '<img id="preview_img_small" src="' . $imgUrl . '" ';
			$destImg .= 'width="' . $defaultImageSWidth . '"';
			$destImg .= ' height="' . $defaultImageSHeight . '"';
			$destImg .= ' />';
		}
		$this->tmpl->addVar("_widget", "image_s", $destImg);
		// 画像中
		$destImg = '';
		if (empty($imageUrl_m)){
			$destImg = '<img id="preview_img_medium" style="display:none;" ';
			$destImg .= 'width="' . $defaultImageMWidth . '" ';
			$destImg .= 'height="' . $defaultImageMHeight . '" ';
			$destImg .= '/>';
		} else {
			// URLマクロ変換
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_m);
			$destImg = '<img id="preview_img_medium" src="' . $imgUrl . '" ';
			$destImg .= 'width="' . $defaultImageMWidth . '"';
			$destImg .= ' height="' . $defaultImageMHeight . '"';
			$destImg .= ' />';
		}
		$this->tmpl->addVar("_widget", "image_m", $destImg);
		// 画像大
		$destImg = '';
		if (empty($imageUrl_l)){
			$destImg = '<img id="preview_img_large" style="display:none;" ';
			$destImg .= 'width="' . $defaultImageLWidth . '" ';
			$destImg .= 'height="' . $defaultImageLHeight . '" ';
			$destImg .= '/>';
		} else {
			// URLマクロ変換
			$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl_l);
			$destImg = '<img id="preview_img_large" src="' . $imgUrl . '" ';
			$destImg .= 'width="' . $defaultImageLWidth . '"';
			$destImg .= ' height="' . $defaultImageLHeight . '"';
			$destImg .= ' />';
		}
		$this->tmpl->addVar("_widget", "image_l", $destImg);
		$this->tmpl->addVar("_widget", "image_s_width", $defaultImageSWidth);		// 商品画像小の幅
		$this->tmpl->addVar("_widget", "image_s_height", $defaultImageSHeight);		// 商品画像小の高さ
		$this->tmpl->addVar("_widget", "image_m_width", $defaultImageMWidth);		// 商品画像中の幅
		$this->tmpl->addVar("_widget", "image_m_height", $defaultImageMHeight);		// 商品画像中の高さ
		$this->tmpl->addVar("_widget", "image_l_width", $defaultImageLWidth);		// 商品画像大の幅
		$this->tmpl->addVar("_widget", "image_l_height", $defaultImageLHeight);		// 商品画像大の高さ
				
		// ボタンの設定
		if ($this->categoryId == 0){	// カテゴリーが選択されていないときはメッセージ
			//$this->tmpl->addVar("_widget", "message", '商品カテゴリーが選択されていません');
		} else {
			if ($this->serialNo == 0){		// 新規追加項目を選択しているとき
				$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
			} else {
				// データ更新、削除ボタン表示
				if ($this->langId == $defaultLang){		// デフォルト言語のときは「ID削除」ボタン
					$this->tmpl->setAttribute('delete_id_button', 'visibility', 'visible');// ID削除ボタン
				} else {
					$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// 削除ボタン
				}
				$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
			}
		}
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "category_id", $this->categoryId);	// カテゴリーID
		$this->tmpl->addVar("_widget", "product_id", $this->productId);		// 商品ID
		$this->tmpl->addVar("_widget", "image_url_s", $imageUrl_s);		// 画像小
		$this->tmpl->addVar("_widget", "image_url_m", $imageUrl_m);		// 画像中
		$this->tmpl->addVar("_widget", "image_url_l", $imageUrl_l);		// 画像大
				
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "widget_sc_url", $gEnvManager->getCurrentWidgetScriptsUrl());
		$this->tmpl->addVar("_widget", "image_path", $gEnvManager->getRootUrl() . '/resource/');		// 画像の格納場所
		
		/*
		// メニューを作成
		$menuText = '<table width="100%">';
		$menuText .= '<tr><td><input type="button" class="button" onClick="goTask(\'category\');" value="カテゴリー登録">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'product\');" value="商品管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'order\');" value="受注管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'member\');" value="会員管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'shopinfo\');" value="基本設定">' . M3_NL;
		$menuText .= '</td></tr>' . M3_NL;
		$menuText .= '</table>' . M3_NL;
		$menuText .= '<br>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $menuText);
		*/
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['pt_id']);
		$selected = '';
		if ($id == $this->productId){
			$selected = 'checked';
		}
		
		// 対応言語を取得
		$lang = '';
		$ret = $this->db->getLangByProductId($fetchedRow['pt_id'], $rows);
		if ($ret){
			$count = count($rows);
			for ($i = 0; $i < $count; $i++){
				if ($gEnvManager->getCurrentLanguage() == 'ja'){	// 日本語の場合
					$lang .= $rows[$i]['ln_name'];
					if ($i != $count -1) $lang .= ',';
				} else {
					$lang .= $rows[$i]['ln_name_en'];
					if ($i != $count -1) $lang .= ',';
				}
			}
		}
		$visible = '';
		if ($fetchedRow['pt_visible']){	// 項目の表示
			$visible = 'checked';
		}
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['pt_serial']),	// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['pt_name']),		// 名前
			'code' => $this->convertToDispString($fetchedRow['pt_code']),		// 商品コード
			'view_index' => $this->convertToDispString($fetchedRow['pt_sort_order']),		// 表示順
			'lang' => $lang,													// 対応言語
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['pt_create_dt']),	// 更新日時
			'visible' => $visible,											// メニュー項目表示制御
			'default' => $default,											// デフォルト項目
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->dispContIdArray[] = $fetchedRow['pt_id'];
		return true;
	}
	/**
	 * 取得したデータをCSV形式で出力する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productCsvListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 価格取得
		$ret = $this->db->getProductBySerial($fetchedRow['pt_serial'], $row, $row2, $row3, $row4);
		if ($ret){
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $this->ecObj->getCurrencyPrice($priceArray['pp_price']);	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別			

			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$priceWithTax = $this->ecObj->getCurrencyPrice($this->ecObj->getPriceWithTax($price, $dispPrice));	// 税込み価格取得
		}
					
		$buf = array();
		$delim = $gEnvManager->getDefaultCsvDelimCode();		// CSV区切りコードを取得
		if ($delim == "\t"){	// タブ区切りのCSVフォーマットのとき
			$buf[] = $fetchedRow['pt_name'];			// 商品名
			$buf[] = $fetchedRow['pt_code'];			// 商品コード
			$buf[] = $fetchedRow['ut_name'];			// 販売単位
			$buf[] = $price;							// 販売価格(税抜)
			$buf[] = $priceWithTax;							// 販売価格(税込)
			$buf[] = $fetchedRow['tt_name'];				// 税種別
			$buf[] = $fetchedRow['pt_description_short'];	// 簡易説明
			$buf[] = $fetchedRow['pt_category_id'];			// 商品カテゴリーID
		} else {
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pt_name']);			// 商品名
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pt_code']);			// 商品コード
			$buf[] = $this->convertToEscapedCsv($fetchedRow['ut_name']);			// 販売単位
			$buf[] = $this->convertToEscapedCsv($price);							// 販売価格(税抜)
			$buf[] = $this->convertToEscapedCsv($priceWithTax);							// 販売価格(税込)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['tt_name']);				// 税種別
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pt_description_short']);	// 簡易説明
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pt_category_id']);			// 商品カテゴリーID
		}
		$this->csvData[] = implode($delim, $buf) . $gEnvManager->getDefaultCsvNLCode();
		return true;
	}
	/**
	 * 取得した通貨種別をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function currencyLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		$selected = '';
		if ($fetchedRow['cu_id'] == $this->currency){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['cu_name']);

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['cu_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('currency_list', $row);
		$this->tmpl->parseTemplate('currency_list', 'a');
		return true;
	}
	/**
	 * 取得した単位をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function unitTypeLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ut_id'] == $this->unitTypeId){
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ut_id']),				// 単位ID
			'name'     => $this->convertToDispString($fetchedRow['ut_name']),			// 単位名
		//	'name'     => $fetchedRow['ut_name'],			// 単位名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('unit_type_list', $row);
		$this->tmpl->parseTemplate('unit_type_list', 'a');
		return true;
	}
	/**
	 * 取得した課税種別をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function taxTypeLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['tt_id'] == $this->taxType){
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['tt_id']),				// 単位ID
			'name'     => $this->convertToDispString($fetchedRow['tt_name']),			// 単位名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('tax_type_list', $row);
		$this->tmpl->parseTemplate('tax_type_list', 'a');
		return true;
	}
	/**
	 * 取得した言語をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ln_id'] == $this->langId){
			$selected = 'selected';
		}
		if ($gEnvManager->getCurrentLanguage() == 'ja'){		// 日本語表示の場合
			$name = $this->convertToDispString($fetchedRow['ln_name']);
		} else {
			$name = $this->convertToDispString($fetchedRow['ln_name_en']);
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ln_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		return true;
	}
	/**
	 * 追加するカテゴリーが、階層構造上で問題がないかチェック
	 *
	 * @param int $addCategory			追加するカテゴリー
	 * @param int $parentCategory		追加先親カテゴリー
	 * @return bool						true=正常、false=異常
	 */
	function canAddCategory($addCategory, $parentCategory)
	{
		global $gEnvManager;
		
		$pCategory = $parentCategory;
				
		// 自分自身のときはエラー
		if ($addCategory == $pCategory) return false;
		
		// カテゴリー最大階層まで親階層を検索
		$defaultLang = $gEnvManager->getDefaultLanguage();
		for ($i = 0; $i < self::MAX_HIER_LEVEL; $i++){
			$ret = $this->db->getCategoryByCategoryId($pCategory, $defaultLang, $row);
			if ($ret){
				$pCategory = $row['pc_parent_id'];// 親カテゴリー取得
				if ($pCategory == 0) return true;
				if ($pCategory == $addCategory) return false;
			} else {
				return false;
			}
		}
		return false;
	}
	
	/**
	 * ルートカテゴリーから指定したカテゴリーまでのパスを取得
	 *
	 * @param int $categoryId				カテゴリーID
	 * @return array						カテゴリーパス
	 */
	function createCategoryPath($categoryId)
	{
		global $gEnvManager;
		$pathArray = array();
		$pCategory = $categoryId;
		$pathArray[] = $pCategory;
		
		// カテゴリー最大階層まで親階層を検索
		$defaultLang = $gEnvManager->getDefaultLanguage();
		for ($i = 0; $i < self::MAX_HIER_LEVEL; $i++){
			$ret = $this->db->getCategoryByCategoryId($pCategory, $defaultLang, $row);
			if ($ret){
				$pCategory = $row['pc_parent_id'];// 親カテゴリー取得
				$pathArray[] = $pCategory;
				if ($pCategory == 0) break;
			}
		}
		return array_reverse($pathArray);
	}
	/**
	 * カテゴリーツリーリスト作成
	 *
	 * @param string	$langId				言語ID
	 * @return string						カテゴリーリスト表示用HTML
	 */
	function createCategoryTreeList($langId)
	{
		$listHtml = '';
		$this->createCategoryTreeListLoop(0, $langId, $listHtml);
		
		// カテゴリー外のカテゴリーを追加
		if ($this->categoryId == -1){
			$openStr = 'open="1"';
			$selectStr = 'select="1"';
		}
		$listHtml .= '<item text="[カテゴリー外]" id="-1" ' . $openStr . ' ' . $selectStr . '>' . M3_NL;
		$listHtml .= '</item>' . M3_NL;
		return $listHtml;
	}
	/**
	 * カテゴリーツリーリスト作成
	 *
	 * @param int       $parentId			親カテゴリーID
	 * @param string	$langId				言語ID
	 * @param array     $destArray			ツリー化したカテゴリー
	 * @return なし	
	 */
	function createCategoryTreeListLoop($parentId, $langId, &$listHtml)
	{
		$arraySize = $this->db->getChildCategoryWithRows($parentId, $langId, $rows);
		for ($i = 0; $i < $arraySize; $i++){
			$id = $rows[$i]['pc_id'];
			
			// カテゴリーパス上の項目のときは、フォルダをオープン状態にする
			$openStr = '';
			$selectStr = '';	// 選択カテゴリー
			$pathCount = count($this->categoryPathArray);	// 選択中のカテゴリーの階層
			for ($j = 0; $j < $pathCount; $j++){
				if ($id == $this->categoryPathArray[$j]){
					$openStr = 'open="1"';
					if ($j == $pathCount -1) $selectStr = 'select="1"';
					break;
				}
			}
			$listHtml .= '<item text="' . $rows[$i]['pc_name'] . '" id="' . $id . '" ' . $openStr . ' ' . $selectStr . '>' . M3_NL;
			$this->createCategoryTreeListLoop($id, $langId, $listHtml);
			$listHtml .= '</item>' . M3_NL;
		}
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 画像取得
	 *
	 * @param array  	$srcRows			画像リスト
	 * @param string	$imageType			画像タイプ
	 * @return array						取得した行
	 */
	function getImage($srcRows, $sizeType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['im_size_id'] == $sizeType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 商品ステータス取得
	 *
	 * @param array  	$srcRows			取得行
	 * @param string	$type			商品ステータスタイプ
	 * @return array						取得した行
	 */
	function getStatus($srcRows, $type)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['ps_type'] == $type){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
