<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installInitotherWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	const SAMPLE_DIR = 'sample';				// サンプルSQLディレクトリ名
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'initother.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gPageManager;
		global $gDbManager;		// DBマネージャー
		global $gEnvManager;
		
		$act = $request->trimValueOf('act');
		$type = $request->trimValueOf('install_type');
			
		if ($act == 'installec'){		// ECデータインストールのとき
			$filename = $request->trimValueOf('sample_sql');
			$scriptPath = $gEnvManager->getSqlPath() . '/' . self::SAMPLE_DIR . '/' . $filename;

			// スクリプト実行
			if (file_exists($scriptPath)){
				if ($gDbManager->execScriptWithConvert($scriptPath, $errors)){// 正常終了の場合
				//if ($gDbManager->execScript($scriptPath, $errors)){// 正常終了の場合
					$this->setMsg(self::MSG_GUIDANCE, 'データインストール完了しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, "データインストールに失敗しました");
				}
				if (!empty($errors)){
					foreach ($errors as $error) {
						$this->setMsg(self::MSG_APP_ERR, $error);
					}
				}
			} else {
				$this->setMsg(self::MSG_APP_ERR, "スクリプトファイルが見つかりません " . $scriptPath);
			}
		} else if ($act == 'done'){
			$gPageManager->redirect('?task=complete');
		} else {
			$this->tmpl->setAttribute('install_msg', 'visibility', 'visible');// テーブル構築完了のメッセージ
		}

		if ($type == 'all' || $this->getMsgCount() != 0){			// ECテーブルが作成されているとき
			$this->tmpl->setAttribute('install_demo', 'visibility', 'visible');// データインストール領域を表示
		}
		
		$this->tmpl->addVar('install_demo', 'script_ec', 'mysql_mobile_shop.sql');		// インストールスクリプト名
	}
}
?>
