<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainConfigsiteWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $defaultLang;		// デフォルト言語
	const CAN_DETAIL_CONFIG	= 'permit_detail_config';				// 詳細設定が可能かどうか
	const DEFAULT_LANG		= 'default_lang';					// デフォルト言語
	const SITE_IN_PUBLIC = 'site_in_public';			// サイト公開状況
	const SITE_ACCESS_EXCEPTION_IP = 'site_access_exception_ip';		// アクセス制御、例外とするIP
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'configsite.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userInfo		= $gEnvManager->getCurrentUserInfo();
		$this->defaultLang		= $gEnvManager->getDefaultLanguage();
		//$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
				
		$act = $request->trimValueOf('act');
		//$canDetailConfig = ($request->trimValueOf('item_can_detail_config') == 'on') ? 1 : 0;		// 詳細システム設定が可能かどうか
		if ($act == 'update'){		// 設定更新のとき
			$lang = $request->trimValueOf('item_lang');
//			$currency = $request->trimValueOf('item_currency');
			$siteName	= $request->trimValueOf('sitename');		// サイト名称
			$siteOwner	= $request->trimValueOf('siteowner');		// サイト所有者
			$siteCopyRight	= $request->trimValueOf('sitecopyright');		// サイト著作権
			//$siteEmail	= $request->trimValueOf('siteemail');		// サイトEメール
			$siteEmail	= trim($request->valueOf('siteemail'));		// サイトEメール
			$siteDesc = $request->trimValueOf('site_description');		// サイト要約
			$siteKeyword = $request->trimValueOf('site_keyword');		// サイトキーワード
		
			$isErr = false;
			if (!$isErr && !empty($lang)){
				if (!$this->db->updateSystemConfig(self::DEFAULT_LANG, $lang)) $isErr = true;
			}

			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_NAME, $siteName)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_OWNER, $siteOwner)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_COPYRIGHT, $siteCopyRight)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_EMAIL, $siteEmail)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_DESCRIPTION, $siteDesc)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSiteDef($lang, M3_TB_FIELD_SITE_KEYWORDS, $siteKeyword)) $isErr = true;
			}
			//$ret = $this->db->updateSystemConfig($canDetailConfig);
			//$ret = $this->db->updateSystemConfig(self::CAN_DETAIL_CONFIG, $canDetailConfig);
			if ($isErr){
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			} else {
				$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
			}
			// システムパラメータを更新
			$gEnvManager->loadSystemParams();
			
			// 値を再取得
		//	$canDetailConfig = $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
			$this->defaultLang		= $gEnvManager->getDefaultLanguage();
		} else if ($act == 'updateip'){		// IPアドレスを更新のとき
			$exceptIp = $request->trimValueOf('except_ip');

			// 入力チェック
			$this->checkIp($exceptIp, 'IP', true);
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$isErr = false;
				if (!$this->db->updateSystemConfig(self::SITE_ACCESS_EXCEPTION_IP, $exceptIp)) $isErr = true;
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			}
		} else if ($act == 'siteopen'){		// サイト運用開始のとき
			$this->db->updateSystemConfig(self::SITE_IN_PUBLIC, 1);
		} else if ($act == 'siteclose'){		// サイト運用停止のとき
			$this->db->updateSystemConfig(self::SITE_IN_PUBLIC, 0);
		} else {		// 初期表示の場合
			//if ($this->db->canDetailConfig()){
			//$canDetailConfig = $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
		}
		// サイト運用状況を設定
		if ($this->db->getSystemConfig(self::SITE_IN_PUBLIC)){		// 運用中のとき
			$this->tmpl->addVar("_widget", "site_open", '運用中');
			$this->tmpl->addVar("_widget", "site_open_status", '0');
			$this->tmpl->addVar("_widget", "site_open_label", '運用停止');
		} else {
			$this->tmpl->addVar("_widget", "site_open", '停止中');
			$this->tmpl->addVar("_widget", "site_open_status", '1');
			$this->tmpl->addVar("_widget", "site_open_label", '運用開始');
		}
		$this->tmpl->addVar("_widget", "except_ip", $this->db->getSystemConfig(self::SITE_ACCESS_EXCEPTION_IP));
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "site_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "site_name", $gEnvManager->getSiteName(true));
		$this->tmpl->addVar("_widget", "site_owner", $gEnvManager->getSiteOwner(true));
		$this->tmpl->addVar("_widget", "site_copyright", $gEnvManager->getSiteCopyRight(true));
		$this->tmpl->addVar("_widget", "site_email", $gEnvManager->getSiteEmail(true));
		$this->tmpl->addVar("_widget", "site_desc", $this->db->getSiteDef($this->defaultLang, M3_TB_FIELD_SITE_DESCRIPTION));
		$this->tmpl->addVar("_widget", "site_keyword", $this->db->getSiteDef($this->defaultLang, M3_TB_FIELD_SITE_KEYWORDS));
		
/*		$checked = '';
		if ($canDetailConfig) $checked = 'checked';
		$this->tmpl->addVar("_widget", "can_detail_config", $checked);
		*/
		
		// 言語選択メニューを作成
		$this->db->getAllLang(array($this, 'langLoop'));
		
		// 通貨タイプ選択メニュー作成
		//$this->db->getCurrency($this->defaultLang, array($this, 'currencyLoop'));
	}
	/**
	 * 取得した言語をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ln_id'] == $this->defaultLang){
			$selected = 'selected';
		}
		//if ($gEnvManager->getCurrentLanguage() == 'ja'){		// 日本語表示の場合
			$name = $this->convertToDispString($fetchedRow['ln_name']) . ' - ';
		//} else {
			$name .= $this->convertToDispString($fetchedRow['ln_name_en']);
		//}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ln_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		return true;
	}
}
?>
