<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_ec_mainBaseWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		global $gEnvManager;
		
		// 表示画面を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = 'top';

		$linkList = '';
		
		// 共通処理
		// コンテナを起動
		switch ($task){
			case 'top';			// トップ画面
			case 'category':	// 商品カテゴリ管理
			case 'product':		// 商品管理
			case 'order':		// 受注管理
			case 'member':		// 会員管理
				$menuText = '<div id="configmenu-upper">' . M3_NL;
				$menuText .= '<ul>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId();
				if ($task == 'top'){
					$linkList = 'トップ';// パンくずリスト
				}
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=category';
				if ($task == 'category'){
					$current = 'id="current"';
					$linkList = 'カテゴリー登録';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>カテゴリー登録</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=product';
				if ($task == 'product'){
					$current = 'id="current"';
					$linkList = '商品管理';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>商品管理</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=order';
				if ($task == 'order'){
					$current = 'id="current"';
					$linkList = '受注管理';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>受注管理</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=member';
				if ($task == 'member'){
					$current = 'id="current"';
					$linkList = '会員管理';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>会員管理</span></a></li>' . M3_NL;
				
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=shopinfo';
				$menuText .= '<li><a href="'. $link .'"><span>基本設定</span></a></li>' . M3_NL;
				$menuText .= '</ul>' . M3_NL;
				$menuText .= '</div>' . M3_NL;
				break;
			case 'shopinfo':		// ショップ情報
			case 'mailinfo':		// メール送信情報
			case 'paymethod':		// 支払い方法
			case 'delivmethod':		// 配送方法
			case 'init':		// 初期導入
			case 'imageupload':		// 画像アップロード
				$menuText = '<div id="configmenu-upper">' . M3_NL;
				$menuText .= '<ul>' . M3_NL;
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=category';
				$menuText .= '<li><a href="'. $link .'"><span>カテゴリー登録</span></a></li>' . M3_NL;
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=product';
				$menuText .= '<li><a href="'. $link .'"><span>商品管理</span></a></li>' . M3_NL;
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=order';
				$menuText .= '<li><a href="'. $link .'"><span>受注管理</span></a></li>' . M3_NL;
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=member';
				$menuText .= '<li><a href="'. $link .'"><span>会員管理</span></a></li>' . M3_NL;
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=shopinfo';
				$menuText .= '<li id="current"><a href="'. $link .'"><span>基本設定</span></a></li>' . M3_NL;
				$menuText .= '</ul>' . M3_NL;
				$menuText .= '</div>' . M3_NL;
				
				$menuText .= '<div id="configmenu-lower">' . M3_NL;
				$menuText .= '<ul>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=shopinfo';
				if ($task == 'shopinfo'){
					$current = 'id="current"';
					$linkList = '基本設定 &gt;&gt; ショップ情報';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>ショップ情報</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=delivmethod';
				if ($task == 'delivmethod'){
					$current = 'id="current"';
					$linkList = '基本設定 &gt;&gt; 配送方法';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>配送方法</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=paymethod';
				if ($task == 'paymethod'){
					$current = 'id="current"';
					$linkList = '基本設定 &gt;&gt; 支払い方法';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>支払い方法</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=imageupload';
				if ($task == 'imageupload'){
					$current = 'id="current"';
					$linkList = '基本設定 &gt;&gt; 画像アップロード';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>画像アップロード</span></a></li>' . M3_NL;
				
				$current = '';
				$link = $gEnvManager->getAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
						'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=init';
				if ($task == 'init'){
					$current = 'id="current"';
					$linkList = '基本設定 &gt;&gt; 初期導入';// パンくずリスト
				}
				$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>初期導入</span></a></li>' . M3_NL;
				$menuText .= '</ul>' . M3_NL;
				$menuText .= '</div>' . M3_NL;
				break;
		}
		$outputText .= '<table width="100%"><tr><td><label>' . $linkList . '</label></td></tr><tr><td>' . M3_NL . $menuText . '</td></tr></table>' . M3_NL;;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
