<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class admin_ec_mainInitWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const TAG_HEAD = 'TAG_';
	const COMPANY_NAME		= 'company_name';			// 会社名キー
	const COMPANY_ADDRESS	= 'company_address';		// 住所キー
	const COMPANY_FOUND_DT	= 'company_found_dt';		// 設立日キー
	const COMPANY_SENIOR_PT	= 'company_senior_pt';		// 代表者キー
	const COMPANY_BUSINESS	= 'company_business';		// 事業内容キー
	const COMPANY_BANK		= 'company_bank';			// 取引銀行キー
	const COMPANY_CUSTOMER	= 'company_customer';		// 取引先キー
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		//$this->db = new ec_mainDb();
		$this->db = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_init.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$companyName		= $request->trimValueOf(self::COMPANY_NAME);			// 会社名キー
		$companyAddress		= $request->trimValueOf(self::COMPANY_ADDRESS);		// 住所キー
		$companyFoundDt		= $request->trimValueOf(self::COMPANY_FOUND_DT);		// 設立日キー
		$companySeniorPt	= $request->trimValueOf(self::COMPANY_SENIOR_PT);		// 代表者キー
		$companyBusiness	= $request->trimValueOf(self::COMPANY_BUSINESS);		// 事業内容キー
		$companyBank		= $request->trimValueOf(self::COMPANY_BANK);			// 取引銀行キー
		$companyCustomer	= $request->trimValueOf(self::COMPANY_CUSTOMER);		// 取引先キー
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkInput($companyName, '会社名');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_NAME, $companyName)) $isErr = true;// 会社名キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_ADDRESS, $companyAddress)) $isErr = true;// 住所キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_FOUND_DT, $companyFoundDt)) $isErr = true;// 設立日キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_SENIOR_PT, $companySeniorPt)) $isErr = true;// 代表者キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_BUSINESS, $companyBusiness)) $isErr = true;// 事業内容キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_BANK, $companyBank)) $isErr = true;// 取引銀行キー
				}
				if (!$isErr){
					if (!$this->db->updateInitParam(self::COMPANY_CUSTOMER, $companyCustomer)) $isErr = true;// 取引先キー
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			
				// 値を再取得
				$companyName		= $this->db->getInitParam(self::COMPANY_NAME);			// 会社名キー
				$companyAddress		= $this->db->getInitParam(self::COMPANY_ADDRESS);		// 住所キー
				$companyFoundDt		= $this->db->getInitParam(self::COMPANY_FOUND_DT);		// 設立日キー
				$companySeniorPt	= $this->db->getInitParam(self::COMPANY_SENIOR_PT);		// 代表者キー
				$companyBusiness	= $this->db->getInitParam(self::COMPANY_BUSINESS);		// 事業内容キー
				$companyBank		= $this->db->getInitParam(self::COMPANY_BANK);			// 取引銀行キー
				$companyCustomer	= $this->db->getInitParam(self::COMPANY_CUSTOMER);		// 取引先キー
			}
		} else {		// 初期表示の場合
			$companyName		= $this->db->getInitParam(self::COMPANY_NAME);			// 会社名キー
			$companyAddress		= $this->db->getInitParam(self::COMPANY_ADDRESS);		// 住所キー
			$companyFoundDt		= $this->db->getInitParam(self::COMPANY_FOUND_DT);		// 設立日キー
			$companySeniorPt	= $this->db->getInitParam(self::COMPANY_SENIOR_PT);		// 代表者キー
			$companyBusiness	= $this->db->getInitParam(self::COMPANY_BUSINESS);		// 事業内容キー
			$companyBank		= $this->db->getInitParam(self::COMPANY_BANK);			// 取引銀行キー
			$companyCustomer	= $this->db->getInitParam(self::COMPANY_CUSTOMER);		// 取引先キー
		}
		// 値を画面に書き戻す
		$this->tmpl->addVar("_widget", self::COMPANY_NAME,		$companyName);		// 会社名キー
		$this->tmpl->addVar("_widget", self::COMPANY_ADDRESS,	$companyAddress);		// 住所キー
		$this->tmpl->addVar("_widget", self::COMPANY_FOUND_DT,	$companyFoundDt);		// 設立日キー
		$this->tmpl->addVar("_widget", self::COMPANY_SENIOR_PT, $companySeniorPt);		// 代表者キー
		$this->tmpl->addVar("_widget", self::COMPANY_BUSINESS,	$companyBusiness);		// 事業内容キー
		$this->tmpl->addVar("_widget", self::COMPANY_BANK,		$companyBank);		// 取引銀行キー
		$this->tmpl->addVar("_widget", self::COMPANY_CUSTOMER,	$companyCustomer);		// 取引先キー
		
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_NAME,		M3_TAG_START . strtoupper(self::COMPANY_NAME) . M3_TAG_END);		// 会社名キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_ADDRESS,	M3_TAG_START . strtoupper(self::COMPANY_ADDRESS) . M3_TAG_END);		// 住所キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_FOUND_DT,	M3_TAG_START . strtoupper(self::COMPANY_FOUND_DT) . M3_TAG_END);		// 設立日キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_SENIOR_PT, M3_TAG_START . strtoupper(self::COMPANY_SENIOR_PT) . M3_TAG_END);		// 代表者キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_BUSINESS,	M3_TAG_START . strtoupper(self::COMPANY_BUSINESS) . M3_TAG_END);		// 事業内容キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_BANK,		M3_TAG_START . strtoupper(self::COMPANY_BANK) . M3_TAG_END);		// 取引銀行キー
		$this->tmpl->addVar("_widget", self::TAG_HEAD . self::COMPANY_CUSTOMER,	M3_TAG_START . strtoupper(self::COMPANY_CUSTOMER) . M3_TAG_END);		// 取引先キー
		
		/*
		// メニューを作成
		$menuText = '<table width="100%">';
		$menuText .= '<tr><td><input type="button" class="button" onClick="goTask(\'category\');" value="カテゴリー登録">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'product\');" value="商品管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'order\');" value="受注管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'member\');" value="会員管理">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'shopinfo\');" value="基本設定">' . M3_NL;
		$menuText .= '</td></tr>' . M3_NL;
		$menuText .= '</td></tr>' . M3_NL;
		$menuText .= '<tr><td><input type="button" class="button" onClick="goTask(\'shopinfo\');" value="ショップ情報">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'mailinfo\');" value="メール連携">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'delivmethod\');" value="配送方法">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'paymethod\');" value="支払い方法">' . M3_NL;
		$menuText .= '<input type="button" class="button" onClick="goTask(\'init\');" value="初期導入">' . M3_NL;
		$menuText .= '</td></tr>' . M3_NL;
		$menuText .= '</table>' . M3_NL;
		$menuText .= '<br>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $menuText);*/
	}
}
?>
