<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class ec_mainOrderhistoryWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $productDb;	// DB接続オブジェクト
	private $langId;			// 現在の言語
	private $ecObj;					// EC共通ライブラリオブジェクト
	private $orderId;				// 現在選択中の受注ID
	private $isExistsOrder;			// 受注履歴があるかどうか
	private $lastOrderId;			// 最新の受注ID
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const STANDARD_PRICE = 'selling';		// 通常価格
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		$this->productDb = new productDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'orderhistory.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$userId = $gEnvManager->getCurrentUserId();		// ログイン中のユーザ
		$this->currency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		$this->orderId = $request->trimValueOf('item_order');		// 受注ID
		$act = $request->trimValueOf('act');
		
		// 注文履歴をすべて取得
		$this->db->getOrderHeaderByUser($userId, array($this, 'orderListLoop'));
		
		$showOrderDetail = false;		// 受注情報を表示フラグクリア
		if ($act == 'selorder'){		// 注文項目を選択
			// データにアクセス可能かチェック
			if ($this->db->isOrderByUser($this->orderId, $userId)){
				$showOrderDetail = true;		// 受注情報を表示
			} else {
				$this->setAppErrorMsg('アクセスできません');
			}
		} else {	// 初期処理
			if ($this->isExistsOrder){			// 受注履歴があるかどうか
				$this->orderId = $this->lastOrderId;
				$showOrderDetail = true;		// 受注情報を表示
			}
		}
		
		if ($showOrderDetail){		// 受注情報にアクセス可能なとき
			// 受注情報を取得
			$ret = $this->db->getOrder($this->orderId, $row);
			if ($ret){
				$this->currency	= $row['or_currency_id'];	// 通貨
				$subtotal = $row['or_subtotal'];		// 商品総額
				$delivFee = $row['or_deliv_fee'];		// 配送料
				$charge = $row['or_charge'];		// 手数料
				$total = $row['or_total'];			// 総額
				
				$subtotalStr = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $subtotal);
				$this->tmpl->addVar("order_history", "subtotal", $subtotalStr);		// 商品総額
				$delivFeeStr = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $delivFee);
				$this->tmpl->addVar("deliv_visible", "delivery_fee", $delivFeeStr);		// 送料
				$chargeStr = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $charge);
				$this->tmpl->addVar("charge_visible", "charge", $chargeStr);		// 手数料
				$totalStr = $this->ecObj->convertByCurrencyFormat($this->currency, $this->langId, $total);
				$this->tmpl->addVar("order_history", "total", $totalStr);		// 総額
				
				// 項目の表示制御
				if ($delivFee == 0) $this->tmpl->setAttribute('deliv_visible', 'visibility', 'hidden');
				if ($charge == 0) $this->tmpl->setAttribute('charge_visible', 'visibility', 'hidden');
				
				// 受注商品を取得
				$this->db->getOrderDetailList($this->orderId, array($this, 'orderItemLoop'));
			}
		}
		if ($this->isExistsOrder){			// 受注履歴があるかどうか
			$this->tmpl->setAttribute('order_history', 'visibility', 'visible');
		} else {
			$this->tmpl->addVar("_widget", "message", '注文履歴がありません');
		}
		// 遷移先を設定
		//$this->tmpl->addVar("_widget", "payment_url", $gEnvManager->createCurrentPageUrl() . '&task=payment');		// 支払い方法選択画面
		//$this->tmpl->addVar("_widget", "delivery_url", $gEnvManager->createCurrentPageUrl() . '&task=delivery');		// 配送先画面
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function orderListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['or_id'] == $this->orderId){		// 選択中の受注ID
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['or_id']),			// ID
			'name'     => $this->convertToDispDateTime($fetchedRow['or_regist_dt']),		// 注文日時
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('orderlist', $row);
		$this->tmpl->parseTemplate('orderlist', 'a');
		
		$this->isExistsOrder = true;			// 受注履歴があるかどうか
		if ($index == 0) $this->lastOrderId = $fetchedRow['or_id'];			// 最近の受注ID
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function orderItemLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		
		$priceStatus = 1;	// 価格が有効であるかどうか
		$id = $fetchedRow['od_product_id'];	// 商品ID
		
		// 商品を取得
		$ret = $this->productDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 価格が変更のときは、価格を無効にする
		$quantity = $fetchedRow['od_quantity'];
		$subtotal = $fetchedRow['od_total'];
		
		// 通貨情報を取得
		$ret = $this->productDb->getCurrency($this->currency, $this->langId, $row);
		if ($ret){
			$prePrice = $this->convertToDispString($row['cu_symbol']);
			$postPrice = $this->convertToDispString($row['cu_post_symbol']);
		}
		
		// 価格作成
		$this->ecObj->setCurrencyType($this->currency, $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($subtotal, $dispPrice);		// 小計の表示文字列作成
		
		// 小計価格
		$available = '';
		if ($priceStatus == 0) $available = '(無効)';
		$price = $prePrice . $dispPrice . $available;
		
		// 商品詳細へのリンク
		$url  = '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_FIND_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId();
		$url .= '&' . M3_REQUEST_PARAM_FROM . '=' . $gEnvManager->getCurrentWidgetId();		// 送信元
		$url .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode('product=' . $fetchedRow['si_product_id']);
			
		$nameLink = '<a href="' . $url . '">' . $name . '</a>';
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'name' => $name,
			'code' => $code,
			'unit_price' => $dispUnitPrice,			// 税込み単価
			'id' => $id,					// 商品ID
			'price' => $price,
			'quantity' => $quantity,
			'price_status' => $priceStatus		// 商品価格が有効かどうか
		);
		$this->tmpl->addVars('product_list', $row);
		$this->tmpl->parseTemplate('product_list', 'a');
		
		$this->productExists = true;			// カートに商品があるかどうか
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
