<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class ecLibDb extends BaseDb
{
	/**
	 * 通貨情報を取得
	 *
	 * @param string	$id					通貨種別ID
	 * @param string	$lang				言語ID
	 * @param array     $row				レコード
	 * @return bool							取得 = true, 取得なし= false
	 */
	function getCurrency($id, $lang, &$row)
	{
		$queryStr  = 'SELECT * FROM currency ';
		$queryStr .=   'WHERE cu_id = ? ';
		$queryStr .=   'AND cu_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($id, $lang), $row);
		return $ret;
	}
	/**
	 * 税情報を取得
	 *
	 * @param string	$id					税種別ID
	 * @param string	$lang				言語ID
	 * @param array     $row				レコード
	 * @return bool							取得 = true, 取得なし= false
	 */
	function getTaxType($id, $lang, &$row)
	{
		$queryStr  = 'SELECT * FROM tax_type ';
		$queryStr .=   'WHERE tt_id = ? ';
		$queryStr .=   'AND tt_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($id, $lang), $row);
		return $ret;
	}
	
	/**
	 * 税率を取得
	 *
	 * @param string	$rateTypeId			税率種別ID
	 * @param timestamp $dt					基準日
	 * @return float						0以外=税率、0=取得値なし
	 */
	function getTaxRate($rateTypeId, $dt = null)
	{
		$queryStr  = 'SELECT * FROM tax_rate ';
		$queryStr .=   'WHERE tr_id = ? ';
		$queryStr .=   'ORDER BY tr_priority';
		$ret = $this->selectRecord($queryStr, array($rateTypeId), $row);
		if ($ret){
			return $row['tr_rate'];
		} else {
			return 0;
		}
	}
	/**
	 * カートIDの最大シリアルNoを取得
	 *
	 * @return int		最大シリアルNo
	 */
	function getMaxSerialOfBasket()
	{
		$retValue = 0;
		$queryStr = 'select max(sh_serial) as m from shop_cart';
		$ret = $this->selectRecord($queryStr, array(), $row);
		if ($ret) $retValue = $row['m'];
		return $retValue;
	}
	/**
	 * デフォルト通貨を取得
	 *
	 * @param string	デフォルト通貨
	 */
	function getDefaultCurrency()
	{
		$retValue = '';
		$queryStr = 'select cg_value from commerce_config ';
		$queryStr .=  'where cg_id = ?';
		$ret = $this->selectRecord($queryStr, array('default_currency'), $row);
		if ($ret) $retValue = $row['cg_value'];
		return $retValue;
	}
	/**
	 * デフォルト言語を取得
	 *
	 * @param string	デフォルト言語
	 */
	function getDefaultLanguage()
	{
		$retValue = '';
		$queryStr = 'select sc_value from _system_config ';
		$queryStr .=  'where sc_id = ?';
		$ret = $this->selectRecord($queryStr, array('default_lang'), $row);
		if ($ret) $retValue = $row['sc_value'];
		return $retValue;
	}
	/**
	 * 自動生成会員番号の最大数
	 *
	 * @param string	$head			ヘッダ部の文字列
	 * @param int		最大数(見つからないときは0)
	 */
	function getMaxMemberNo($head)
	{
		$retNo = 0;
		$queryStr = 'SELECT sm_member_no FROM shop_member ';
		$queryStr .=  'WHERE sm_member_no LIKE \'' . $head . '%\' ';
		$queryStr .=  'ORDER BY sm_member_no DESC ';
		$ret = $this->selectRecord($queryStr, array(), $row);
		if ($ret){
			$retValue = $row['sm_member_no'];
			$retValue = str_replace($head, '', $retValue);// ヘッダ部削除
			if (is_numeric($retValue)) $retNo = intval($retValue);
		}
		return $retNo;
	}
	/**
	 * 仮会員を正会員に変更
	 *
	 * @param int $userId			ユーザID兼データ更新ユーザ
	 * @param string $memNo			会員番号
	 * @return						true=成功、false=失敗
	 */
	function makeTmpMemberToProperMember($userId, $memNo)
	{
//		global $gInstanceManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
				
		// トランザクション開始
		$this->startTransaction();
		
		$queryStr = 'SELECT * FROM shop_tmp_member WHERE sb_login_user_id = ? AND sb_deleted = false';
		$ret = $this->selectRecord($queryStr, array($userId), $row);
		if (!$ret){
			// トランザクション確定
			$this->endTransaction();
			return false;
		}
		
		// 新規IDを作成
		$newId = 1;
		$queryStr = 'select max(sm_id) as ms from shop_member ';
		$ret = $this->selectRecord($queryStr, array(), $maxRow);
		if ($ret) $newId = $maxRow['ms'] + 1;
		
		$type = 1;		// 会員種別(個人)

		// 会員番号の自動生成
		/*
		$memNo = '';
		if ($generateMemNo){
			//$memNo = $gInstanceManager->getObject(self::EC_LIB_ID)->generateMemberNo();
			$memNo = $this->generateMemberNo();
		}*/
		// 新規レコードを追加
		$queryStr  = 'INSERT INTO shop_member (';
		$queryStr .=   'sm_id, ';
		$queryStr .=   'sm_history_index, ';
		$queryStr .=   'sm_language_id, ';
		$queryStr .=   'sm_type, ';
		$queryStr .=   'sm_member_no, ';
		$queryStr .=   'sm_person_info_id, ';
		$queryStr .=   'sm_login_user_id, ';
		$queryStr .=   'sm_create_user_id, ';
		$queryStr .=   'sm_create_dt ';
		$queryStr .= ') VALUES (';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?, ';
		$queryStr .=   '?) ';
		$ret = $this->execStatement($queryStr, array($newId, 0, $row['sb_language_id'], $type, $memNo, $row['sb_person_info_id'], $row['sb_login_user_id'], $userId, $now));
		
		// 仮会員の情報を削除
		$queryStr  = 'UPDATE shop_tmp_member ';
		$queryStr .=   'SET sb_deleted = true, ';	// 削除
		$queryStr .=     'sb_update_user_id = ?, ';
		$queryStr .=     'sb_update_dt = ? ';
		$queryStr .=   'WHERE sb_serial = ?';
		$ret = $this->execStatement($queryStr, array($userId, $now, $row['sb_serial']));
								
		// トランザクション確定
		$ret = $this->endTransaction();
		return $ret;		
	}
}
?>
