<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainCreatetableWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;	// シリアルNo
	private $serialArray = array();		// 表示されているコンテンツシリアル番号
	private $tableId;		// 現在選択中のテーブル
	private $dataType;	// データ型
	private $createScript;		// テーブル作成スクリプト
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'createtable.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$act = $request->trimValueOf('act');
		$tableName = $request->trimValueOf('item_tableid');		// テーブル名
		$fieldName = $request->trimValueOf('add_id');		// フィールド名
		$this->dataType = $request->trimValueOf('add_type');// データ型
		$defaultValue = $request->trimValueOf('add_default');// デフォルト値
		$this->tableId = $request->trimValueOf('tableid');		// テーブルID
		
		$reloadData = false;		// データの再読み込み
		if ($act == 'update'){		// 行更新のとき
			// 入力チェック
			$this->checkInput($name, '名前');
			//$this->checkSingleByte($account, 'アカウント');
			$this->checkInput($account, 'アカウント');
			//$this->checkInput($password, 'パスワード');
			
			// アカウント重複チェック
			// 設定データを取得
			$ret = $this->db->getUserBySerial($this->serialNo, $row);
			if ($ret){
				if ($row['lu_account'] != $account && $this->sysDb->isExistsAccount($account)) $this->setMsg(self::MSG_USER_ERR, 'アカウントが重複しています');
			}
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateUser($this->serialNo, $name, $account, $password, $isAdmin, $canLogin, $userId, $newSerial);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$this->serialNo = $newSerial;
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'add'){		// フィールド新規追加のとき
			// 入力チェック
			$this->checkSingleByte($this->tableId, 'テーブル名');
			$this->checkSingleByte($fieldName, 'フィールド名');
			$this->checkSingleByte($this->dataType, 'データ型');

			// テーブル名エラーチェック
			if ($this->getMsgCount() == 0){
				// フィールド名重複チェック
				if ($this->db->isExistsField($this->tableId, $fieldName)) $this->setMsg(self::MSG_USER_ERR, 'フィールド名が重複しています');
			}
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addTableField($this->tableId, $fieldName, $this->dataType, $defaultValue);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
					
					// 追加行クリア
					$fieldName = '';		// フィールド名
					$this->dataType = '';// データ型
					$defaultValue = '';// デフォルト値
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ追加に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 削除のとき
			$ret = $this->db->delUserBySerial(array($this->serialNo));
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}
		} else if ($act == 'addtable'){		// テーブル名追加のとき
			$this->checkSingleByte($tableName, 'テーブル名');
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// テーブル名追加
				$ret = $this->db->addTableField($tableName, '', '', '');
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
				
					// 追加行クリア
					$fieldName = '';		// フィールド名
					$this->dataType = '';// データ型
					$defaultValue = '';// デフォルト値
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ追加に失敗しました');
				}
			}
		} else if ($act == 'seltable'){		// テーブル名選択のとき
			$fieldName = '';		// フィールド名
			$this->dataType = '';// データ型
			$defaultValue = '';// デフォルト値
		} else if ($act == 'createtable'){		// テーブル作成のとき
			$this->createScript = '';
			$this->createScript .= 'CREATE TABLE ' . $this->tableId . ' (' . M3_NL;
			$this->createScript .= '    serialno    INT AUTO_INCREMENT,' . M3_NL;
			$this->db->getTableDef($this->tableId, array($this, 'createScriptLoop'));
			$this->createScript .= '    PRIMARY KEY(serialno)' . M3_NL;
			$this->createScript .= ') TYPE=innodb;' . M3_NL;
			echo $this->createScript;
		} else {
			$reloadData = true;		// データの再読み込み
		}
		// テーブル名一覧取得
		$this->db->getAllTableIdList(array($this, 'tableIdLoop'));

		// テーブル定義一覧表示
		if (empty($this->tableId)){// テーブル新規追加のとき
			$this->tmpl->setAttribute('new_table_id', 'visibility', 'visible');
		} else {
			$this->tmpl->setAttribute('table_def', 'visibility', 'visible');
			$this->db->getTableDef($this->tableId, array($this, 'fieldListLoop'));
		}
		// 値を戻す
		$this->tmpl->addVar("_widget", "table_id", $this->tableId);
		$this->tmpl->addVar("_widget", "field_name", $fieldName);// フィールド名
		$this->tmpl->addVar("_widget", "field_default", $defaultValue);// デフォルト値
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function fieldListLoop($index, $fetchedRow, $param)
	{
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['td_serial']),			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['td_id']),			// ID
			'type' => $this->convertToDispString($fetchedRow['td_type']),		// データ型
			'default' => $this->convertToDispString($fetchedRow['td_default_value']),		// デフォルト値
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('fieldlist', $row);
		$this->tmpl->parseTemplate('fieldlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->serialArray[] = $fetchedRow['td_serial'];
		return true;
	}
	/**
	 * テーブル作成用スクリプトを作成する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function createScriptLoop($index, $fetchedRow, $param)
	{
		$dataType = $fetchedRow['td_type'];
		if (strncasecmp($dataType, 'text', strlen('text')) == 0 ||
			strncasecmp($dataType, 'char', strlen('char')) == 0 ||
			strncasecmp($dataType, 'varchar', strlen('varchar')) == 0 ||
			strncasecmp($dataType, 'timestamp', strlen('timestamp')) == 0){
			$defalut = '\'' . $fetchedRow['td_default_value'] . '\'';
		} else {
			$defalut = $fetchedRow['td_default_value'];
		}
		
	    $this->createScript .= '    ' . $fetchedRow['td_id'] . '    ' . $fetchedRow['td_type'] . '    DEFAULT ' . $defalut . '    NOT NULL,' . M3_NL;
		return true;
	}
	/**
	 * テーブル名一覧を作成
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function tableIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['td_table_id'] == $this->tableId){
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['td_table_id']),
			'name'     => $this->convertToDispString($fetchedRow['td_table_id']),
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('table_id_list', $row);
		$this->tmpl->parseTemplate('table_id_list', 'a');
		return true;
	}
}
?>
