var currentWidgetX = 8;	// カーソルの位置からのずれ(X座標)
var currentWidgetY = 16;// カーソルの位置からのずれ(Y座標)
var doubleClickCancel = false;		// ダブルクリック対応

// マウスが動いたときの処理
function m3MouseMove(e)
{
	var left = Event.pointerX(e);
	var top = Event.pointerY(e);
	
	var currentWidget = window.parent.currentWidget;
	if (currentWidget == ''){
		m3HideWidgetCursor(e);
	} else {
		// ウィジェットカーソル作成
		m3CreateWidgetCursor();
		
		m3ShowWidgetCursor(e);
	}
	// 親ウィンドウのカーソルを隠す
	if (window.parent.m3HideWidgetCursor) window.parent.m3HideWidgetCursor();
}
// マウスクリックしたときの処理
function m3MouseClick(e)
{
	var left = Event.pointerX(e);
	var top = Event.pointerY(e);
	var i;
	var position = '';
	var posId;
	
	// ウィジェット一覧外でのクリックの場合は、カーソルを隠す
	if (Element.hasClassName(Event.element(e), 'm3widget') && !window.parent.currentWidget){
		// ウィジェットカーソルなしの状態でウィジェットがクリックされたときはウィジェットを削除
	} else if (Element.hasClassName(Event.element(e), 'm3widget') ||		// ウィジェット内の場合
		Element.hasClassName(Event.element(e), 'm3position') ||				// ウィジェット一覧内の場合
		(Event.element(e) && Position.within(Event.element(e), left, top))){		// どこかのオブジェクト

		// ポジションを特定
		var posArray = document.m3main.positions.value.split(',');
		for (i = 0; i < posArray.length; i++)
		{
			posId = 'm3pos_' + posArray[i];
			if (Position.within($(posId), left, top)){
				position = posArray[i];
				break;
			}
		}
		var posIndex = -1;
		var widget;
		if (position){
			var elems = $(posId).getElementsByTagName('div');
			for (i = 0; i < elems.length; i++)
			{
				widget = elems[i];
				if (!widget.id) continue;
				var pos = getElementPosition(widget.id);
				var dim = Element.getDimensions(widget.id);
				if (top < pos.top + dim.height / 2){
					posIndex = i;
					break;
				}
			}
			if (posIndex == -1) posIndex = elems.length;
		}
		var curWidget = window.parent.currentWidget;
		if (curWidget && position && posIndex > -1){
			doubleClickCancel = true;		// 送信処理中なのでダブルクリック時の処理はキャンセル
			
			// ウィジェットをクリア
			window.parent.currentWidget = '';
			window.parent.currentWidgetName = '';
			window.parent.currentWidgetImg = '';

			document.m3main.task.value = 'addwidget';
			document.m3main.position.value = position;
			document.m3main.posindex.value = posIndex;
			document.m3main.widgets.value = curWidget;
			document.m3main.action = document.URL;
			document.m3main.submit();
			return true;
		} else {
			return false;
		}
	} else {
		// ウィジェットをキャンセル
		window.parent.currentWidget = '';
		window.parent.currentWidgetName = '';
		window.parent.currentWidgetImg = '';
		
		// ウィジェット付きカーソルを隠す
		m3HideWidgetCursor(e);
	}
}
// ウィジェット付きカーソルを表示
function m3ShowWidgetCursor(e)
{
	var left = Event.pointerX(e);
	var top = Event.pointerY(e);
	var cursorObj = $('m3WidgetCursor');
	cursorObj.style.left = left + currentWidgetX + "px";
	cursorObj.style.top = top + currentWidgetY + "px";
	cursorObj.style.visibility = "visible";
}
// ウィジェット付きカーソルを隠す
function m3HideWidgetCursor(e)
{
	var left = Event.pointerX(e);
	var top = Event.pointerY(e);
	var cursorObj = $('m3WidgetCursor');
	cursorObj.style.left = left + currentWidgetX + "px";
	cursorObj.style.top = top + currentWidgetY + "px";
	cursorObj.style.visibility = "hidden";
}
function m3HideWidgetCursor()
{
	var cursorObj = $('m3WidgetCursor');
	cursorObj.style.visibility = "hidden";
}
// ウィジェット付きカーソルを表示
function m3CreateWidgetCursor()
{
	var currentWidget = window.parent.currentWidget;
	var img = window.parent.currentWidgetImg;
	var name = window.parent.currentWidgetName;
	if (currentWidget){
		var layoj = $('m3WidgetCursor');
		layoj.innerHTML = '<table border="1" cellpadding="6" cellspacing="0"><tr><td bgcolor="#008b8b" align="center">'+ '<img src="' + img + '"/><br>' + 
			'<span style="color:#ffffff;font-size:small;font-weight:normal;">' + name + 
			'</span><br>' + '<span style="color:#ffffff;font-size:small;font-weight:normal;">' + currentWidget + '</span></td></tr></table>';
	}
}
// ウィジェットの位置を修正
function m3UpdateWidgetPosition(el)
{
	var posname = el.id.substr('m3pos_'.length);
	var widgethead = 'm3widget_' + posname + '_';
	
	var i;
	var widget;
	var widgets = '';
	var widgetno;
	var elems = el.getElementsByTagName('div');
	if (elems.length <= 0) return false;
	
	for (i = 0; i < elems.length; i++)
	{
		widget = elems[i];
		widgetno = widget.id.substr(widgethead.length);
		widgets += widgetno + ',';
	}
	widgets = widgets.substr(0, widgets.length-1);

	document.m3main.task.value = 'updatepagedef';
	document.m3main.position.value = posname;
	document.m3main.widgets.value = widgets;
	document.m3main.action = document.URL;
	document.m3main.submit();
	return true;
}
function getElementPosition(eremID)
{
    var offsetTrail = document.getElementById(eremID);
    var offsetLeft = 0;
    var offsetTop = 0;

    while(offsetTrail){
        offsetLeft += offsetTrail.offsetLeft;
        offsetTop += offsetTrail.offsetTop;
        offsetTrail = offsetTrail.offsetParent;
    }

    if(navigator.userAgent.indexOf("Mac") != -1 && typeof document.body.leftMargin != "undefined"){
        offsetLeft += document.body.leftMargin;
        offsetTop += document.body.topMargin;
    }

    return{ left:offsetLeft , top:offsetTop }
}
// ウィジェットをダブルクリックした場合は削除
function m3DoubleClickWidget(e, obj, widgetid)
{
	// シングルクリックの処理中のときは、処理を行わない
	if (doubleClickCancel) return false;
	
	var objId = obj.id;
	return m3DeleteWidget(objId, widgetid);
	/*
	var tag = 'm3widget_';
	var posArray = objId.substr(tag.length).split('_', 2);
	var position = posArray[0];// ポジション名
	var posId = 'm3pos_' + position;
	var elems = $(posId).getElementsByTagName('div');

	if (position){
		document.m3main.task.value = 'delwidget';
		document.m3main.position.value = position;
		document.m3main.posindex.value = posArray[1];
		document.m3main.widgetcount.value = elems.length;
		document.m3main.widgets.value = widgetid;
		document.m3main.action = document.URL;
		document.m3main.submit();
		return true;
	} else {
		return false;
	}*/
}
// ウィジェットを削除
function m3DeleteWidget(objId, widgetid)
{
	var tag = 'm3widget_';
	var posArray = objId.substr(tag.length).split('_', 2);
	var position = posArray[0];// ポジション名
	var posId = 'm3pos_' + position;
	var elems = $(posId).getElementsByTagName('div');

	if (position){
		document.m3main.task.value = 'delwidget';
		document.m3main.position.value = position;
		document.m3main.posindex.value = posArray[1];
		document.m3main.widgetcount.value = elems.length;
		document.m3main.widgets.value = widgetid;
		document.m3main.action = document.URL;
		document.m3main.submit();
		return true;
	} else {
		return false;
	}
}
// ウィジェットの共通属性を変更
function m3ToggleCommonWidget(objId, widgetid, status)
{
	var tag = 'm3widget_';
	var posArray = objId.substr(tag.length).split('_', 2);
	var position = posArray[0];// ポジション名
	var posId = 'm3pos_' + position;
	var elems = $(posId).getElementsByTagName('div');

	if (position){
		document.m3main.task.value = 'commonwidget';
		document.m3main.position.value = position;
		document.m3main.posindex.value = posArray[1];
		document.m3main.widgetcount.value = elems.length;
		document.m3main.widgets.value = widgetid;
		document.m3main.widgetcommon.value = status;
		document.m3main.action = document.URL;
		document.m3main.submit();
		return true;
	} else {
		return false;
	}
}
// 親ウィンドウを更新
function m3UpdateParentWindow()
{
	window.opener.location.href = window.opener.location.href;
}
// ウィンドウサイズ調整
function m3AdjustHeight(id, name)
{
	var app = navigator.appName.charAt(0);
	if(navigator.userAgent.indexOf('Safari') != -1){
		$(id).height = parent.frames[name].document.body.scrollHeight + 80;
	}else if (app == "N"){
		$(id).height = parent.frames[name].document.height +80;
	} else {
		$(id).height = parent.frames[name].document.body.scrollHeight + 80;
	}
}
