<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_menuDb.php');

class ec_menuWidgetContainer extends BaseWidgetContainer
{
	var $db;			// DB接続オブジェクト
	var $outputText;	// 作成したメニュー
	private $_menuType;	// メニュータイプ(0=テーブル、1=リスト)
	private $_menuTitle;	// メニュータイトル
	CONST EC_MENU_ID = 'ec_menu';				// メインメニューID
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_menuDb();
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		global $gEnvManager;
		
		// メニュー情報を取得
		$ret = $this->db->getMenu(self::EC_MENU_ID, $gEnvManager->getCurrentLanguage(), $row);
		if (!$ret){// 現在の言語で作成できない場合はデフォルト言語で作成
			$ret = $this->db->getMenu(self::EC_MENU_ID, $gEnvManager->getDefaultLanguage(), $row);
		}
		if ($ret){
			$this->_menuType = $row['me_type'];	// メニュータイプ
			if ($row['me_show_name']){		// メニュータイトル表示のとき
				$this->_menuTitle = $row['me_name'];
			}
		}
		return 'menu.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;
		
		// メニューテーブルのパラメータ
		$this->tmpl->addVar("_widget", "default_menu_param", $gDesignManager->getDefaultWidgetTableParam());
		
		// メニュータイトルの設定
		if (!empty($this->_menuTitle)){
			$titleString = '<tr><th>' . $this->_menuTitle . '</th><tr>';
			$this->tmpl->addVar("_widget", "title", $titleString);
		}
		
		// メインメニューの項目取得
		// 現在の言語で作成
		$this->db->getMenuItems(array($this, 'itemsLoop'), self::EC_MENU_ID, $gEnvManager->getCurrentLanguage());
		if ($this->outputText == ''){// 現在の言語で作成できない場合はデフォルト言語で作成
			$this->db->getMenuItems(array($this, 'itemsLoop'), self::EC_MENU_ID, $gEnvManager->getDefaultLanguage());
		}

		// 作成したメニュー出力
	//	$this->tmpl->addVar("_widget", "MENU", $this->outputText);
	}
	/**
	 * 取得したメニュー項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;

		// リンクタイプに合わせてタグを生成
		$option = '';
		switch ($fetchedRow['mi_link_type']){
			case 0:			// 同ウィンドウで開くリンク
				break;
			case 1:			// 別ウィンドウで開くリンク
				$option = 'target="_blank"';
				break;
		}
		
		// 「mainlevel」「sublevel」「active_menu」クラス名を設定する
		$name = '';
		if ($fetchedRow['mi_show_name']){	// 名前を表示するとき
			$name = $fetchedRow['mi_name'];
		}
		// リンク先の作成
		$linkUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, $fetchedRow['mi_param']);
		if ($fetchedRow['mi_enable']){		// 遷移可能なとき
			$link = '<a href="' . $linkUrl . '" class="mainlevel" ' . $option . '>' . $name . '</a>';
		} else {
			$link = $name;
		}
		
		$row = array(
			'menu_class' => 'mainlevel',	//
			'link' => $link		// リンク
		);
		$this->tmpl->addVars('linklist', $row);
		$this->tmpl->parseTemplate('linklist', 'a');
		
		$this->outputText .= $fetchedRow['mi_name'];
		return true;
	}
}
?>
