/**
 * Ajax非同期通信
 * @param string request_widget	指定ウィジェット
 * @param string request_params	リクエストパラメータ
 * @param string success_func	通信成功時の呼び出し関数
 * @param string failure_func	通信失敗時の呼び出し関数
 * @param string request_url	リクエスト先URL
 */
function m3_ajax_request(request_widget, request_params, success_func, failure_func, request_url)
{
	if (request_url == null || request_url == "") request_url = document.location.pathname;

	var params = "";
	if (request_widget != null && request_widget != "") params += "cmd=dowidget&widget=" + request_widget;
	if (request_params != null && request_params != "") params += "&" + request_params;

	new Ajax.Request(	request_url,
					{	method:			"post",
						parameters:		params,
						onSuccess:		function(request, json){
											m3_ajax_success(request, json, success_func);
										},
						onFailure:		function(request, json){
											m3_ajax_failure(request, json, failure_func);
										},
						evalScripts:	true	});
}
/**
 * Ajax非同期通信正常時に呼ばれるデフォルト関数
 * @param XMLHttpRequest	request		サーバからのレスポンス
 * @param Object			json		JSON型データ
 */
function m3_ajax_success(request, json, success_func)
{
	if (success_func == null || success_func == ''){
		alert(request.statusText + "\nstatus code = " + request.status);
	} else {
		if (eval('window.' + success_func) == null){
			alert('cannot found function: ' + success_func);
		} else {
			var retcode = -1;
			var jsondata;
			if (json != null){
				retcode = json.retcode;
				jsondata = json.data;
			}
			eval(success_func + '(request, retcode, jsondata);');
		}
	}
}
/**
 * Ajax非同期通信の通信エラー時に呼ばれるデフォルト関数
 * @param XMLHttpRequest	request		サーバからのレスポンス
 */
function m3_ajax_failure(request, json, failure_func)
{
	if (failure_func == null || failure_func == ''){
		alert(request.statusText + "\nstatus code = " + request.status);
	} else {
		if (eval('window.' + failure_func) == null){
			alert('cannot found function: ' + failure_func);
		} else {
			eval(failure_func + '(request);');
		}
	}
}

