<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installInputparamWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'inputparam.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gConfigManager;
		global $gPageManager;
		global $gEnvManager;
		
		// ########### 画面項目の表示制御 ############
		// PostgreSQLのPDOが使用可能かどうか
		$canUseDB = false;
		// PostgreSQLは非表示にする(暫定)
		if (extension_loaded('pdo_pgsql')){
			$this->tmpl->setAttribute("db_pgsql", "visibility", "visible");
			$canUseDB = true;
		} else {
			$this->tmpl->setAttribute("db_pgsql", "visibility", "hidden");
		}
		// MySQLのPDOが使用可能かどうか
		if (extension_loaded('pdo_mysql')){
			$this->tmpl->setAttribute("db_mysql", "visibility", "visible");
			$canUseDB = true;
		} else {
			$this->tmpl->setAttribute("db_mysql", "visibility", "hidden");
		}
		if (!$canUseDB) $this->setMsg(self::MSG_USER_ERR, "DBが使用できません");
		
		$isConfigured = false;		// 設定ファイルが作成されたかどうか
		$act = $request->trimValueOf('act');
		if ($act == ''){
			// 設定ファイルがある場合は、現在値を取得
			if ($gConfigManager->isConfigured()){
				$rooturl = $gConfigManager->getSystemRootUrl();
				$dsn = $gConfigManager->getDbConnectDsn();
				// DB種別を取得
				$pos = strpos($dsn, ':');
				if ($pos === false){
					$dbtype = '';
					$pos = -1;
				} else {
					$dbtype = trim(substr($dsn, 0, $pos));
				}
				// ホスト名、DB名を取得
				$hostname = '';
				$dbname = '';
				$dsnParams = explode(";", substr($dsn, $pos+1));
				for ($i = 0; $i < count($dsnParams); $i++){
					list($key, $value) = explode("=", $dsnParams[$i]);
					$key = trim($key);
					$value = trim($value);
					if ($key == 'host'){
						$hostname = $value;
					} else if ($key == 'dbname'){
						$dbname = $value;
					}
				}
				$dbuser = $gConfigManager->getDbConnectUser();
				$password = $gConfigManager->getDbConnectPassword();
			} else {// 設定値がないときはデフォルト値を設定
				$sytemRootUrl = $gEnvManager->calcSystemRootUrl();
				if (empty($sytemRootUrl)) $sytemRootUrl = 'http://' . $_SERVER['SERVER_NAME'] . '/' . M3_SYSTEM_ROOT_DIR_NAME;
				$rooturl = $sytemRootUrl;
				$hostname = 'localhost';
				$dbname = '';
				$dbuser = '';
				$password = '';
			}
		} else if ($act == 'save' || $act == 'testdb'){
			// ### 設定ファイルを更新した場合は次の画面へ遷移 ###
			// 入力項目のエラーチェック
			$rooturl = $request->trimValueOf('rooturl');
			$this->checkUrl($rooturl, 'ルートURL');
			$hostname = $request->trimValueOf('hostname');
			//$this->checkSingleByte($hostname, "ホスト名");// IPアドレスを入力したとき「.」が除かれる
			$dbuser = $request->trimValueOf('dbuser');
			$this->checkSingleByte($dbuser, "DBユーザ");
			$password = $request->trimValueOf('password');
			$dbname = $request->trimValueOf('dbname');
			$this->checkSingleByte($dbname, "DB名");
			
			// DB種別
			$dbtype = $request->trimValueOf('dbtype');
			if ($dbtype != M3_DB_TYPE_PGSQL && $dbtype != M3_DB_TYPE_MYSQL){		// DBが選択されていないとき
				$this->setMsg(self::MSG_USER_ERR, "DB種別が設定されていません");
			}

			if ($this->getMsgCount() == 0){// 入力チェックOKの場合
				if ($act == 'save'){		// 設定ファイルに保存の場合
					// 設定ファイルの作成
					$dsn = $dbtype . ':' . 'host=' . $hostname . ';dbname=' . $dbname;
					$updateParam = array();
					$gConfigManager->setDbConnectDsn($dsn);		// 接続先ＤＢ
					$gConfigManager->setDbConnectUser($dbuser);// 接続ユーザ
					$gConfigManager->setDbConnectPassword($password);	// パスワード
					$gConfigManager->setSystemRootUrl($rooturl);		// システムのルートURL
					$ret = $gConfigManager->updateConfigFile();
			
					// 完了メッセージを出力
					if ($ret){
						$this->setMsg(self::MSG_GUIDANCE, "設定値を更新しました");
						$isConfigured = true;
					} else {
						$this->setMsg(self::MSG_APP_ERR, "設定値の更新に失敗しました");
					}
				} else if ($act == 'testdb'){		// DB接続テスト
					$dsn = $dbtype . ':' . 'host=' . $hostname . ';dbname=' . $dbname;
					$db = new _installDB();
					if ($db->testDbConnection($dsn, $dbuser, $password)){
						$msg = '<b><font color="green">接続正常</font></b>';
						$msg .= ' => ';
						if ($db->testDbTable($dsn, $dbuser, $password)){
							$msg .= '<b><font color="green">テーブル作成正常</font></b>';
						} else {
							$msg .= '<b><font color="red">テーブル作成エラー</font></b>';
						}
					} else {
						$msg .= '<b><font color="red">接続エラー</font></b>';
					}
					$this->tmpl->addVar('_widget', 'db_test',	$msg);
				}
			}
		}
		// 入力データを再設定
		if ($dbtype == M3_DB_TYPE_PGSQL){
			$this->tmpl->addVar("db_pgsql", "checked", "checked");
		} else if ($dbtype == M3_DB_TYPE_MYSQL){
			$this->tmpl->addVar("db_mysql", "checked", "checked");
		}
		$this->tmpl->addVar("_widget", "root_url",	$rooturl);
		$this->tmpl->addVar("_widget", "dbuser",		$dbuser);
		$this->tmpl->addVar("_widget", "hostname",	$hostname);
		$this->tmpl->addVar("_widget", "password",	$password);
		$this->tmpl->addVar("_widget", "dbname",		$dbname);
		
		// 設定ファイルの内容をみて、ボタンを制御
		if (!$gConfigManager->isConfigured() && !$isConfigured) $this->tmpl->addVar('_widget', 'button_disabled', 'disabled');
	}
}
?>
