<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class reserve_mainDb extends BaseDb
{
	/**
	 * 予約定義値を取得
	 *
	 * @param string $type	定義タイプ
	 * @param string $key    キーとなる項目値
	 * @return string		値
	 */
	function getReserveConfig($type, $key)
	{
		$retValue = '';
		$queryStr = 'SELECT rc_value FROM reserve_config ';
		$queryStr .=  'WHERE rc_type  = ? ';
		$queryStr .=    'AND rc_id = ? ';
		$ret = $this->selectRecord($queryStr, array($type, $key), $row);
		if ($ret) $retValue = $row['rc_value'];
		return $retValue;
	}
	/**
	 * 予約定義値を更新
	 *
	 * @param string $type	定義タイプ
	 * @param string $key	キーとなる項目値
	 * @param string $value	設定値
	 * @return bool			true=更新成功、false=更新失敗
	 */
	function updateReserveConfig($type, $key, $value)
	{
		$queryStr = 'UPDATE reserve_config SET rc_value = ? ';
		$queryStr .=  'WHERE rc_type  = ? ';
		$queryStr .=    'AND rc_id = ? ';
		$params = array($value, $type, $key);
		$ret = $this->execStatement($queryStr, $params);
		return $ret;
	}
}
?>
