<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installCheckenvWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'checkenv.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gConfigManager;
		
		// 利用可能なDBをチェック
		// PostgreSQLのPDOが使用可能かどうか
		if (extension_loaded('pdo_pgsql')){
			$status = '利用可能';
			$version = exec("psql --version", $output);	// PostgreSQLバージョン取得
			// 出力からバージョンを抜き出す
			$words = explode(' ', $output[0]);
			$version = $words[count($words)-1];		// 行末にはバージョン数値が存在する
			if (empty($version)) $version = 'バージョン不明';
			$status .= '(' . $version . ')';
			$data = '<b><font color="green">' . $status . '</font></b>';
		} else {
			$status = '利用不可(pdo_pgsqlがインストールされていません)';
			$data = '<b><font color="red">' . $status . '</font></b>';
		}
		$this->tmpl->addVar("_widget","current_postgresql_status", $data);

		// MySQLのPDOが使用可能かどうか
		if (extension_loaded('pdo_mysql')){
			$status = '利用可能';
			$version = exec("mysql_config --version");	// MySQLバージョン取得
			if (empty($version)) $version = 'バージョン不明';
			$status .= '(' . $version . ')';
			$data = '<b><font color="green">' . $status . '</font></b>';
		} else {
			$status = '利用不可(pdo_mysqlがインストールされていません)';
			$data = '<b><font color="red">' . $status . '</font></b>';
		}
		$this->tmpl->addVar("_widget","current_mysql_status", $data);
		
		// PHPのバージョンをチェック
		$data = '<b><font color="green">5.1.0 以上</font></b>';
		$this->tmpl->addVar("_widget","config_php_version", $data);
		
		$phpVer = phpversion();
		if ($phpVer >= '5.1.0'){
			$data = '<b><font color="green">' . $phpVer . '</font></b>';
		} else {
			$data = '<b><font color="red">' . $phpVer . '</font></b>';
		}
		$this->tmpl->addVar("_widget","current_php_version", $data);
		
		// セーフモード
		$data = '<b><font color="green">off</font></b>';
		$this->tmpl->addVar("_widget","config_safe_mode", $data);
		if (ini_get('safe_mode')){
			$data = '<b><font color="red">on</font></b>';
		} else {
			$data = '<b><font color="green">off</font></b>';
		}
		$this->tmpl->addVar("_widget","current_safe_mode", $data);
	
		// ######## PHP拡張オプションのインストール状況 ########
		// PDO
		$data = '<b><font color="green">on</font></b>';
		$this->tmpl->addVar("_widget","config_pdo", $data);
		if (extension_loaded('pdo')){
			$data = '<b><font color="green">on</font></b>';
		} else {
			$data = '<b><font color="red">off(pdoがインストールされていません)</font></b>';
		}
		$this->tmpl->addVar("_widget","current_pdo", $data);
		
		// mbstring
		$data = '<b><font color="green">on</font></b>';
		$this->tmpl->addVar("_widget","config_mbstring", $data);
		if (extension_loaded('mbstring')){
			$data = '<b><font color="green">on</font></b>';
		} else {
			$data = '<b><font color="red">off</font></b>';
		}
		$this->tmpl->addVar("_widget","current_mbstring", $data);
		// mbstring.encoding_translation
		$data = '<b><font color="green">off</font></b>';
		$this->tmpl->addVar("_widget","config_mbstring_tran", $data);
		if (ini_get('mbstring.encoding_translation')){
			$data = '<b><font color="red">on</font></b>';
		} else {
			$data = '<b><font color="green">off</font></b>';
		}
		$this->tmpl->addVar("_widget","current_mbstring_tran", $data);

		// gd
		$data = '<b><font color="green">offでも動作可</font></b>';
		$this->tmpl->addVar("_widget","config_gd", $data);
		if (extension_loaded('gd')){
			$data = '<b><font color="green">on</font></b>';
		} else {
			$data = '<b><font color="red">off</font></b>';
		}
		$this->tmpl->addVar("_widget","current_gd", $data);
		// xml
		$data = '<b><font color="green">offでも動作可</font></b>';
		$this->tmpl->addVar("_widget","config_xml", $data);
		if (extension_loaded('xml')){
			$data = '<b><font color="green">on</font></b>';
		} else {
			$data = '<b><font color="red">off</font></b>';
		}
		$this->tmpl->addVar("_widget","current_xml", $data);
		
		// 設定ファイルのパス
		$data = $gConfigManager->configFilePath();
		$this->tmpl->addVar("_widget","current_config_path", $data);
		
		// 設定ファイルが書き込み可能かどうかチェック
		$data = '<b><font color="green">書き込み可能</font></b>';
		$this->tmpl->addVar("_widget","config_access", $data);
		
		if ($gConfigManager->isConfigDirWritable()){
			if ($gConfigManager->isConfigFileWritable()){
				$data = '<b><font color="green">書き込み可能</font></b>';
			} else {
				$data = '<b><font color="red">書き込み不可</font></b>';
			}
		} else {
			$data = '<b><font color="red">ディレクトリ書き込み不可</font></b>';
		}
		$this->tmpl->addVar("_widget","current_access", $data);
		
		// セッション保存用パス
		$sp = ini_get('session.save_path');
		$this->tmpl->addVar("_widget","current_session_path", $sp);
						
		$data = '<b><font color="green">どちらでも可</font></b>';
		$this->tmpl->addVar("_widget","config_session_access", $data);
		
		if (is_writable($sp)){
			$data = '<b><font color="green">書き込み可能</font></b>';
		} else {
			$data = '<b><font color="red">書き込み不可</font></b>';
		}
		$this->tmpl->addVar("_widget","current_session_access", $data);
	}
}
?>
