<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseIWidgetContainer.php');

class classrateWidgetContainer extends BaseIWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param string         $act			実行処理
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, $act, &$param)
	{
		global $gEnvManager;

		if ($act == 'calc'){		// 計算のとき
			$month	= $request->valueOf('iw_month');			// 月
			$date	= $request->valueOf('iw_day');			// 日
			$time	= $request->valueOf('iw_time');			// 時間帯
			
			// デフォルト値設定
			$price = 0;
			$priceTable = '';
			$paramObj = $this->getParamObj();
			if (!empty($paramObj)){
				$priceTable	= $paramObj->table;			// 料金テーブル
			}
			$priceArray = parseUserCustomParam($priceTable);	// 料金表を配列化
			
			// オプション値取得
			$productTotal = 0;
			$optionParamObj = $this->getOptionParamObj();
			if (!empty($optionParamObj)){
				$productTotal	= $optionParamObj->productTotal;			// 商品合計額
			}
			// 送料計算
			$foreValue = 0;
			for ($i = 0; $i < count($priceArray); $i++){
				if (empty($priceArray[$i]->key) || ($foreValue <= $productTotal && $productTotal < $priceArray[$i]->key)) break;
				$foreValue = $priceArray[$i]->key;
			}
			if ($i < count($priceArray)) $price = $priceArray[$i]->value;
			$price = intval($price);		// 数値化

			// 計算結果オブジェクトに設定
			$resultObj->price = $price;
			$resultObj->date = $this->convertToProperDate($month . '/' . $date);// 希望日付
			$resultObj->time = $time;		// 時間帯
			$this->setResultObj($resultObj);
		} else {		// 初期表示の場合
			// デフォルト値設定
			$price = 0;
			$priceTable = '';
			$paramObj = $this->getParamObj();
			if (!empty($paramObj)){
				$priceTable	= $paramObj->table;			// 料金テーブル
			}
		}
	}
}
?>
