<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_reserve_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/reserve_mainDb.php');

class admin_reserve_mainReserveWidgetContainer extends admin_reserve_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $serialNo;			// シリアル番号
	private $firstNo;			// 項目番号
	private $serialArray = array();		// 表示されている項目シリアル番号
	private $viewDayStart;		// 先頭に表示する日付
	private $viewDayRange;		// 表示範囲
	private $viewMinHour;			// 最小時間
	private $viewMaxHour;			// 最大時間
	private $availableTime = array();	// 選択可能時間
	const DEFAULT_RES_TYPE = 0;	// デフォルトの設定タイプ(常設)
	const DEFAULT_CONFIG_ID = 0;		// デフォルト定義ID
	const UNIT_INTERVAL_MINUTE = 'unit_interval_minute';	// 単位時間(分)
	const VIEW_DAY_RANGE = 'view_day_range';	// 表示範囲
	const VIEW_DAY_START = 'view_day_start';	// 先頭に表示する日付
	const DEFAULT_LIST_COUNT = 20;			// 最大リスト表示数
	const UNIT_ACTIVE_STYLE = 'style="background-color:white;border: 1px solid;"';	// カレンダー表の選択可能領域のカラー
	const UNIT_INACTIVE_STYLE = 'style="background-color:lightgray;border: 1px solid;"';	// カレンダー表の選択可能領域のカラー
	const ACCESS_TYPE = 'rv';			// ログインユーザのアクセス可能な機能タイプ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new reserve_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
		
		$this->unitIntervalMinute	= $this->db->getReserveConfig(self::DEFAULT_CONFIG_ID, self::UNIT_INTERVAL_MINUTE);		// 1単位あたりの時間
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'reserve_detail'){		// 詳細画面
			return 'admin_reserve_detail.tmpl.html';
		} else {
			return 'admin_reserve.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'reserve_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		global $gEnvManager;
		
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		$this->memberType	= $request->trimValueOf('member_type');				// 会員タイプ
		
		// デフォルト値を取得
		$maxListCount = self::DEFAULT_LIST_COUNT;
		$serializedParam = $this->sysDb->getWidgetParam($gEnvManager->getCurrentWidgetId());
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
///			$maxListCount = $dispInfo->maxMemberListCountByAdmin;		// 会員リスト最大表示数
		}
		
		// 予約可能範囲を取得
		$this->getAvailableTime();			

		$this->viewDayStart = $request->trimValueOf('day_start');		// 先頭に表示する日付
		$this->viewDayRange = $request->trimValueOf('day_range');		// 表示範囲
	
		$act = $request->trimValueOf('act');
		if ($act == 'delete'){		// 項目削除の場合
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				//$ret = $this->db->deleteDelivMethodDefBySerial($delItems);
				for ($i = 0; $i < count($delItems); $i++){
					$ret = $this->deleteUser($delItems[$i]);
					if (!$ret) break;
				}
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'selviewmenu'){		// 表示状態の変更のとき
			$this->db->updateReserveConfig(self::DEFAULT_CONFIG_ID, self::VIEW_DAY_START, $this->viewDayStart);// 先頭に表示する日付
			$this->db->updateReserveConfig(self::DEFAULT_CONFIG_ID, self::VIEW_DAY_RANGE, $this->viewDayRange);// 表示範囲
		} else {
			$this->viewDayStart = $this->db->getReserveConfig(self::DEFAULT_CONFIG_ID, self::VIEW_DAY_START);		// 先頭に表示する日付
			$this->viewDayRange = $this->db->getReserveConfig(self::DEFAULT_CONFIG_ID, self::VIEW_DAY_RANGE);		// 表示範囲
		}
		// リソース一覧を表示
		$this->db->getAllResource(self::DEFAULT_RES_TYPE, self::DEFAULT_CONFIG_ID, array($this, 'resourceListLoop'));
		
		// 先頭日付メニュー作成
		$this->createDayStartMenu();
		
		// 表示日数メニュー作成
		$this->createDayRangeMenu();
		
		// 予約表を作成
		$this->createDayList();
		
		// 予約登録部分を作成
		// 時間メニューを作成
		$this->createTimeMenu();
		
		// ユーザリストを取得
		$this->db->getAllUserListForMenu(self::ACCESS_TYPE, array($this, 'userListLoop'));
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		global $gEnvManager;
		global $gMailManager;
		global $gSystemManager;
		global $gInstanceManager;
		global $gPageManager;

		// ユーザ情報、表示言語
		$now = date("Y/m/d H:i:s");	// 現在日時
		$userId		= $gEnvManager->getCurrentUserId();
		$langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
				
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
				
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'add'){		// 項目追加の場合

		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($familyName, '会員名(姓)');
			$this->checkInput($firstName, '会員名(名)');
			$this->checkInput($familyNameKana, '会員名カナ(姓)');
			$this->checkInput($firstNameKana, '会員名カナ(名)');
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					// 登録済みのカテゴリーを取得
					$this->serialNo = $newSerial;
					$replaceNew = true;			// 会員情報を再取得
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除する会員が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->deleteUser($this->serialNo);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else if ($act == 'search'){		// 検索再実行
		} else {	// 初期表示
			// 会員IDが指定されている場合は正会員情報を表示
			$memberId = $request->trimValueOf('member');			// 会員ID
			if (empty($memberId)){
				if (empty($this->serialNo)){		// 新規登録のとき
			
					// 会員NOのデフォルト値を自動生成
					$memberNo = $gInstanceManager->getObject(self::EC_LIB_ID)->generateMemberNo();
				} else {
					$replaceNew = true;			// 会員情報を再取得
				}
			} else {
				$this->serialNo = $this->db->getMemberSerialById($memberId);
				if (!empty($this->serialNo)) $replaceNew = true;			// 会員情報を再取得
			}
		}
		// 会員情報を再取得
		if ($replaceNew){

		}
		
		// #### 更新、新規登録部をを作成 ####
		$this->tmpl->addVar("_widget", "member_no", $memberNo);		// 会員No
		
		// ボタンの設定
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			// 画面タイトル
			$this->tmpl->addVar("_widget", "title", '正会員詳細');
			
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
			
			// パスワード送信ボタンの使用制御
			//$this->tmpl->addVar("_widget", "password_disabled", 'disabled');
			$this->tmpl->addVar("_widget", "send_pwd", 'disabled');
		} else {
			
			$this->tmpl->addVar("_widget", "email_disabled", 'disabled');		// eメール(ログインアカウント)
			
			// パスワード送信ボタンの使用制御
			//$this->tmpl->setAttribute('send_password', 'visibility', 'visible');
			
			// データ更新、削除ボタン表示
			$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// 削除ボタン
		}
		
		// 値を埋め込む
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());	// スクリプトパスの設定
	}
	/**
	 * 先頭の日付のメニュー作成
	 *
	 * @return なし
	 */
	function createDayStartMenu()
	{
		$days = array(array(0, '今日'), array(1, '今週'), array(2, '先週'), array(3, '先々週'), array(11, '前日'), array(12, '3日前'));
		for ($i = 0; $i < count($days); $i++){
			$value = $days[$i][0];
			$name = $days[$i][1];
			$selected = '';
			if ($value == $this->viewDayStart) $selected = 'selected';
			$row = array(
				'value'    => $value,			// 値
				'name'     => $name,			// 表示名
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('day_start', $row);
			$this->tmpl->parseTemplate('day_start', 'a');
		}
	}
	/**
	 * 表示日数のメニュー作成
	 *
	 * @return なし
	 */
	function createDayRangeMenu()
	{
		$days = array(14, 30, 45, 60);		// 表示日数
		for ($i = 0; $i < count($days); $i++){
			$value = $days[$i];
			$name = $value;
			$selected = '';
			if ($value == $this->viewDayRange) $selected = 'selected';
			$row = array(
				'value'    => $value,			// 値
				'name'     => $name,			// 表示名
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('day_range', $row);
			$this->tmpl->parseTemplate('day_range', 'a');
		}
	}
	/**
	 * 予約可能範囲を取得
	 *
	 * @return なし
	 */
	function getAvailableTime()
	{
		// 設定値を取得
		$ret = $this->db->getCalendarByWeek(self::DEFAULT_CONFIG_ID, $rows);
		if ($ret){
			// データ初期化
			$newAvailableTime = array();
			for ($i = 0; $i < 7; $i++){
				$newAvailableTime[] = array(array(-1, -1, -1, -1), array(-1, -1, -1, -1));
			}
			// 最小、最大表示時間
			$this->viewMinHour = 24;			// 最小時間
			$this->viewMaxHour = 0;			// 最大時間
			for ($i = 0; $i < count($rows); $i++){
				// 時間を解析
				$startHour		= intval($rows[$i]['ra_start_time'] / 100);
				$startMinute	= $rows[$i]['ra_start_time'] - $startHour * 100;
				$endHour		= intval($rows[$i]['ra_end_time'] / 100);
				$endMinute		= $rows[$i]['ra_end_time'] - $endHour * 100;

				// 最小、最大表示時間更新
				if ($this->viewMinHour > $startHour) $this->viewMinHour = $startHour;
				if ($this->viewMaxHour * 100 < $endHour * 100 + $endMinute) $this->viewMaxHour = $endHour;
				
				if ($rows[$i]['ra_specify_type'] == 1){		// 曜日指定のとき
					$attr = $rows[$i]['ra_day_attribute'] -1;		// 曜日取得
					if ($newAvailableTime[$attr][0][0] == -1){	// 前半データ
						$newAvailableTime[$attr][0][0] = $startHour;
						$newAvailableTime[$attr][0][1] = $startMinute;
						$newAvailableTime[$attr][0][2] = $endHour;
						$newAvailableTime[$attr][0][3] = $endMinute;
					} else {		// 後半データ
						$newAvailableTime[$attr][1][0] = $startHour;
						$newAvailableTime[$attr][1][1] = $startMinute;
						$newAvailableTime[$attr][1][2] = $endHour;
						$newAvailableTime[$attr][1][3] = $endMinute;
					}
				}
			}
			// 最小、最大表示時間更新
			$this->viewMaxHour++;
			if ($this->viewMaxHour > 24) $this->viewMaxHour = 24;
			
			// 取得値を更新
			$this->availableTime = $newAvailableTime;
		}
	}
	/**
	 * 予約表を作成
	 *
	 * @return なし
	 */
	function createDayList()
	{
		// 1時間あたりの分割数
		$unitCount = 60 / $this->unitIntervalMinute;
		
		// ヘッダ作成
		$head = '';
		for ($i = $this->viewMinHour ;	$i < $this->viewMaxHour; $i++){
			$head .= '<th width="200px" colspan="' . $unitCount . '" style="border-left: 1px solid;border-right: 1px solid;">' . $i . ':00' . '</th>';
		/*
			for ($j = 0; $j < $unitCount; $j++){
				if ($j == 0){		// 左端
					$head .= '<th width="100px" style="border-left: 1px solid;">' . $i . ':00' . '</th>';
				} else if ($j == $unitCount -1){		// 右端
					$head .= '<th width="100px" style="border-right: 1px solid;">&nbsp;&nbsp;&nbsp;&nbsp;</th>';
				} else {
					$head .= '<th width="100px">&nbsp;&nbsp;&nbsp;&nbsp;</th>';
				}
			}*/
		}
		$this->tmpl->addVar("_widget", "head", $head);// ヘッダ部タイトル
		
		// 本日を取得
		list($yyyy, $mm, $dd) = split('[/.-]', date("Y/m/d"));
		$todayYear = intval($yyyy);
		$todayMonth = intval($mm);
		$todayDay = intval($dd);

		// 先頭日を求める
		$date = '';		// 先頭日
		switch ($this->viewDayStart){
			case 0:			// 本日から表示
				$date = date("Y/m/d");
				break;
			case 1:			// 今週から表示
				// 日曜日までの日数を求める
				$startDay = $dayOfWeek * (-1);
				$date = date("Y/m/d", strtotime("$startDay day"));
				break;
			case 2:			// 先週から表示
				// 日曜日までの日数を求める
				$startDay = $dayOfWeek * (-1) - 7;
				$date = date("Y/m/d", strtotime("$startDay day"));
				break;
			case 3:			// 先々週から表示
				// 日曜日までの日数を求める
				$startDay = $dayOfWeek * (-1) - 14;
				$date = date("Y/m/d", strtotime("$startDay day"));
				break;
			case 11:		// 前日から表示
				$date = date("Y/m/d", strtotime("-1 day"));
				break;
			case 12:		// 3日前から表示
				$date = date("Y/m/d", strtotime("-3 day"));
				break;
		}
		// 年月日を分割
		list($yyyy, $mm, $dd) = split('[/.-]', $date);
		$year = intval($yyyy);
		$month = intval($mm);
		$day = intval($dd);
			
		// 先頭の曜日
		$dayOfWeek = date("w", mktime(0, 0, 0, $month, $day, $year));
		
		for ($i = 0; $i < $this->viewDayRange; $i++){
			// 日付作成
			if ($i == 0 || $day == 1){
				$viewDate = $month . '/' . $day;
			} else {
				$viewDate = $day;
			}
			// 日付のカラー設定
			if ($year == $todayYear && $month == $todayMonth && $day == $todayDay){	// 本日のとき
				$viewDate = '<b><font color="green">' . $viewDate . '</font></b>';
			} else if ($dayOfWeek == 0){		// 日曜日のとき
				$viewDate = '<b><font color="red">' . $viewDate . '</font></b>';
			}
			// 有効範囲の取得
			$startHourMinute = -1;
			$endHourMinute = -1;
			$startHourMinute2 = -1;
			$endHourMinute2 = -1;
			// 同じ曜日の値で上書き
			$hourMinute = $this->availableTime[$dayOfWeek];			// 設定時分を取得
			// 前半
			$startHour = $hourMinute[0][0];
			$startMinute = $hourMinute[0][1];
			$endHour = $hourMinute[0][2];
			$endMinute = $hourMinute[0][3];
			if ($startHour != -1){
				$startHourMinute = $startHour * 100 + $startMinute;
				$endHourMinute = $endHour * 100 + $endMinute;
			}
			// 後半
			$startHour = $hourMinute[1][0];
			$startMinute = $hourMinute[1][1];
			$endHour = $hourMinute[1][2];
			$endMinute = $hourMinute[1][3];
			if ($startHour != -1){
				$startHourMinute2 = $startHour * 100 + $startMinute;
				$endHourMinute2 = $endHour * 100 + $endMinute;
			}			
			
			$line = '';
			for ($j = $this->viewMinHour ;	$j < $this->viewMaxHour; $j++){
				for ($k = 0; $k < $unitCount; $k++){
					// 選択単位の先頭の時間
					$unitHourMinute = $j * 100 + $this->unitIntervalMinute * $k;

					// カラーの設定
					$unitStyle = self::UNIT_INACTIVE_STYLE;		// 無効領域のカラー
					if (($startHourMinute != -1 && ($startHourMinute <= $unitHourMinute && $unitHourMinute < $endHourMinute)) ||
						($startHourMinute2 != -1 && ($startHourMinute2 <= $unitHourMinute && $unitHourMinute < $endHourMinute2))){		// 有効時間のとき
						$unitStyle = self::UNIT_ACTIVE_STYLE;
					}
					$regData = '';		// 登録されているデータ
					$line .= '<td ' . $unitStyle . '>' . $regData . '</td>';
				}
			}
			$row = array(
				'index'    => $i,			// インデックス番号
				'sel_date'    => $year . '/' . $month . '/' . $day,			// 選択用日付
				'date'    => $viewDate,			// 日付
				'line'     => $line,			// 行データ
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('itemlist', $row);
			$this->tmpl->parseTemplate('itemlist', 'a');
			
			// 翌日を求める
			list($yyyy, $mm, $dd) = split('[/.-]', date("Y/m/d", mktime(0, 0, 0, $month, $day + 1, $year)));
			
			$year = intval($yyyy);
			$month = intval($mm);
			$day = intval($dd);
			
			// 曜日を更新
			$dayOfWeek++;
			if ($dayOfWeek == 7) $dayOfWeek = 0;
		}
		$this->tmpl->addVar("_widget", "view_range", '(' . $date . '～' . ')');
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function resourceListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$row = array(
			'value'    => $fetchedRow['rr_index'],			// 値
			'name'     => $this->convertToDispString($fetchedRow['rr_name']),			// 表示名
			'selected' => $selected		// 選択中かどうか
		);
		$this->tmpl->addVars('resource', $row);
		$this->tmpl->parseTemplate('resource', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function userListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$name = $this->convertToDispString($fetchedRow['li_family_name']) . '&nbsp;' . $this->convertToDispString($fetchedRow['li_first_name']);
		$no = $this->convertToDispString($fetchedRow['li_no']);			// ユーザ番号
		if (!empty($no)) $no = '&nbsp;-&nbsp;' . $no;
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['li_id']),			// 値
			'name'     => $name,			// 表示名
			'no'     => $no,			// ユーザ番号
			'selected' => $selected		// 選択中かどうか
		);
		$this->tmpl->addVars('user_list', $row);
		$this->tmpl->parseTemplate('user_list', 'a');
		return true;
	}
	/**
	 * 時間メニューを作成
	 *
	 * @return なし
	 */
	function createTimeMenu()
	{
		// 1時間あたりの分割数
		$unitCount = 60 / $this->unitIntervalMinute;
		
		// 時メニュー作成
		for ($j = 0; $j < 24; $j++){
			$selected = '';
			$row = array(
				'value'    => $j,			// 値
				'name'     => $j,			// 表示名
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('start_hour', $row);
			$this->tmpl->parseTemplate('start_hour', 'a');
		}
		// 分メニュー作成
		for ($j = 0; $j < $unitCount; $j++){
			$minute = $this->unitIntervalMinute * $j;
			$selected = '';
			$row = array(
				'value'    => $minute,			// 値
				'name'     => $minute,			// 表示名
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('start_minute', $row);
			$this->tmpl->parseTemplate('start_minute', 'a');
		}
	}
}
?>
