<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class admin_menuDb extends BaseDb
{
	const MENUBAR_ALWAYS_VISIBLE = 'menubar_always_visible';				// メニューバーを常時表示するかどうか
	
	/**
	 * システム定義値を取得
	 *
	 * @param string $key		キーとなる項目値
	 * @return string $value	値
	 */
	function getSystemConfig($key)
	{
		$retValue = '';
		$queryStr = 'SELECT sc_value FROM _system_config ';
		$queryStr .=  'WHERE sc_id  = ?';
		$ret = $this->selectRecord($queryStr, array($key), $row);
		if ($ret) $retValue = $row['sc_value'];
		return $retValue;
	}
	/**
	 * ナビゲーションバー項目を取得
	 *
	 * @param string $navId			ナビゲーションバー識別ID
	 * @param string $parentId		親項目ID
	 * @param array  $rows			取得レコード
	 * @return						true=取得、false=取得せず
	 */
	function getNavItems($navId, $parentId, &$rows)
	{
		$queryStr  = 'SELECT * FROM _nav_item ';
		$queryStr .=   'WHERE ni_nav_id = ? ';
		$queryStr .=     'AND ni_parent_id = ? ';
		$queryStr .=     'AND ni_visible = true ';
		$queryStr .=   'ORDER BY ni_index';
		
		$retValue = $this->selectRecords($queryStr, array($navId, $parentId), $rows);
		return $retValue;
	}
	/**
	 * ナビゲーションバー項目を取得(タスク指定)
	 *
	 * @param string $navId			ナビゲーションバー識別ID
	 * @param string $taskId		タスクID
	 * @param array  $row			取得レコード
	 * @return						true=取得、false=取得せず
	 */
	function getNavItemsByTask($navId, $taskId, &$row)
	{
		$queryStr  = 'SELECT * FROM _nav_item ';
		$queryStr .=   'WHERE ni_nav_id = ? ';
		$queryStr .=     'AND ni_task_id = ? ';
		$queryStr .=     'AND ni_visible = true ';
		$retValue = $this->selectRecord($queryStr, array($navId, $taskId), $row);
		return $retValue;
	}
	/**
	 * 管理メニューを常時表示するかどうか
	 *
	 * @return bool					true=表示、false=非表示
	 */
	function menubarAlwaysVisible()
	{
		$retValue = $this->getSystemConfig(self::MENUBAR_ALWAYS_VISIBLE);
		return $retValue;
	}
}
?>
