<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bannerDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class bannerWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $_contentCreated;	// コンテンツが取得できたかどうか
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	const DEFAULT_CONFIG_ID = 1;		// 定義が設定されていないときのデフォルト値
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bannerDb();
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		global $gEnvManager;

		// 定義ID取得
		$configId = $gEnvManager->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;

		// バナー定義を取得
		if (!empty($configId) && ValueCheck::isNumeric($configId)){
			$ret = $this->db->getBannerByBannerId($configId, $row);
			if ($ret){
				$param = $row;
				if ($row['bd_disp_direction'] == 1){	// 横方向に並べる場合
					return 'main_v.tmpl.html';
				}
			}
		}
		return 'main_v.tmpl.html';		// 縦並び
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gAccessManager;
		global $gPageManager;
		
		// 現在日時を取得
		//$this->currentDay = date("Y/m/d");		// 日
		//$this->currentHour = (int)date("H");		// 時間
		
		// ウィジェット単体実行の場合
		$cmd = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_COMMAND);
		if ($cmd == M3_REQUEST_CMD_DO_WIDGET){	// ウィジェット単体実行
			$stamp = $request->trimValueOf(M3_REQUEST_PARAM_STAMP);	// 公開ID
			$url = $request->trimValueOf(M3_REQUEST_PARAM_URL);		// リダイレクトURL
			
			// バナーをクリックしたログを残す
			$this->db->clickBannerItemLog($stamp, $url, $gAccessManager->getAccessLogSerialNo());
			
			// リンク先を表示
			$gPageManager->redirect($url);
			return;
		}
		// バナー定義が取得できたときは、バナーを画面に出力
		if (!empty($param)){
			$itemArray = explode(',', $param['bd_item_id']);
			if (count($itemArray) > 0){
				// 表示するバナー項目を決定する
				$itemCount = $param['bd_disp_item_count'];
				$dispItemArray = array();
				switch ($param['bd_disp_type']){
					case 0:// サイクリック
						$firstIndex = $param['bd_first_item_index'];
						if ($firstIndex < 0 || $firstIndex >= count($itemArray)) $firstIndex = 0;
						if ($itemCount > count($itemArray)) $itemCount = count($itemArray);
						$count = count($itemArray);
						for ($i = $firstIndex; $i < $count; $i++)
						{
							$dispItemArray[] = $itemArray[$i];
							if (count($dispItemArray) >= $itemCount){
								$nextIndex = $i + 1;
								break;
							}
						}
						$count = $itemCount - count($dispItemArray);
						for ($i = 0; $i < $count; $i++)
						{
							$dispItemArray[] = $itemArray[$i];
						}
						if ($count > 0) $nextIndex = $count;
						if ($nextIndex >= count($itemArray)) $nextIndex = 0;
						// 読み込みインデックスを保存
						$ret = $this->db->updateBannerItemIndex($param['bd_id'], $nextIndex);
						break;
					case 1:// ランダム
						while (true){
							$index = mt_rand(0, count($itemArray) -1);
							$dispItemArray[] = $itemArray[$index];
							array_splice($itemArray, $index, 1);	// 取得した項目を削除
							if (count($itemArray) == 0 || // 元のデータからすべて取得した
								count($dispItemArray) >= $itemCount) break;		// 取得最大個数に達した
						}
						break;
				}
			}
			// バナー出力
			for ($i = 0; $i < count($dispItemArray); $i++)
			{
				$ret = $this->db->getBannerItemById($dispItemArray[$i], $row);
				if ($ret && $row['bi_visible']){	// 表示可能なときは表示
					// DBにバナー表示のログを残す
					$key = $this->db->viewBannerItemLog($row['bi_serial'], $gAccessManager->getAccessLogSerialNo());
		
					$imageUrl = $row['bi_image_url'];
					$imageWidth = $row['bi_image_width'];
					$imageHeight = $row['bi_image_height'];
					
					// イメージタグ作成
					$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $imageUrl);
					$destImg = '<img src="' . $imgUrl . '" border="0" ';
					if (!empty($imageWidth) && $imageWidth > 0) $destImg .= 'width="' . $imageWidth . '"';
					if (!empty($imageHeight) && $imageHeight > 0) $destImg .= ' height="' . $imageHeight. '"';
					$destImg .= ' />';
					
					// リンク作成
					$urlparam  = M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_DO_WIDGET . '&';
					$urlparam .= M3_REQUEST_PARAM_WIDGET_ID . '=banner&';
					$urlparam .= 'stamp=' . $key . '&';
					$urlparam .= 'url=' . urlencode($row['bi_link_url']);		// URLはエンコードする
					$link = '<a style="margin:0;padding:0;" href="' . $gEnvManager->getRootUrl() . '/index.php?' . $urlparam . '">';
					$link .= $destImg;
					$link .= '</a>';
					
					// 表示位置
					switch ($param['bd_disp_align']){
						case 0:		// 指定なし
							$align = '';
							break;
						case 1:		// 左寄せ
							$align = 'align="left"';
							break;	
						case 2:		// 中央
							$align = 'align="center"';
							break;	
						case 3:		// 右寄せ
							$align = 'align="right"';
							break;
					}
					$lineOutput = array(
						'align' => $align,
						'content' => $link
					);
					$this->tmpl->addVars('contentlist', $lineOutput);
					$this->tmpl->parseTemplate('contentlist', 'a');
				}
			}
		}
	}
}
?>
