<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_imageWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $langId;
	private $configId;		// 定義ID
	private $paramObj;		// パラメータ保存用オブジェクト
	const DEFAULT_NAME_HEAD = '名称未設定';			// デフォルトの設定名
	const IMAGE_DIR = 'default_image';				// 画像ディレクトリ名
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;

		// ユーザ情報、表示言語
		$this->langId	= $gEnvManager->getDefaultLanguage();
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		// ページ定義IDとページ定義のレコードシリアル番号
		$defConfigId = $this->getPageDefConfigId($request);				// 定義ID取得
		$defSerial = $this->getPageDefSerial($request);		// ページ定義のレコードシリアル番号
		$value = $request->trimValueOf('defconfig');		// ページ定義の定義ID
		if (!empty($value)) $defConfigId = $value;
		$value = $request->trimValueOf('defserial');		// ページ定義のレコードシリアル番号
		if (!empty($value)) $defSerial = $value;

		// 入力値を取得
		$name	= $request->trimValueOf('item_name');			// 定義名
		$imageUrl 	= $request->trimValueOf('item_image_url');							// 画像へのパス
		$linkUrl	= $request->trimValueOf('item_link_url');			// リンク先
		$align		= $request->trimValueOf('item_align');			// 表示位置
		$bgcolor = $request->trimValueOf('item_bgcolor');		// 画像バックグランドカラー
		$width	= $request->trimValueOf('item_width');		// 画像の幅
		$height	= $request->trimValueOf('item_height');		// 画像の高さ
		$margin = $request->trimValueOf('item_margin');		// 画像マージン
		$widthType	= $request->trimValueOf('item_widthtype');		// 画像の幅単位
		$heightType	= $request->trimValueOf('item_heighttype');		// 画像の高さ単位
		$posx	= $request->trimValueOf('item_posx');		// x座標
		$posy	= $request->trimValueOf('item_posy');		// y座標
		$posxType	= $request->trimValueOf('item_posxtype');		// x座標単位
		$posyType	= $request->trimValueOf('item_posytype');		// y座標単位
		$posType	= $request->trimValueOf('item_postype');		// 座標指定方法
		$imageType	= $request->trimValueOf('item_sel_image');		// 画像のタイプ
		$usePos	= ($request->trimValueOf('item_use_pos') == 'on') ? 1 : 0;			// 座標指定を可能とするかどうか
		$useLink	= ($request->trimValueOf('item_use_link') == 'on') ? 1 : 0;			// 画像にリンクを付けるかどうか
		$this->configId = $request->trimValueOf('item_id');		// 定義ID
		if (empty($this->configId)) $this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
		
		// 画像の種類を取得
		$imageUrl = '';
		if ($imageType == 'menu'){		// メニューから画像を選択の場合
			$filename = $request->trimValueOf('item_image');		// 画像ファイル名
			$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . $filename;
		} else if ($imageType == 'url'){
			$imageUrl = $request->trimValueOf('item_image_url');
			if (!empty($imageUrl)){
				if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
					$imageUrl = $gEnvManager->getRootUrl() . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl);
				}
			}
		}
			
		// 保存値を取得
		$this->paramObj = $this->getWidgetParamObj();
		
		$replaceNew = false;		// データを再取得するかどうか
		if (empty($act)){// 初期起動時
			// デフォルト値設定
			$this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
			$replaceNew = true;			// データ再取得
		} else if ($act == 'add'){		// 新規追加の場合
			// 入力値のエラーチェック
			$this->checkInput($name, '名前');
			$this->checkInput($imageType, '画像の種別');
			$this->checkNumeric($width, '画像の幅', true);
			$this->checkNumeric($height, '画像の高さ', true);
//			$this->checkNumeric($posx, '画像のx座標', true);
//			$this->checkNumeric($posy, '画像のy座標', true);
			$this->checkNumeric($margin, '画像マージン', true);
			
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				if ($name == $targetObj->name){		// 定義名
					$this->setUserErrorMsg('名前が重複しています');
					break;
				}
			}
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 最大の定義ID取得
				$newConfigId = 1;
				if (count($this->paramObj) > 0){
					$targetObj = $this->paramObj[count($this->paramObj) -1];
					$newConfigId = $targetObj->id + 1;
				}
				// 追加オブジェクト作成
				$newObj = new stdClass;
				$newObj->id		= $newConfigId;// 定義ID
				$newObj->name	= $name;// 定義名
				$newObj->imageUrl 	= $imageUrl;							// 画像へのパス
				$newObj->linkUrl	= $linkUrl;			// リンク先
				$newObj->align		= $align;			// 表示位置
				$newObj->bgcolor 	= $bgcolor;		// 画像バックグランドカラー
				$newObj->width		= $width;		// 画像の幅
				$newObj->height		= $height;		// 画像の高さ
				$newObj->margin		= $margin;		// 画像マージン
				$newObj->widthType	= $widthType;		// 画像の幅単位
				$newObj->heightType	= $heightType;		// 画像の高さ単位
				$newObj->posx		= $posx;		// x座標
				$newObj->posy		= $posy;		// y座標
				$newObj->posxType	= $posxType;		// x座標単位
				$newObj->posyType	= $posyType;		// y座標単位
				$newObj->posType	= $posType;		// 座標指定方法(相対座標)
				$newObj->imageType	= $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
				$newObj->usePos		= $usePos;			// 座標指定を可能とするかどうか
				$newObj->useLink	= $useLink;			// 画像にリンクを付けるかどうか
				$this->paramObj[] = $newObj;
				
				// ウィジェットパラメータオブジェクト更新
				$ret = $this->updateWidgetParamObj($this->paramObj);
				
				// 画面定義更新
				if ($ret) $ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $newConfigId, $name);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					$defConfigId = $newConfigId;		// 定義定義IDを更新
					$this->configId = $newConfigId;		// 定義定義IDを更新
					$replaceNew = true;			// データ再取得
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
				$gPageManager->updateParentWindow();// 親ウィンドウを更新
			}
		} else if ($act == 'update'){		// 設定更新のとき

			// 入力値のエラーチェック
			$this->checkInput($imageType, '画像の種別');
			$this->checkNumeric($width, '画像の幅', true);
			$this->checkNumeric($height, '画像の高さ', true);
//				$this->checkNumeric($posx, '画像のx座標', true);
//				$this->checkNumeric($posy, '画像のy座標', true);
			$this->checkNumeric($margin, '画像マージン', true);
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 該当項目を更新
				for ($i = 0; $i < count($this->paramObj); $i++){
					$targetObj = $this->paramObj[$i];
					$id = $targetObj->id;// 定義ID
					$name = $targetObj->name;// 定義名
					if ($id == $this->configId){
						// ウィジェットオブジェクト更新
						$targetObj->imageUrl = $imageUrl;							// 画像へのパス
						$targetObj->linkUrl = $linkUrl;			// リンク先
						$targetObj->align	= $align;			// 表示位置
						$targetObj->bgcolor = $bgcolor;		// 画像バックグランドカラー
						$targetObj->width = $width;		// 画像の幅
						$targetObj->height = $height;		// 画像の高さ
						$targetObj->margin	= $margin;		// 画像マージン
						$targetObj->widthType = $widthType;		// 画像の幅単位
						$targetObj->heightType = $heightType;		// 画像の高さ単位
						$targetObj->posx = $posx;		// x座標
						$targetObj->posy = $posy;		// y座標
						$targetObj->posxType = $posxType;		// x座標単位
						$targetObj->posyType = $posyType;		// y座標単位
						$targetObj->posType = $posType;		// 座標指定方法(相対座標)
						$targetObj->imageType = $imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
						$targetObj->usePos = $usePos;			// 座標指定を可能とするかどうか
						$targetObj->useLink = $useLink;			// 画像にリンクを付けるかどうか
						break;
					}
				}

				$ret = $this->updateWidgetParamObj($this->paramObj);
			
				if (empty($defConfigId)){		// 画面定義の定義IDが設定されていないときは設定
					// 画面定義更新
					if ($ret) $ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $this->configId, $name);
				}
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				
					if (empty($defConfigId)){		// 画面定義の定義IDが設定されていないときは設定
						$defConfigId = $this->configId;		// 定義定義IDを更新
						$gPageManager->updateParentWindow();// 親ウィンドウを更新
					}
					$replaceNew = true;			// データ再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'select'){		// 定義項目を選択
			$replaceNew = true;			// データ再取得
		}
		// 表示用データを取得
		if (empty($this->configId)){		// 新規登録の場合
			$this->tmpl->setAttribute('item_name_visible', 'visibility', 'visible');// 名前入力フィールド表示
			$name		= $this->createDefaultName();			// デフォルト登録項目名
			$imageUrl 	= '';							// 画像へのパス
			$linkUrl	= '';			// リンク先
			$align		= '';			// 表示位置
			$bgcolor 	= '';		// 画像バックグランドカラー
			$width		= 0;		// 画像の幅
			$height		= 0;		// 画像の高さ
			$margin		= 0;		// 画像マージン
			$widthType	= 0;		// 画像の幅単位
			$heightType	= 0;		// 画像の高さ単位
			$posx		= 0;		// x座標
			$posy		= 0;		// y座標
			$posxType	= 0;		// x座標単位
			$posyType	= 0;		// y座標単位
			$posType	= 'relative';		// 座標指定方法(相対座標)
			$imageType	= '';		// 画像のタイプ(0=メニューから選択、1=直接指定)
			$usePos		= 0;			// 座標指定を可能とするかどうか
			$useLink	= 0;			// 画像にリンクを付けるかどうか
			$this->serialNo = 0;
		} else {
			// 定義からウィジェットパラメータを検索して、定義データを取得
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				$id = $targetObj->id;// 定義ID
				if ($id == $this->configId) break;
			}
			if ($i < count($this->paramObj)){		// 該当項目があるとき
				// ウィジェットオブジェクトから値を取得
				if ($replaceNew){		// データ再取得のとき
					$name		= $targetObj->name;// 名前
					$imageUrl	= $targetObj->imageUrl;							// 画像へのパス
					$linkUrl	= $targetObj->linkUrl;			// リンク先
					$align		= $targetObj->align;			// 表示位置
					$bgcolor	= $targetObj->bgcolor;		// 画像バックグランドカラー
					$width		= $targetObj->width;		// 画像の幅
					$height		= $targetObj->height;		// 画像の高さ
					$margin		= $targetObj->margin;		// 画像マージン
					$widthType	= $targetObj->widthType;		// 画像の幅単位
					$heightType	= $targetObj->heightType;		// 画像の高さ単位
					$posx		= $targetObj->posx;		// x座標
					$posy		= $targetObj->posy;		// y座標
					$posxType	= $targetObj->posxType;		// x座標単位
					$posyType	= $targetObj->posyType;		// y座標単位
					$posType	= $targetObj->posType;		// 座標指定方法(相対座標)
					$imageType	= $targetObj->imageType;		// 画像のタイプ(0=メニューから選択、1=直接指定)
					$usePos		= $targetObj->usePos;			// 座標指定を可能とするかどうか
					$useLink	= $targetObj->useLink;			// 画像にリンクを付けるかどうか
				}
				$this->serialNo = $this->configId;
				
				// 新規作成でないときは、メニューを変更不可にする
				if (!empty($defConfigId)) $this->tmpl->addVar("_widget", "id_disabled", 'disabled');
			}
		}
		// 設定項目選択メニュー作成
		$this->createItemList();
		
		// 画像選択メニューを作成
		$selectFile = '';
		if ($imageType == 'menu') $selectFile = basename($imageUrl);
		$imgPath = $gEnvManager->getCurrentWidgetRootPath() . '/' . self::IMAGE_DIR;
		$this->createImageSelectMenu($imgPath, $selectFile, 'image_file_list');

		// 画面にデータを埋め込む
		$this->tmpl->addVar("item_name_visible", "name",	$name);
		$this->tmpl->addVar("_widget", "link_url",	$linkUrl);// リンク先
		$this->tmpl->addVar("_widget", "bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "margin",	$margin);
		$this->tmpl->addVar("_widget", "posx",	$posx);// x座標
		$this->tmpl->addVar("_widget", "posy",	$posy);// y座標
		
		// 高さ、幅の単位
		if (empty($widthType)){		// ヘッダの幅単位
			$this->tmpl->addVar("_widget", "width0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "width1_selected",	'selected');
		}
		if (empty($heightType)){		// ヘッダの高さ単位
			$this->tmpl->addVar("_widget", "height0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "height1_selected",	'selected');
		}
		if (empty($posxType)){		// x座標単位
			$this->tmpl->addVar("_widget", "posx0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "posx1_selected",	'selected');
		}
		if (empty($posyType)){		// y座標単位
			$this->tmpl->addVar("_widget", "posy0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "posy1_selected",	'selected');
		}
		if ($posType == 'relative'){		// 座標の指定方法
			$this->tmpl->addVar("_widget", "postype0_selected",	'selected');
		} else if ($posType == 'absolute'){
			$this->tmpl->addVar("_widget", "postype1_selected",	'selected');
		}
		if ($align == ''){		// 表示位置
			$this->tmpl->addVar("_widget", "align0_selected",	'selected');
		} else if ($align == 'left'){
			$this->tmpl->addVar("_widget", "align1_selected",	'selected');
		} else if ($align == 'center'){
			$this->tmpl->addVar("_widget", "align2_selected",	'selected');
		} else if ($align == 'right'){
			$this->tmpl->addVar("_widget", "align3_selected",	'selected');
		}
												
		// ヘッダ画像の種類の選択状況
		if ($imageType == 'menu'){		// メニューから選択
			$this->tmpl->addVar("_widget", "menu_img_checked",	'checked');
			$filename = basename($imageUrl);
		} else if ($imageType == 'url'){		// オリジナル画像
			$this->tmpl->addVar("_widget", "original_img_checked",	'checked');
			$this->tmpl->addVar("_widget", "image_url",	$imageUrl);
		}
		if ($usePos) $this->tmpl->addVar('_widget', 'USE_POS',	'checked');	// 座標指定を可能とするかどうか
		if ($useLink) $this->tmpl->addVar('_widget', 'USE_LINK',	'checked');			// 画像にリンクを付けるかどうか
		
		// 画像が設定されている場合はプレビュー画像を表示
		if (empty($imageUrl)){
			$imageAttr = 'style="display:none;"';
		} else {
			$imageAttr = 'src="' . $imageUrl . '"';
		}
		$this->tmpl->addVar("_widget", "image", $imageAttr);
		
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "image_dir", $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR);	// デフォルト画像ディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "def_serial", $this->serialNo);	// ページ定義のレコードシリアル番号
		
		// 画面定義用の情報を戻す
		$this->tmpl->addVar("_widget", "def_serial", $defSerial);	// ページ定義のレコードシリアル番号
		$this->tmpl->addVar("_widget", "def_config", $defConfigId);	// ページ定義の定義ID
		
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 「更新」ボタン
			//$this->tmpl->setAttribute('del_button', 'visibility', 'visible');// 「削除」ボタン
		}
	}
	/**
	 * 設定項目選択用リスト
	 *
	 * @return なし						
	 */
	function createItemList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$targetObj = $this->paramObj[$i];
			$id = $targetObj->id;// 定義ID
			$name = $targetObj->name;// 定義名
			$selected = '';
			if ($this->configId == $id) $selected = 'selected';
			$row = array(
				'name' => $name,		// 名前
				'value' => $id,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('title_list', $row);
			$this->tmpl->parseTemplate('title_list', 'a');
		}
	}
	/**
	 * メニュー画像メニューを作成
	 *
	 * @param string	$path			読み込みパス
	 * @param string	$selectedFile	選択中のファイル
	 * @param string  	$destTagName	書き込み先タグ名
	 * @return なし
	 */
	function createImageSelectMenu($path, $selectedFile, $destTagName)
	{
		// 画像ディレクトリチェック
		if (is_dir($path)){
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){		// 「_」で始まる名前のファイルは読み込まない
					
					$selected = '';
					if ($file == $selectedFile){
						$selected = 'selected';
					}
					$row = array(
						'value'    => $file,			// ファイル名
						'name'     => $file,			// ファイル名
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars($destTagName, $row);
					$this->tmpl->parseTemplate($destTagName, 'a');
				}
			}
			$dir->close();
		}
	}
	/**
	 * デフォルトの名前を取得
	 *
	 * @return string	デフォルト名						
	 */
	function createDefaultName()
	{
		$name = self::DEFAULT_NAME_HEAD;
		for ($j = 1; $j < 100; $j++){
			$name = self::DEFAULT_NAME_HEAD . $j;
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				if ($name == $targetObj->name){		// 定義名
					break;
				}
			}
			// 重複なしのときは終了
			if ($i == count($this->paramObj)) break;
		}
		return $name;
	}
}
?>
