<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_youtubeWidgetContainer extends BaseWidgetContainer
{
	private $sysDb;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $langId;
	private $configId;		// 定義ID
	private $paramObj;		// パラメータ保存用オブジェクト
	const DEFAULT_NAME_HEAD = '名称未設定';			// デフォルトの設定名
	const DEFAULT_WIDTH = 130;		// デフォルトの幅
	const DEFAULT_HEIGHT = 130;		// デフォルトの高さ
	const DEFAULT_MOVIE_ID = 'J_W0_VrUSBU';		// デフォルトの動画
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$userId		= $gEnvManager->getCurrentUserId();
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		// ページ定義IDとページ定義のレコードシリアル番号
		$defConfigId = $this->getPageDefConfigId($request);				// 定義ID取得
		$defSerial = $this->getPageDefSerial($request);		// ページ定義のレコードシリアル番号
		$value = $request->trimValueOf('defconfig');		// ページ定義の定義ID
		if (!empty($value)) $defConfigId = $value;
		$value = $request->trimValueOf('defserial');		// ページ定義のレコードシリアル番号
		if (!empty($value)) $defSerial = $value;

		$name	= $request->trimValueOf('item_name');			// ヘッダタイトル
		$width	= $request->trimValueOf('item_width');		// ヘッダの幅
		$height	= $request->trimValueOf('item_height');		// ヘッダの高さ
		$movieId = $request->trimValueOf('item_movie_id');		// YouTubeの動画ID
		$showTitle = ($request->trimValueOf('item_showtitle') == 'on') ? 1 : 0;		// タイトルを表示するかどうか			
		$this->configId = $request->trimValueOf('item_id');		// 定義ID
		if (empty($this->configId)) $this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
				
		// パラメータオブジェクトを取得
		$this->paramObj = $this->getWidgetParamObj();
		
		$replaceNew = false;		// データを再取得するかどうか
		if (empty($act)){// 初期起動時
			// デフォルト値設定
			$this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
			$replaceNew = true;			// データ再取得
		} else if ($act == 'add'){// 新規追加
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkInput($movieId, '動画ID');
			$this->checkNumeric($width, '幅');
			$this->checkNumeric($height, '高さ');
			
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				if ($name == $targetObj->name){		// 定義名
					$this->setUserErrorMsg('名前が重複しています');
					break;
				}
			}
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// 最大の定義ID取得
				$newConfigId = 1;
				if (count($this->paramObj) > 0){
					$targetObj = $this->paramObj[count($this->paramObj) -1];
					$newConfigId = $targetObj->id + 1;
				}
				// 追加オブジェクト作成
				$newObj = new stdClass;
				$newObj->id		= $newConfigId;// 定義ID
				$newObj->name	= $name;// 表示名
				$newObj->width	= $width;		// 幅
				$newObj->height	= $height;		// 高さ
				$newObj->movieId = $movieId;		// YouTubeの動画ID
				$newObj->showTitle = $showTitle;					// タイトルを表示するかどうか
				$this->paramObj[] = $newObj;
			
				// ウィジェットパラメータオブジェクト更新
				$ret = $this->updateWidgetParamObj($this->paramObj);
				
				// 画面定義更新
				if ($ret) $ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $newConfigId, $name);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					$defConfigId = $newConfigId;		// 定義定義IDを更新
					$this->configId = $newConfigId;		// 定義定義IDを更新
					$replaceNew = true;			// データ再取得
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
				$gPageManager->updateParentWindow();// 親ウィンドウを更新
			}
		} else if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkInput($movieId, '動画ID');
			$this->checkNumeric($width, '幅');
			$this->checkNumeric($height, '高さ');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 該当項目を更新
				for ($i = 0; $i < count($this->paramObj); $i++){
					$targetObj = $this->paramObj[$i];
					$id = $targetObj->id;// 定義ID
					$name = $targetObj->name;// 定義名
					if ($id == $this->configId){
						// ウィジェットオブジェクト更新
						$targetObj->width	= $width;		// ヘッダの幅
						$targetObj->height	= $height;		// ヘッダの高さ
						$targetObj->movieId	= $movieId;		// YouTubeの動画ID
						$targetObj->showTitle = $showTitle;					// タイトルを表示するかどうか
						break;
					}
				}

				$ret = $this->updateWidgetParamObj($this->paramObj);
				
				if (empty($defConfigId)){		// 画面定義の定義IDが設定されていないときは設定
					// 画面定義更新
					if ($ret) $ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $this->configId, $name);
				}
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					
					if (empty($defConfigId)){		// 画面定義の定義IDが設定されていないときは設定
						$defConfigId = $this->configId;		// 定義定義IDを更新
						$gPageManager->updateParentWindow();// 親ウィンドウを更新
					}
					$replaceNew = true;			// データ再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else if ($act == 'select'){	// 定義IDを変更
			$replaceNew = true;			// データ再取得
		}
		
		// 設定項目選択メニュー作成
		$this->createItemList();
		
		// 表示用データを取得
		if (empty($this->configId)){		// 新規登録の場合
			$this->tmpl->setAttribute('item_name_visible', 'visibility', 'visible');// 名前入力フィールド表示
			$name = $this->createDefaultName();			// デフォルト登録項目名
			$width	= self::DEFAULT_WIDTH;		// 幅
			$height	= self::DEFAULT_HEIGHT;		// 高さ
			$movieId = self::DEFAULT_MOVIE_ID;		// YouTubeの動画ID
			$showTitle = 1;					// タイトルを表示するかどうか
			$this->serialNo = 0;
		} else {
			// 定義からウィジェットパラメータを検索して、定義データを取得
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				$id = $targetObj->id;// 定義ID
				if ($id == $this->configId) break;
			}
			if ($i < count($this->paramObj)){		// 該当項目があるとき
				// ウィジェットオブジェクトから値を取得
				if ($replaceNew){		// データ再取得のとき
					$name = $targetObj->name;// 名前
					$width	= $targetObj->width;		// 幅
					$height	= $targetObj->height;		// 高さ
					$movieId = $targetObj->movieId;		// YouTubeの動画ID				
					$showTitle = $targetObj->showTitle;					// タイトルを表示するかどうか
				}
				$this->serialNo = $this->configId;
				
				// 新規作成でないときは、メニューを変更不可にする
				if (!empty($defConfigId)) $this->tmpl->addVar("_widget", "id_disabled", 'disabled');
			}
		}
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("item_name_visible", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "movie_id",	$movieId);
		$checked = '';
		if ($showTitle) $checked = 'checked';
		$this->tmpl->addVar("_widget", "show_title", $checked);	// タイトルを表示するかどうか
				
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);// 選択中のシリアル番号、IDを設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		
		// 画面定義用の情報を戻す
		$this->tmpl->addVar("_widget", "def_serial", $defSerial);	// ページ定義のレコードシリアル番号
		$this->tmpl->addVar("_widget", "def_config", $defConfigId);	// ページ定義の定義ID
		
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 「更新」ボタン
			//$this->tmpl->setAttribute('del_button', 'visibility', 'visible');// 「削除」ボタン
		}
	}
	/**
	 * 設定項目選択用リスト
	 *
	 * @return なし						
	 */
	function createItemList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$targetObj = $this->paramObj[$i];
			$id = $targetObj->id;// 定義ID
			$name = $targetObj->name;// 定義名
			$selected = '';
			if ($this->configId == $id) $selected = 'selected';
			$row = array(
				'name' => $name,		// 名前
				'value' => $id,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('title_list', $row);
			$this->tmpl->parseTemplate('title_list', 'a');
		}
	}
	/**
	 * デフォルトの名前を取得
	 *
	 * @return string	デフォルト名						
	 */
	function createDefaultName()
	{
		$name = self::DEFAULT_NAME_HEAD;
		for ($j = 1; $j < 100; $j++){
			$name = self::DEFAULT_NAME_HEAD . $j;
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i];
				if ($name == $targetObj->name){		// 定義名
					break;
				}
			}
			// 重複なしのときは終了
			if ($i == count($this->paramObj)) break;
		}
		return $name;
	}
}
?>
