<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class youtubeWidgetContainer extends BaseWidgetContainer
{
	private $langId;		// 現在の言語
	const DEFAULT_CONFIG_ID = 0;
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;

		$this->langId = $gEnvManager->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $gEnvManager->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$paramObj = $this->getWidgetParamObj();
		
		// 指定定義IDのデータを取得
		$name = '';
		for ($i = 0; $i < count($paramObj); $i++){
			$targetObj = $paramObj[$i];
			$id = $targetObj->id;// 定義ID
			if ($id == $configId){
				$name = $targetObj->name;// 定義名
				$width	= $targetObj->width;		// 幅
				$height	= $targetObj->height;		// 高さ
				$movieId = $targetObj->movieId;		// YouTubeの動画ID
				$showTitle = $targetObj->showTitle;// タイトルを表示するかどうか
				break;
			}
		}
		// 	テーブルのパラメータ
		$this->tmpl->addVar("_widget", "title_param", $gDesignManager->getDefaultWidgetTableParam());
		
		// タイトルの設定
		if ($showTitle){		// タイトル表示のとき
			$titleString = '<tr><th>' . $name . '</th><tr>';
			$this->tmpl->addVar("_widget", "title", $titleString);
		}
		// 表示データ埋め込み
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "movie_id",	$movieId);
	}
}
?>
