<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class admin_ec_mainProductlistWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $ecObj;			// 共通ECオブジェクト
	private $search_categoryId;		// 選択中のカテゴリーID
	const STANDARD_PRICE = 'selling';		// 通常価格
	const DEFAULT_TAX_TYPE = 'sales';			// デフォルト税種別
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_LIST_COUNT = 20;			// 最大リスト表示数
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new productDb();
		
		// EC用共通オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
		$this->ecObj->initByDefault();		// デフォルト値で初期化
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		global $gEnvManager;
		
		if ($gEnvManager->getMultiLanguage()){	// 多言語対応のとき
			return 'admin_product_list.tmpl.html';
		} else {
			return 'admin_product_list_simple.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userId		= $gEnvManager->getCurrentUserId();
		$defaultLangId	= $gEnvManager->getDefaultLanguage();
		
		// ##### 検索条件 #####
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		// DBの保存設定値を取得
		$maxListCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$this->search_categoryId = $request->trimValueOf('category');		// 検索カテゴリー
		$keyword = $request->trimValueOf('keyword');			// 検索キーワード
		
		$act = $request->trimValueOf('act');
		if ($act == 'search'){		// 検索のとき
			$pageNo = 1;		// ページ番号初期化
		}
		
		// カテゴリー一覧を作成
		$this->db->getAllCategoryByLoop($defaultLangId, array($this, 'categoryLoop'));
						
		// ###### 検索条件を作成 ######
		// 総数を取得
		$totalCount = $this->db->searchProductCount($keyword, $this->search_categoryId, $defaultLangId);
		$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数

		// 表示するページ番号の修正
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;

		// 商品リストを表示
		$this->db->searchProduct($keyword, $this->search_categoryId, $defaultLangId, $maxListCount, ($pageNo -1) * $maxListCount, array($this, 'productListLoop'));

		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			for ($i = 1; $i <= $pageCount; $i++){
				$linkUrl = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=productlist&keyword=' . $keyword . '&category=' . $this->search_categoryId . '&page=' . $i;
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$link = '&nbsp;<a href="' . $linkUrl . '" >' . $i . '</a>';
				}
				$pageLink .= $link;
			}
		}
		// 検出順を作成
		$startNo = ($pageNo -1) * $maxListCount +1;
		$endNo = $pageNo * $maxListCount > $totalCount ? $totalCount : $pageNo * $maxListCount;
		$this->tmpl->addVar("show_productlist", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "total_count", $totalCount);
		$this->tmpl->addVar("search_range", "start_no", $startNo);
		$this->tmpl->addVar("search_range", "end_no", $endNo);
		if ($totalCount > 0) $this->tmpl->setAttribute('search_range', 'visibility', 'visible');// 検出範囲を表示
		
		// パラメータ再設定
		$this->tmpl->addVar("_widget", "search_word", $keyword);
			
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "admin_url", $gEnvManager->getDefaultAdminUrl());
		$this->tmpl->addVar('_widget', 'widget_id', $gEnvManager->getCurrentWidgetId());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 対応言語を取得
		$lang = '';
		$ret = $this->db->getLangByProductId($fetchedRow['pt_id'], $rows);
		if ($ret){
			$count = count($rows);
			for ($i = 0; $i < $count; $i++){
				if ($gEnvManager->getCurrentLanguage() == 'ja'){	// 日本語の場合
					$lang .= $rows[$i]['ln_name'];
					if ($i != $count -1) $lang .= ',';
				} else {
					$lang .= $rows[$i]['ln_name_en'];
					if ($i != $count -1) $lang .= ',';
				}
			}
		}
		
		// データ再取得
		$ret = $this->db->getProductBySerial($fetchedRow['pt_serial'], $row, $row2, $row3, $row4, $row5);
		if ($ret){
			$langId = $row['pt_language_id'];
			
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別			

			// 価格作成
			$this->ecObj->setCurrencyType($currency, $langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $langId);		// 税種別設定
			$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
			if (empty($taxType)) $dispPrice = '(未)';		// 税種別未選択のとき
			
			$visible = '';
			if ($row['pt_visible']){	// 項目の表示
				$visible = 'checked';
			}
		}
		
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['pt_serial']),	// シリアル番号
			'id' => $row['pt_id'],			// ID
			'name' => $this->convertToDispString($row['pt_name']),		// 名前
			'code' => $this->convertToDispString($row['pt_code']),		// 商品コード
			'price' => $dispPrice,													// 価格(税込)
			'stock_count' => $this->convertToDispString($row['pt_view_stock_count']),		// 表示在庫数
			'view_index' => $this->convertToDispString($row['pt_sort_order']),		// 表示順
			'lang' => $lang,													// 対応言語
			'update_user' => $this->convertToDispString($row['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($row['pt_create_dt']),	// 更新日時
			'visible' => $visible											// メニュー項目表示制御
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->dispContIdArray[] = $fetchedRow['pt_id'];
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 取得したカテゴリーをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function categoryLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['pc_id'] == $this->search_categoryId){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['pc_name']);

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pc_id']),			// カテゴリーID
			'name'     => $name,			// カテゴリー名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('category_list', $row);
		$this->tmpl->parseTemplate('category_list', 'a');
		return true;
	}
}
?>
