<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
 
class qrcodeWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gMailManager;
		global $gErrorManager;
		global $gDesignManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		
		// 設定値の取得
		$useFixedData = 0;			// 固定データを使用
		$qrData = '';				// QRコード化するデータ
		$title = 'QRコード';			// 表示タイトル
		$desc = '';				// 説明
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$useFixedData = $paramObj->useFixedData;			// 固定データを使用
			$qrData = $paramObj->qrData;						// QRコード化するデータ
			$title = $paramObj->title;			// 表示タイトル
			$desc = $paramObj->desc;				// 説明
		}
		
		$act = $request->trimValueOf('act');
		if ($act == 'genarate'){			// QRコード生成のとき
			ob_end_clean();
			
			require_once($gEnvManager->getLibPath() .	'/qr_img0.50g/php/qr_img.php');
			define ("QRCODE_DATA_PATH", $gEnvManager->getCurrentWidgetRootPath() . '/images');		// 画像作成パスの設定

			Header("Content-type: image/png");
			$qrData = "matukazu";
			$qrcode_image = new Qrcode_image;
			$qrcode_image->qrcode_image_out($qrData, "png");
			
			ob_end_flush();
		} else {
			// QRコード生成パスを設定
			$urlparam  = M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_DO_WIDGET . '&';
			$urlparam .= M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() .'&';
			
			if ($useFixedData){		// 固定データを使用のとき
				$urlparam .= 'act=genarate&d=' . urlencode($qrData) . '&t=P&s=3';
			} else {			// ユーザ設定データなしのときは、携帯サイトURLを設定
				$urlparam .= 'act=genarate&d=' . urlencode($gEnvManager->getDefaultMobileUrl()) . '&t=P&s=3';
			}
			$link .= $destImg;
			$link .= '</a>';
			$this->tmpl->addVar("_widget", "qr_path", $gEnvManager->getDefaultUrl() . '?' . $urlparam);
			$this->tmpl->addVar("_widget", "title", $title);			// 表示タイトル
			$this->tmpl->addVar("_widget", "desc", $desc);				// 説明
		
			// タイトル部のパラメータ
			$this->tmpl->addVar("_widget", "default_menu_param", $gDesignManager->getDefaultWidgetTableParam());
		}
	}
}
?>
