<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_mainDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class blog_mainWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	private $currentPageUrl;			// 現在のページURL
	private $isExistsViewData;				// 表示データがあるかどうか
	const CONTENT_TYPE = 'bg';
	const DEFAULT_LIST_COUNT = 5;			// 最大リスト表示数
	const DEFAULT_SEARCH_LIST_COUNT = 5;			// 最大リスト表示数
	const THIS_WIDGET_ID = 'blog_main';			// ウィジェットID
	const VIEW_STR_LENGTH = 200;			// 検索結果表示文字数
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new blog_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'search'){
			return 'search.tmpl.html';
		} else {
			return 'main.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// 現在日時を取得
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		
		// 現在のページURL
		$this->currentPageUrl = $gEnvManager->createCurrentPageUrl();
		
		$entryId = $request->trimValueOf('entryid');
		$startDt = $request->trimValueOf('start');
		$endDt = $request->trimValueOf('end');
		$year = $request->trimValueOf('year');		// 年指定
		$month = $request->trimValueOf('month');		// 月指定
		$day = $request->trimValueOf('day');		// 日指定
		
		// DBの保存設定値を取得
		$itemCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$serializedParam = $this->sysDb->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$itemCount = $dispInfo->viewCount;		// 一覧表示数
		}
		
		$act = $request->trimValueOf('act');
		$keyword = $request->trimValueOf('keyword');
		if ($act == 'search'){			// 検索
			$itemCount = self::DEFAULT_SEARCH_LIST_COUNT;		// 取得数
			
			// キーワード検索のとき
			if (empty($keyword)){
				$keyword = '検索キーワードが入力されていません';
			} else {
				$this->db->searchEntryItemsByKeyword($itemCount, 1, $keyword, $gEnvManager->getCurrentLanguage(), array($this, 'searchItemsLoop'));
			}
		} else if ($act == 'view'){			// 記事を表示のとき
			if (!empty($year) && !empty($month)){
				if (empty($day)){		// 月指定のとき
					$startDt = $year . '/' . $month . '/1';
					$endDt = $this->getNextMonth($year . '/' . $month) . '/1';
					$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $itemCount, $gEnvManager->getCurrentLanguage(), array($this, 'itemsLoop'));

					// 年月の表示
					$yearMonth = $year . '年 ' . $month . '月';
					// 投稿データがないときはデータなしメッセージ追加
					if (!$this->isExistsViewData) $yearMonth .= '&nbsp;&nbsp;投稿データなし';
					$this->tmpl->addVar("_widget", "year_month", $yearMonth);
				} else {
					$startDt = $year . '/' . $month . '/' . $day;
					$endDt = $this->getNextDay($year . '/' . $month . '/' . $day);
					$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $itemCount, $gEnvManager->getCurrentLanguage(), array($this, 'itemsLoop'));
				}
			}
		} else {
			$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $itemCount, $gEnvManager->getCurrentLanguage(), array($this, 'itemsLoop'));
		}
		$this->tmpl->addVar("_widget", "keyword", $keyword);
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;
		global $gAnalyzeManager;
			
		// ビューカウントを更新
		$gAnalyzeManager->updateContentViewCount(self::CONTENT_TYPE, $fetchedRow['be_serial'], $this->currentDay, $this->currentHour);

		// タイトルを設定
		$title = $fetchedRow['be_name'];
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		$entryText = $fetchedRow['be_html'];
		$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $entryText);// アプリケーションルートを変換
		$row = array(
			'title' => $title,
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function searchItemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;

		// タイトルを設定
		$title = $fetchedRow['be_name'];
		
		// 記事へのリンクを生成
		$linkUrl = $this->currentPageUrl . '&entryid=' . $fetchedRow['be_id'];
		$link = '<a href="' . $linkUrl . '" >' . $title . '</a>';
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		if (function_exists('mb_substr')){
			$entryText = mb_substr(strip_tags($fetchedRow['be_html']), 0, self::VIEW_STR_LENGTH);
		} else {
			$entryText = substr(strip_tags($fetchedRow['be_html']), 0, self::VIEW_STR_LENGTH);
		}
		$row = array(
			'title' => $link,			// リンク付きタイトル
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
}
?>
