<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainCartDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class ec_mainCartWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $productDb;	// DB接続オブジェクト
	private $langId;		// 現在の言語
	private $ecObj;					// EC共通ライブラリオブジェクト
	private $productExists;			// カートに商品があるかどうか
	private $total;					// 合計価格
	private $request;
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const STANDARD_PRICE = 'selling';		// 通常価格
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
				
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_mainCartDb();
		$this->productDb = new productDb();
		
		// EC用共通オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'cart.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;

		$this->request = $request;
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$userId = $gEnvManager->getCurrentUserId();
		$productId = $request->trimValueOf('productid');	// 商品ID
		$defaultCurrency = $this->ecObj->getDefaultCurrency();		// 通貨
				
		// クッキー読み込み、カートIDを取得
		$cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
		
		$act = $request->trimValueOf('act');
		if ($act == 'delproduct' || $act == 'delproductall'){		// カート項目の削除のとき
			if (!empty($cartId)){	// カートIDが設定されているとき
				// カート情報を取得
				$ret = $this->db->getCartHead($cartId, $this->langId, $row);
				if ($ret){
					$cart_serial = $row['sh_serial'];
					
					if ($act == 'delproduct'){		// 商品削除の場合
						// カート内の商品を取得
						$ret = $this->db->getCartItem($cart_serial, $productId, $cartItemRow);
						if ($ret){
							$cart_item_serial = $cartItemRow['si_serial'];
						
							// 項目を削除
							$this->db->deleteProductInCart($cart_serial, $cart_item_serial);
						}
					} else {	// すべての商品を削除のとき
						// 項目を削除
						$this->db->deleteProductInCart($cart_serial, 0);
					}
				}
			}
		} else if ($act == 'updatecart'){		// カートの更新のとき
			// カート内容を表示
			if (!empty($cartId)){	// カートIDが設定されているとき
				// カートの商品を取得
				$this->db->getCartItemList($cartId, $this->langId, array($this, 'updateCartLoop'));
				
				// カート情報を取得
				$ret = $this->db->getCartHead($cartId, $this->langId, $row);
				if ($ret){
					$cart_serial = $row['sh_serial'];
					
					// カートヘッダの更新日時を更新
					$this->db->updateCartDt($cart_serial);
				}
			}
		}
					
		// カート内容を表示
		if (!empty($cartId)){	// カートIDが設定されているとき
			$this->total = 0;					// 合計価格
			
			// カートの商品を取得
			$this->db->getCartItemList($cartId, $this->langId, array($this, 'cartLoop'));
			
			// 通貨情報を取得
			$ret = $this->db->getCurrency($defaultCurrency, $this->langId, $row);
			if ($ret){
				$prePrice = $this->convertToDispString($row['cu_symbol']);
				$postPrice = $this->convertToDispString($row['cu_post_symbol']);
			}
			// 合計価格
			$this->ecObj->setCurrencyType($defaultCurrency, $this->langId);		// 通貨設定
			$this->ecObj->getPriceWithoutTax($this->total, $dispTotal);
			$this->tmpl->addVar("show_cart", "total", $prePrice . $dispTotal . $postPrice);
		}
		
		// その他のパラメータ
		//$this->tmpl->addVar("_widget", "default_table_param", $gDesignManager->getDefaultWidgetTableParam());// ウィジェットテーブルのパラメータ
		$this->tmpl->addVar("show_cart", "shop_top_url", $gEnvManager->createCurrentPageUrl());		// お買い物トップページ
		$this->tmpl->addVar("show_cart", "login_url", $gEnvManager->createCurrentPageUrl() . '&task=login');		// ログイン用URL
		
		// カート項目がないとき
		if ($this->productExists){
			$this->tmpl->setAttribute('show_cart', 'visibility', 'visible');
		} else {
			$this->tmpl->setAttribute('no_item_message', 'visibility', 'visible');
		}
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$priceStatus = 1;	// 価格が有効であるかどうか
		$id = $fetchedRow['si_product_id'];	// 商品ID
		
		// 商品を取得
		$ret = $this->productDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4, $row5);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 価格が変更のときは、価格を無効にする
		$quantity = $fetchedRow['si_quantity'];
		$subtotal = $fetchedRow['si_subtotal'];
		$oldCurrency = $fetchedRow['si_currency_id'];
		if ($unitPrice * $quantity != $subtotal) $priceStatus = 0;
		if ($oldCurrency != $currency) $priceStatus = 0;
		
		// 通貨情報を取得
		$ret = $this->db->getCurrency($oldCurrency, $this->langId, $row);
		if ($ret){
			$prePrice = $this->convertToDispString($row['cu_symbol']);
			$postPrice = $this->convertToDispString($row['cu_post_symbol']);
		}
		
		// 価格作成
		$this->ecObj->setCurrencyType($oldCurrency, $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($subtotal, $dispPrice);				// 税込み価格取得
					
		// 価格の有効判断
		if (!$fetchedRow['si_available']) $priceStatus = 0;
		
		// 小計価格
		$available = '';
		if ($priceStatus == 0) $available = '(無効)';
		$price = $prePrice . $dispPrice . $available;
		
		$this->total += $subtotal;					// 合計価格
		
		// 商品詳細へのリンク
		$url  = '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_FIND_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId();
		$url .= '&' . M3_REQUEST_PARAM_FROM . '=' . $gEnvManager->getCurrentWidgetId();		// 送信元
		$url .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode('product=' . $fetchedRow['si_product_id']);
			
		$nameLink = '<a href="' . $url . '">' . $name . '</a>';
		$row = array(
			'name' => $nameLink,
			'code' => $code,
			'unit_price' => $dispUnitPrice,			// 税込み単価
			'id' => $id,					// 商品ID
			'price' => $price,
			'quantity' => $quantity,
			'price_status' => $priceStatus		// 商品価格が有効かどうか
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		$this->productExists = true;			// カートに商品があるかどうか
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function updateCartLoop($index, $fetchedRow, $request)
	{
		global $gEnvManager;

		$id = $fetchedRow['si_product_id'];	// 商品ID
		$cartItemSerial = $fetchedRow['si_serial'];		// カート項目シリアル番号
		
		// 入力された数量を取得
		$quantity = $this->request->trimValueOf('quantity_' . $id);	// 数量
		
		$priceStatus = 1;	// 価格が有効であるかどうか
		
		// 商品を取得
		$ret = $this->productDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4, $row5);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 小計を再計算
		$subtotal = $unitPrice * $quantity;
		
		// カートの情報を更新
		$this->db->updateProductInCart($cartItemSerial, $currency, $quantity, $subtotal, $priceStatus);
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
