<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: templateChangerWidgetContainer.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/templateChangerDb.php');
require_once($gEnvManager->getCommonPath() . '/htmlEdit.php');

class templateChangerWidgetContainer extends BaseWidgetContainer
{
	var $selectMenuArray = array();

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gDesignManager;
		
		// DBオブジェクト作成
		$db = new templateChangerDb();
		$db->getTemplates(array($this, 'selectMenuLoop'), $gEnvManager->getCurrentTemplateId());

		// テンプレート選択用メニュー作成
		$html = HtmlEdit::createSelectMenu($this->selectMenuArray, M3_SYSTEM_TAG_CHANGE_TEMPLATE, "class=\"button\" onchange=\"showimage()\" style=\"width:140px;\"");

		$imagePath = $gEnvManager->getCurrentTemplateUrl() . '/template_thumbnail.png';
		$this->tmpl->addVar("_widget", "TMPL_IMAGE", $imagePath);							// プレビュー画像
		$this->tmpl->addVar("_widget", "CUR_TMPL", $gEnvManager->getCurrentTemplateId());
		$this->tmpl->addVar("_widget", "CHANGE_TEMPLATE", M3_REQUEST_CMD_CHANGE_TEMPLATE);	// テンプレート変更処理
		$this->tmpl->addVar("_widget", "SEL_BUTTON_LABEL", '選択');						// 選択ボタンラベル
		$this->tmpl->addVar("_widget", "SEL_LIST", $html);								// テンプレート選択メニュー
		$this->tmpl->addVar("_widget", "SEL_TEMPLATE", M3_SYSTEM_TAG_CHANGE_TEMPLATE);		// テンプレート選択タグ
		$this->tmpl->addVar("_widget", "CUR_URL", 'index.php');		// フォームのURL
		$this->tmpl->addVar("_widget", "SYSTEM_ROOT", $gEnvManager->getRootUrl());		// システムのルートURL
		
		// メニューテーブルのパラメータ
		$this->tmpl->addVar("_widget", "default_menu_param", $gDesignManager->getDefaultWidgetTableParam());
	}
	/**
	 * メニューを作成
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function selectMenuLoop($index, $fetchedRow, $param)
	{
		$menuItems = new SelectMenuItem();
		$menuItems->name = strlen($fetchedRow['tm_name']) ? $fetchedRow['tm_name'] : $fetchedRow['tm_id'];
		$menuItems->value = $fetchedRow['tm_id'];
		if ($menuItems->value == $param) $menuItems->selected = true;
		$this->selectMenuArray[] = $menuItems;
		return true;
	}
}
?>
