<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_custom_headerWidgetContainer.php 264 2008-01-30 03:43:09Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_custom_headerWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const IMAGE_DIR = 'image';				// 画像ディレクトリ名
	const DEFAULT_IMAGE = 'header9.png';		// デフォルトのヘッダ画像
	const DEFAULT_BG_COLOR = '#FFCC00';			// バックグランドデフォルトカラー
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		$filename = $request->trimValueOf('item_image');		// 画像ファイル名
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 設定更新のとき
			// 入力値を取得
			$title	= $request->trimValueOf('item_title');			// ヘッダタイトル
			$title_mtop = $request->trimValueOf('item_title_mtop');			// ヘッダタイトルマージンtop
			$title_mleft = $request->trimValueOf('item_title_mleft');			// ヘッダタイトルマージンleft
			$desc	= $request->trimValueOf('item_desc');	// ヘッダ説明
			$desc_mtop = $request->trimValueOf('item_desc_mtop');			// ヘッダ説明マージンtop
			$desc_mleft = $request->trimValueOf('item_desc_mleft');			// ヘッダ説明マージンleft
			$url	= $request->trimValueOf('item_url');	// ヘッダURL
			$url_mtop = $request->trimValueOf('item_url_mtop');			// ヘッダURLマージンtop
			$url_mright = $request->trimValueOf('item_url_mright');			// ヘッダURLマージンright
			$titleColor = $request->trimValueOf('item_title_color');		// ヘッダタイトルカラー
			$descColor = $request->trimValueOf('item_desc_color');		// ヘッダ説明カラー
			$urlColor = $request->trimValueOf('item_url_color');		// ヘッダURLカラー
			$bgcolor = $request->trimValueOf('item_bgcolor');		// ヘッダバックグランドカラー
			$width	= $request->trimValueOf('item_width');		// ヘッダの幅
			$height	= $request->trimValueOf('item_height');		// ヘッダの高さ
			$widthType	= $request->trimValueOf('item_widthtype');		// ヘッダの幅単位
			$heightType	= $request->trimValueOf('item_heighttype');		// ヘッダの高さ単位
			$titleFontsize	= $request->trimValueOf('item_title_fontsize');// タイトルのフォントサイズ
			$descFontsize	= $request->trimValueOf('item_desc_fontsize');// 説明のフォントサイズ
			$urlFontsize	= $request->trimValueOf('item_url_fontsize');	// URLのフォントサイズ
			
			// 画像の種類を取得
			$useOriginalImage	= $request->trimValueOf('item_sel_image');
			$imageUrl = '';
			if ($useOriginalImage == 1){		// メニューから画像を選択の場合
				$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . $filename;
			} else if ($useOriginalImage == 2){
				$imageUrl = $request->trimValueOf('item_image_url');
				if (!empty($imageUrl)){
					if (strncmp($imageUrl, '/', 1) == 0){		// 相対パス表記のとき
						$imageUrl = $gEnvManager->getRootUrl() . $gEnvManager->getRelativePathToSystemRootUrl($gEnvManager->getDocumentRootUrl() . $imageUrl);
					}
				}
			}
			// 入力値のエラーチェック
			$this->checkNumeric($width, 'ヘッダの幅');
			$this->checkNumeric($height, 'ヘッダの高さ');
			$this->checkNumeric($titleFontsize, 'タイトルのフォントサイズ');
			$this->checkNumeric($descFontsize, '説明のフォントサイズ');
			$this->checkNumeric($urlFontsize, 'URLのフォントサイズ');
			$this->checkNumeric($title_mtop, 'タイトルマージンtop', true);
			$this->checkNumeric($title_mleft, 'タイトルマージンleft', true);
			$this->checkNumeric($desc_mtop, '説明マージンtop', true);
			$this->checkNumeric($desc_mleft, '説明マージンleft', true);
			$this->checkNumeric($url_mtop, 'URLマージンtop', true);
			$this->checkNumeric($url_mright, 'URLマージンright', true);
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj->title	= $title;			// ヘッダタイトル
				$paramObj->desc		= $desc;		// ヘッダ説明
				$paramObj->url		= $url;	// ヘッダURL
				$paramObj->title_mtop = $title_mtop;			// ヘッダタイトルマージンtop
				$paramObj->title_mleft = $title_mleft;			// ヘッダタイトルマージンleft
				$paramObj->desc_mtop = $desc_mtop;			// ヘッダ説明マージンtop
				$paramObj->desc_mleft = $desc_mleft;			// ヘッダ説明マージンleft
				$paramObj->url_mtop = $url_mtop;			// ヘッダURLマージンtop
				$paramObj->url_mright = $url_mright;			// ヘッダURLマージンright
				$paramObj->titleColor = $titleColor;		// ヘッダタイトルカラー
				$paramObj->descColor = $descColor;		// ヘッダ説明カラー
				$paramObj->urlColor = $urlColor;		// ヘッダURLカラー
				$paramObj->bgcolor	= $bgcolor;	// ヘッダバックグランドカラー
				$paramObj->width	= $width;		// ヘッダの幅
				$paramObj->height	= $height;		// ヘッダの高さ
				$paramObj->widthType	= $widthType;		// ヘッダの幅単位
				$paramObj->heightType	= $heightType;		// ヘッダの高さ単位
				$paramObj->titleFontsize	= $titleFontsize;// タイトルのフォントサイズ
				$paramObj->descFontsize	= $descFontsize;// 説明のフォントサイズ
				$paramObj->urlFontsize	= $urlFontsize;	// URLのフォントサイズ
				$paramObj->useOriginalImage = $useOriginalImage;			// オリジナル画像を使用するかどうか
				$paramObj->imageUrl = $imageUrl;							// 画像へのパス
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else {		// 初期表示の場合
			// デフォルト値設定
			$title = 'title';	// ヘッダタイトル
			$desc = 'description';	// ヘッダ説明
			$url = 'http://www.sample.com';	// ヘッダURL
			$title_mtop = 10;			// ヘッダタイトルマージンtop
			$title_mleft = 20;			// ヘッダタイトルマージンleft
			$desc_mtop = 10;			// ヘッダ説明マージンtop
			$desc_mleft = 30;			// ヘッダ説明マージンleft
			$url_mtop = 10;			// ヘッダURLマージンtop
			$url_mright = 20;			// ヘッダURLマージンright
			$titleColor = '#FFFFFF';		// ヘッダタイトルカラー
			$descColor = '#FFFFFF';		// ヘッダ説明カラー
			$urlColor = '#FFFFFF';		// ヘッダURLカラー
			$bgcolor = '';					// ヘッダバックグランドカラー
			$width	= 100;		// ヘッダの幅
			$height	= 100;		// ヘッダの高さ
			$widthType = 0;		// ヘッダの幅単位
			$heightType = 0;		// ヘッダの高さ単位
			$titleFontsize	= 30;// タイトルのフォントサイズ
			$descFontsize	= 14;// 説明のフォントサイズ
			$urlFontsize	= 18;	// URLのフォントサイズ
			$useOriginalImage = 0;			// オリジナル画像を使用するかどうか
			//$imageUrl = '';							// 画像へのパス
			$imageUrl = $gEnvManager->getCurrentWidgetRootUrl() . '/' . self::IMAGE_DIR . '/' . self::DEFAULT_IMAGE;// 画像へのパス
					
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$title	= $paramObj->title;			// ヘッダタイトル
				$desc	= $paramObj->desc;	// ヘッダ説明
				$url	= $paramObj->url;	// ヘッダURL
				$title_mtop = $paramObj->title_mtop;			// ヘッダタイトルマージンtop
				$title_mleft = $paramObj->title_mleft;			// ヘッダタイトルマージンleft
				$desc_mtop = $paramObj->desc_mtop;			// ヘッダ説明マージンtop
				$desc_mleft = $paramObj->desc_mleft;			// ヘッダ説明マージンleft
				$url_mtop = $paramObj->url_mtop;			// ヘッダURLマージンtop
				$url_mright = $paramObj->url_mright;			// ヘッダURLマージンright
				$titleColor = $paramObj->titleColor;		// ヘッダタイトルカラー
				$descColor = $paramObj->descColor;		// ヘッダ説明カラー
				$urlColor = $paramObj->urlColor;		// ヘッダURLカラー
				$bgcolor = $paramObj->bgcolor;		// ヘッダバックグランドカラー
				$width	= $paramObj->width;		// ヘッダの幅
				$height	= $paramObj->height;		// ヘッダの高さ
				$widthType = $paramObj->widthType;		// ヘッダの幅単位
				$heightType = $paramObj->heightType;		// ヘッダの高さ単位
				$titleFontsize	= $paramObj->titleFontsize;// タイトルのフォントサイズ
				$descFontsize	= $paramObj->descFontsize;// 説明のフォントサイズ
				$urlFontsize	= $paramObj->urlFontsize;	// URLのフォントサイズ
				$useOriginalImage = $paramObj->useOriginalImage;			// オリジナル画像を使用するかどうか
				$imageUrl	= $paramObj->imageUrl;							// 画像へのパス
			}
		}
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "desc",	$desc);
		$this->tmpl->addVar("_widget", "url",	$url);
		$this->tmpl->addVar("_widget", "title_mtop",	$title_mtop);
		$this->tmpl->addVar("_widget", "title_mleft",	$title_mleft);
		$this->tmpl->addVar("_widget", "desc_mtop",	$desc_mtop);
		$this->tmpl->addVar("_widget", "desc_mleft",	$desc_mleft);
		$this->tmpl->addVar("_widget", "url_mtop",	$url_mtop);
		$this->tmpl->addVar("_widget", "url_mright",	$url_mright);
		$this->tmpl->addVar("_widget", "title_color", $titleColor);
		$this->tmpl->addVar("_widget", "desc_color", $descColor);
		$this->tmpl->addVar("_widget", "url_color", $urlColor);
		$this->tmpl->addVar("_widget", "bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "width",	$width);
		$this->tmpl->addVar("_widget", "height",	$height);
		$this->tmpl->addVar("_widget", "title_fontsize",	$titleFontsize);
		$this->tmpl->addVar("_widget", "desc_fontsize",	$descFontsize);
		$this->tmpl->addVar("_widget", "url_fontsize",	$urlFontsize);

		// 高さ、幅の単位
		if (empty($widthType)){		// ヘッダの幅単位
			$this->tmpl->addVar("_widget", "width0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "width1_selected",	'selected');
		}
		if (empty($heightType)){		// ヘッダの高さ単位
			$this->tmpl->addVar("_widget", "height0_selected",	'selected');
		} else {
			$this->tmpl->addVar("_widget", "height1_selected",	'selected');
		}
				
		// ヘッダ画像の種類の選択状況
		if ($useOriginalImage == 0){		// 画像を使用しない
			$this->tmpl->addVar("_widget", "no_img_checked",	'checked');
		} else if ($useOriginalImage == 1){		// メニューから選択
			$this->tmpl->addVar("_widget", "menu_img_checked",	'checked');
			$filename = basename($imageUrl);
		} else if ($useOriginalImage == 2){		// オリジナル画像
			$this->tmpl->addVar("_widget", "original_img_checked",	'checked');
			$this->tmpl->addVar("_widget", "image_url",	$imageUrl);
		}

		// メニュー画像メニューを作成
		// 画像ディレクトリチェック
		$searchPath = $gEnvManager->getCurrentWidgetRootPath() . '/' . self::IMAGE_DIR;
		if (is_dir($searchPath)){
			$dir = dir($searchPath);
			while (($file = $dir->read()) !== false){
				$filePath = $searchPath . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){		// 「_」で始まる名前のファイルは読み込まない
					
					$selected = '';
					if ($file == $filename){
						$selected = 'selected';
					}
					$row = array(
						'value'    => $file,			// ファイル名
						'name'     => $file,			// ファイル名
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars('image_file_list', $row);
					$this->tmpl->parseTemplate('image_file_list', 'a');
				}
			}
			$dir->close();
		}
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		
		// プレビューヘッダの作成
		// 高さ、幅の単位
		if (empty($widthType)){		// ヘッダの幅単位
			$width .= '%';
		} else {
			$width .= 'px';
		}
		if (empty($heightType)){		// ヘッダの高さ単位
			$height .= '%';
		} else {
			$height .= 'px';
		}
		if (empty($imageUrl)){		// 画像を設定しないとき
			$width = 'width: ' . $width . ';';
			$height = 'height: ' . $height . ';';			
		} else {
			$image = '<img src="' . $imageUrl . '" width="' . $width . '" height="' . $height . '" style="z-index:0" />';
			$this->tmpl->addVar("_widget", "head_image", $image);		// 画像
			
			// CSSの高さ、幅をクリア
			$width = '';
			$height = '';
		}
		// フォントカラー
		if (!empty($titleColor)) $titleColor = "color: $titleColor;";		// ヘッダタイトルカラー
		if (!empty($descColor)) $descColor = "color: $descColor;";			// ヘッダ説明カラー
		if (!empty($urlColor)) $urlColor = "color: $urlColor;";				// ヘッダURLカラー
				
		// 背景色
		if (!empty($bgcolor)) $bgcolor = "background: $bgcolor;";
		// 表示文字列の位置
		if (!empty($title_mtop)) $title_mtop = 'margin-top: ' . $title_mtop . 'px;';
		if (!empty($title_mleft)) $title_mleft = 'margin-left: ' . $title_mleft . 'px;';
		if (!empty($desc_mtop)) $desc_mtop = 'margin-top: ' . $desc_mtop . 'px;';
		if (!empty($desc_mleft)) $desc_mleft = 'margin-left: ' . $desc_mleft . 'px;';
		if (!empty($url_mtop)) $url_mtop = 'margin-top: ' . $url_mtop . 'px;';
		if (!empty($url_mright)) $url_mright = 'margin-right: ' . $url_mright . 'px;';

		$this->tmpl->addVar("_widget", "head_title",	$title);
		$this->tmpl->addVar("_widget", "head_desc",	$desc);
		$this->tmpl->addVar("_widget", "head_url",	$url);
		$this->tmpl->addVar("_widget", "head_title_mtop",	$title_mtop);
		$this->tmpl->addVar("_widget", "head_title_mleft",	$title_mleft);
		$this->tmpl->addVar("_widget", "head_desc_mtop",	$desc_mtop);
		$this->tmpl->addVar("_widget", "head_desc_mleft",	$desc_mleft);
		$this->tmpl->addVar("_widget", "head_url_mtop",	$url_mtop);
		$this->tmpl->addVar("_widget", "head_url_mright",	$url_mright);
		$this->tmpl->addVar("_widget", "head_title_color", $titleColor);
		$this->tmpl->addVar("_widget", "head_desc_color", $descColor);
		$this->tmpl->addVar("_widget", "head_url_color", $urlColor);
		$this->tmpl->addVar("_widget", "head_bgcolor", $bgcolor);
		$this->tmpl->addVar("_widget", "head_width",	$width);
		$this->tmpl->addVar("_widget", "head_height",	$height);
		$this->tmpl->addVar("_widget", "head_title_fontsize",	$titleFontsize);
		$this->tmpl->addVar("_widget", "head_desc_fontsize",	$descFontsize);
		$this->tmpl->addVar("_widget", "head_url_fontsize",	$urlFontsize);
	}
}
?>
