<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_qrcodeWidgetContainer.php 22 2007-11-16 10:14:07Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
//require_once($gEnvManager->getCurrentWidgetDbPath() .	'/qrcode_mainDb.php');

class admin_qrcodeWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
					
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		//$this->db = new qrcode_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		$act = $request->trimValueOf('act');
		if ($act == 'update'){		// 設定更新のとき
			$useFixedData = ($request->trimValueOf('use_fixed_data') == 'on') ? 1 : 0;		// 固定データを使用
			$qrData = $request->trimValueOf('qr_data');			// QRコード化するデータ
			$title = $request->trimValueOf('title');			// 表示タイトル
			$desc = $request->trimValueOf('desc');				// 説明

			// 入力値のエラーチェック
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj->useFixedData = $useFixedData;			// 固定データを使用
				$paramObj->qrData = $qrData;						// QRコード化するデータ
				$paramObj->title = $title;			// 表示タイトル
				$paramObj->desc = $desc;				// 説明
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else {		// 初期表示の場合
			// デフォルト値の設定
			$useFixedData = 0;		// 固定データを使用
			$qrData = '';			// QRコード化するデータ
			$title = 'QRコード';			// 表示タイトル
			$desc = '';				// 説明
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$useFixedData = $paramObj->useFixedData;		// 固定データを使用
				$qrData = $paramObj->qrData;			// QRコード化するデータ
				$title = $paramObj->title;			// 表示タイトル
				$desc = $paramObj->desc;				// 説明
			}
		}
		// 画面に書き戻す
		$checked = '';
		if ($useFixedData) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_fixed_data", $checked);// 固定データを使用
		$this->tmpl->addVar("_widget", "qr_data", $qrData);			// QRコード化するデータ
		$this->tmpl->addVar("_widget", "title", $title);			// 表示タイトル
		$this->tmpl->addVar("_widget", "desc", $desc);				// 説明
	}
}
?>
