/**
 * Magic3Ajaxライブラリ
 *
 * JavaScript 1.5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: m3ajax1.1.js 698 2008-06-06 13:04:43Z fishbone $
 * @link       http://www.magic3.org
 */
/**
 * Ajax非同期通信
 * @param string request_widget		指定ウィジェット
 * @param string request_params		リクエストパラメータ
 * @param function success_func(request, retcode, jsondata)	通信成功時の呼び出し関数
 * @param function failure_func(request)					通信失敗時の呼び出し関数
 * @param string request_url		リクエスト先URL
 */
function m3_ajax_request(request_widget, request_params, success_func, failure_func, request_url)
{
	if (request_url == null || request_url == "") request_url = document.location.pathname;

	var params = "";
	if (request_widget != null && request_widget != "") params += "cmd=dowidget&widget=" + request_widget;
	if (request_params != null && request_params != "") params += "&" + request_params;
	
	if (typeof jQuery == "undefined"){	// Prototypeの場合
		new Ajax.Request(	request_url,
						{	method:			"post",
							parameters:		params,
							onSuccess:		function(request, json){
												m3_ajax_success(request, json, success_func);
											},
							onFailure:		function(request, json){
												m3_ajax_failure(request, json, failure_func);
											},
							evalScripts:	true	});
	} else {	// JQueryの場合
		$.ajax({	url: request_url,
					type:		'post',
					data:		params,
					dataType:	'json',
					success:	function(data, textStatus){
									alert("JSON date must be in header with 'X-JSON' type");
								},
					error:		function(request, textStatus, errorThrown){
									if (request.status == 200){
										var json = eval(request.getResponseHeader("X-JSON"));
										m3_ajax_success(request, json, success_func);
									} else {
										m3_ajax_failure(request, json, failure_func);
									}
								}
				});
	}
}
/**
 * Ajax非同期通信正常時に呼ばれるデフォルト関数
 * @param XMLHttpRequest	request		サーバからのレスポンス
 * @param Object			json		JSON型データ
 */
function m3_ajax_success(request, json, success_func)
{
	if (success_func == null || success_func == ''){
		alert(request.statusText + "\nstatus code = " + request.status);
	} else {
		if (typeof success_func == "function"){
			var retcode = -1;
			var jsondata;
			if (json != null){
				retcode = json.retcode;
				jsondata = json.data;
			}
			success_func(request, retcode, jsondata);
		} else {
			alert('cannot found success function');
		}
	}
}
/**
 * Ajax非同期通信の通信エラー時に呼ばれるデフォルト関数
 * @param XMLHttpRequest	request		サーバからのレスポンス
 */
function m3_ajax_failure(request, json, failure_func)
{
	if (failure_func == null || failure_func == ''){
		alert(request.statusText + "\nstatus code = " + request.status);
	} else {
		if (typeof failure_func == "function"){
			failure_func(request);
		} else {
			alert('cannot found failure function');
		}
	}
}

