<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainPageotherWidgetContainer.php 145 2007-12-19 13:37:58Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');
			
class admin_mainPageotherWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $subIdMenuData;		// サブページIDメニュー用データ
	private $defaultSubId;		// 選択中のデフォルトのサブページID
	private $idArray = array();		// 表示中のID
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'pageidlist.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gSystemManager;
		
		$act = $request->trimValueOf('act');
		
		if ($this->db->canDetailConfig()){		// 詳細設定可のときは、ページID選択を可にする
			$pageType = $request->trimValueOf('pagetype');		// 処理対象のページ種別
			if (empty($pageType)) $pageType = 0;
		} else {
			// 詳細設定不可のときは、ページサブIDのみ編集可能
			$pageType = 1;
		}
		
		$id = $request->trimValueOf('item_id');		// ID
		$targetId = $request->trimValueOf('id');		// 処理対象のID
		$name = $request->trimValueOf('item_name');	// 名前
		$this->defaultSubId = $request->trimValueOf('item_subid');	// サブページID
		$path = $request->trimValueOf('item_path');	// パス
		$priority = $request->trimValueOf('item_priority');	// 優先度
		$desc = $request->trimValueOf('item_desc');	// 説明
		$isPublic = ($request->trimValueOf('item_ispublic') == 'on') ? 1 : 0;		// 公開するかどうか

		$isErr = false;		// エラーが発生したかどうか
		if ($act == 'add'){		// ページID追加のとき
			// 入力チェック
			$this->checkSingleByte($id, 'ID');
			$this->checkInput($name, '名前');
			$this->checkNumeric($priority, '優先度');
			if ($pageType == 0) $this->checkPath($path, 'パス');		// ページIDのときは必須入力
			
			// 優先度、パスの重複チェック
			$this->db->getPageIdRecords($pageType, $prioArray);
			for ($i = 0; $i < count($prioArray); $i++){
				if ($priority == $prioArray[$i]['pg_priority']){
					$this->setMsg(self::MSG_USER_ERR, '優先順が重複しています');
					break;
				}
				if (!empty($path) && $path == $prioArray[$i]['pg_path']){
					$this->setMsg(self::MSG_USER_ERR, 'パスが重複しています');
					break;
				}
			}
			
			// ページID存在チェック
			if ($this->db->isExistsPageId($pageType, $id)) $this->setMsg(self::MSG_USER_ERR, 'IDが重複しています');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addPageId($pageType, $id, $name, $this->defaultSubId, $path, $priority, $desc, $isPublic);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ追加に失敗しました');
					$isErr = true;		// エラーが発生したかどうか
				}
			} else {
				$isErr = true;		// エラーが発生したかどうか
			}						
		} else if ($act == 'update'){		// 更新のとき
			// 入力データエラーチェック
			$prioCheckArray = array();
			$pathCheckArray = array();
			$listedItem = explode(',', $request->trimValueOf('idlist'));
			for ($i = 0; $i < count($listedItem); $i++){
				$line = array();
				
				// ページタイプ
				$line['pg_type'] = $pageType;
				
				// ID
				$itemName = 'item' . $listedItem[$i] . '_id';
				$itemValue = $request->trimValueOf($itemName);
				$line['pg_id'] = $itemValue;
				$this->checkSingleByte($itemValue, 'ID');

				// 名前
				$itemName = 'item' . $listedItem[$i] . '_name';
				$itemValue = $request->trimValueOf($itemName);
				$line['pg_name'] = $itemValue;
				$this->checkInput($itemValue, '名前');
				
				// 優先度
				$itemName = 'item' . $listedItem[$i] . '_priority';
				$itemValue = $request->trimValueOf($itemName);
				$line['pg_priority'] = $itemValue;
				$this->checkNumeric($itemValue, '優先順');
				// 重複チェック
				if (in_array($itemValue, $prioCheckArray)) $this->setUserErrorMsg('優先順が重複しています');
				$prioCheckArray[] = $itemValue;
				
				if ($pageType == 0){		// ページIDのとき
					// デフォルトサブページ
					$itemName = 'item' . $listedItem[$i] . '_subid';
					$itemValue = $request->trimValueOf($itemName);
					$line['pg_default_sub_id'] = $itemValue;
										
					// パス
					$itemName = 'item' . $listedItem[$i] . '_path';
					$itemValue = $request->trimValueOf($itemName);
					$line['pg_path'] = $itemValue;
					$this->checkPath($itemValue, 'パス');
					// 重複チェック
					if (in_array($itemValue, $pathCheckArray)) $this->setUserErrorMsg('パスが重複しています');
					$pathCheckArray[] = $itemValue;					
				} else {
					$line['pg_default_sub_id'] = '';
					$line['pg_path'] = '';
				}
				
				// 説明
				$itemName = 'item' . $listedItem[$i] . '_desc';
				$itemValue = $request->trimValueOf($itemName);
				$line['pg_description'] = $itemValue;
				
				// 公開
				$itemName = 'item' . $listedItem[$i] . '_ispublic';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				$line['pg_is_public'] = $itemValue;
				
				// 行を追加
				$listRows[] = $line;
			}
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updatePageId($pageType, $listRows);
				if ($ret){		// 更新成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$listRows = array();		// データを初期化
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 削除のとき
			$ret = $this->db->deletePageId($pageType, $targetId);
			if ($ret){		// データ更新成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'ページIDを削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'ページID削除に失敗しました');
			}
		}
		if ($this->db->canDetailConfig()){		// 詳細設定可のときは、ページID選択を可にする
			$this->tmpl->setAttribute('hide_page_id', 'visibility', 'visible');// ページID選択メニュー
		}
		
		// ページタイプ
		if ($pageType == 0){		// ページIDのとき
			// ウィジェットサブIDメニュー作成
			$this->db->getPageIdRecords(1, $this->subIdMenuData);
			$this->createSubIdMenu();		// フッタ部のメニュー
		
			$this->tmpl->addVar("hide_page_id", "selected_page", 'selected');
			$this->tmpl->setAttribute('default_sub_page', 'visibility', 'visible');// デフォルトサブページ選択メニュー表示
			$this->tmpl->setAttribute('default_sub_page_foot', 'visibility', 'visible');// デフォルトサブページ選択メニュー表示
			$this->tmpl->setAttribute('path', 'visibility', 'visible');// パス表示
			$this->tmpl->setAttribute('path_foot', 'visibility', 'visible');// パス表示
		} else {
			$this->tmpl->addVar("hide_page_id", "selected_sub", 'selected');
		}
		if ($isErr){		// エラーが発生したときは値を書き戻す
			$this->tmpl->addVar("_widget", "id", $id);
			$this->tmpl->addVar("_widget", "name", $name);
			$this->tmpl->addVar("_widget", "desc", $desc);
			$this->tmpl->addVar("_widget", "priority", $priority);
			$this->tmpl->addVar("path_foot", "path", $path);
			
			if ($isPublic) $this->tmpl->addVar("_widget", "is_public", 'checked');// 公開状況
		}

		// ページIDリストを取得
		if (empty($listRows)) $this->db->getPageIdRecords($pageType, $listRows);
		
		// 一覧を表示
		$this->setAllItems($listRows);
		
		// 表示項目のIDを設定
		$this->tmpl->addVar("_widget", "id_list", implode($this->idArray, ','));
	}
	/**
	 * ページIDリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	 /*
	function itemListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
			
		$id = $fetchedRow['pg_id'];			// ID
		
		// 公開状況
		$isPublic = '';
		if ($fetchedRow['pg_is_public']){
			$isPublic = 'checked';
		}

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		
		// selectメニューの作成
		$this->tmpl->clearTemplate('sub_id_list');
		for ($i = 0; $i < count($this->subIdMenuData); $i++){
			$selected = '';
			if ($fetchedRow['pg_default_sub_id'] == $this->subIdMenuData[$i]['pg_id']){
				$selected = 'selected';
			}
			$menurow = array(
				'value'		=> $this->subIdMenuData[$i]['pg_id'],			// ページID
				'name'		=> $this->subIdMenuData[$i]['pg_id'] . ' - ' . $this->subIdMenuData[$i]['pg_name'],			// ページ名
				'selected'	=> $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('sub_id_list', $menurow);
			$this->tmpl->parseTemplate('sub_id_list', 'a');
		}
		// selectメニューのIDを設定
		$this->tmpl->clearTemplate('default_sub_page');
		$row2 = array(		
				'id'		=> $id			// ID
		);
		$this->tmpl->addVars('default_sub_page', $row2);
		$this->tmpl->parseTemplate('default_sub_page', 'a');
		// パス入力のIDを設定
		$this->tmpl->clearTemplate('path');
		$row3 = array(		
				'id'		=> $id,			// ID
				'path' => $this->convertToDispString($fetchedRow['pg_path'])		// パス
		);
		$this->tmpl->addVars('path', $row3);
		$this->tmpl->parseTemplate('path', 'a');
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['pg_name']),		// 名前
			'path' => $this->convertToDispString($fetchedRow['pg_path']),		// パス
			'desc' => $this->convertToDispString($fetchedRow['pg_description']),		// 説明
			'priority' => $this->convertToDispString($fetchedRow['pg_priority']),		// 優先度
			'is_public' => $isPublic										// 公開状況
		);
		$this->tmpl->addVars('templist', $row);
		$this->tmpl->parseTemplate('templist', 'a');
		
		// IDを保存
		$this->idArray[] = $id;
		return true;
	}*/
	/**
	 * ページIDリスト、取得したデータをテンプレートに設定する
	 *
	 * @param array $rows		設定するデータ
	 * @return bool				true=処理続行の場合、false=処理終了の場合
	 */
	function setAllItems($rows)
	{
		global $gEnvManager;
			
		for ($j = 0; $j < count($rows); $j++)
		{
			$id = $rows[$j]['pg_id'];			// ID
		
			// 公開状況
			$isPublic = '';
			if ($rows[$j]['pg_is_public']){
				$isPublic = 'checked';
			}

			// 行カラーの設定
			$lineColor = '';
			if ($j % 2 != 0){
				$lineColor = 'class="even"';		// 偶数行
			}
			$buttonEnabled = '';
			$itemEnabled = '';
			if (!$rows[$j]['pg_editable']){
				$buttonEnabled = 'disabled';
				$itemEnabled = 'readonly';
			}
			// selectメニューの作成
			$this->tmpl->clearTemplate('sub_id_list');
			for ($i = 0; $i < count($this->subIdMenuData); $i++){
				$selected = '';
				if ($rows[$j]['pg_default_sub_id'] == $this->subIdMenuData[$i]['pg_id']){
					$selected = 'selected';
				}
				$menurow = array(
					'value'		=> $this->subIdMenuData[$i]['pg_id'],			// ページID
					'name'		=> $this->subIdMenuData[$i]['pg_id'] . ' - ' . $this->subIdMenuData[$i]['pg_name'],			// ページ名
					'selected'	=> $selected														// 選択中かどうか
				);
				$this->tmpl->addVars('sub_id_list', $menurow);
				$this->tmpl->parseTemplate('sub_id_list', 'a');
			}
			// selectメニューのIDを設定
			$this->tmpl->clearTemplate('default_sub_page');
			$row2 = array(		
					'id'		=> $id			// ID
			);
			$this->tmpl->addVars('default_sub_page', $row2);
			$this->tmpl->parseTemplate('default_sub_page', 'a');
			// パス入力のIDを設定
			$this->tmpl->clearTemplate('path');
			$row3 = array(		
					'id'		=> $id,			// ID
					'path' => $this->convertToDispString($rows[$j]['pg_path']),		// パス
					'path_disabled' => $itemEnabled												
			);
			$this->tmpl->addVars('path', $row3);
			$this->tmpl->parseTemplate('path', 'a');
			$row = array(
				'line_color' => $lineColor,											// 行のカラー
				'id' => $id,			// ID
				'name' => $this->convertToDispString($rows[$j]['pg_name']),		// 名前
				'path' => $this->convertToDispString($rows[$j]['pg_path']),		// パス
				'desc' => $this->convertToDispString($rows[$j]['pg_description']),		// 説明
				'priority' => $this->convertToDispString($rows[$j]['pg_priority']),		// 優先度
				'is_public' => $isPublic,										// 公開状況
				'name_disabled' => $itemEnabled,									// 名前入力
				'priority_disabled' => $itemEnabled,									// 優先順入力
				'is_public_disabled' => $itemEnabled,									// 公開状況
				'desc_disabled' => $itemEnabled,									// 説明入力
				'del_button' => $buttonEnabled									// 削除ボタン
			);
			$this->tmpl->addVars('templist', $row);
			$this->tmpl->parseTemplate('templist', 'a');
		
			// IDを保存
			$this->idArray[] = $id;
		}
		return true;
	}
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$pid = $fetchedRow['pg_id'];
		if ($pid == $this->pageSubId){
			$selected = 'selected';
		}
		$value = $this->convertToDispString($pid);
		
		// 表示ラベルを作成
		$name = $value . ' - ' . $this->convertToDispString($fetchedRow['pg_name']);
		// デフォルトのページサブIDのときは、説明を付加
		if ($pid == $this->defaultPageSubId){
			$name .= ' (デフォルト値)';
		}
		$row = array(
			'value'    => $value,			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		return true;
	}
	/**
	 * フッタ部のデフォルトサブページID選択メニューを作成
	 *
	 * @return なし	
	 */
	function createSubIdMenu()
	{
		for ($i = 0; $i < count($this->subIdMenuData); $i++){
			$selected = '';
			if ($this->subIdMenuData[$i]['pg_id'] == $this->defaultSubId) $selected = 'selected';
			
			$menurow = array(
				'value'		=> $this->subIdMenuData[$i]['pg_id'],			// ページID
				'name'		=> $this->subIdMenuData[$i]['pg_id'] . ' - ' . $this->subIdMenuData[$i]['pg_name'],			// ページ名
				'selected'	=> $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('sub_id_list_foot', $menurow);
			$this->tmpl->parseTemplate('sub_id_list_foot', 'a');
		}
	}
}
?>
