<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainConfigsysWidgetContainer.php 948 2008-08-28 12:26:33Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainConfigsysWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const CAN_DETAIL_CONFIG	= 'permit_detail_config';				// 詳細設定が可能かどうか
	const REGENERATE_SESSION = 'regenerate_session_id';				// セッションIDを毎回更新するかどうか
	const SCRIPT_CACHE_IN_BROWSER = 'script_cache_in_browser';				// ブラウザにスクリプトのキャッシュを保持するかどうか
//	const MENUBAR_ALWAYS_VISIBLE = 'menubar_always_visible';				// 管理機能メニューバーを常時表示するかどうか
	const MENU_ITEM_DEVELOP = 'develop';				// 「開発」メニューの識別ID
	const SERVER_ID = 'server_id';		// サーバID
	const DEFAULT_LANG		= 'default_lang';					// デフォルト言語
	const SITE_IN_PUBLIC = 'site_in_public';			// サイト公開状況
	const SITE_ACCESS_EXCEPTION_IP = 'site_access_exception_ip';		// アクセス制御、例外とするIP
	const INSTALL_DT = 'install_dt';		// システムインストール日時
	const WORK_DIR = 'work_dir';			// 作業ディレクトリ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'configsystem.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gConfigManager;
		global $gEnvManager;
		
		$this->defaultLang		= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$canDetailConfig = ($request->trimValueOf('item_can_detail_config') == 'on') ? 1 : 0;		// 詳細システム設定が可能かどうか
		$regenerateSession = ($request->trimValueOf('item_regenerate_sesison') == 'on') ? 1 : 0;		// セッションIDを更新するかどうか
		$scriptCacheInBrowser = ($request->trimValueOf('item_script_cache_in_browser') == 'on') ? 1 : 0;		// ブラウザにスクリプトのキャッシュを保持するかどうか
		//$menubarAlwaysVisible = ($request->trimValueOf('item_menubar_always_visible') == 'on') ? 1 : 0;		// 管理機能メニューバーを常時表示するかどうか
		$lang = $request->trimValueOf('item_lang');
		$workDir = $request->trimValueOf('item_work_dir');
		if ($act == 'update'){		// 設定更新のとき
			$isErr = false;
			if (!$isErr && !empty($lang)){
				if (!$this->db->updateSystemConfig(self::DEFAULT_LANG, $lang)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::CAN_DETAIL_CONFIG, $canDetailConfig)) $isErr = true;
			}	
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::REGENERATE_SESSION, $regenerateSession)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::SCRIPT_CACHE_IN_BROWSER, $scriptCacheInBrowser)) $isErr = true;
			}
			if (!$isErr){
				// 最後の「/」を除く
				$workDir = rtrim($workDir, '/');
				if (!$this->db->updateSystemConfig(self::WORK_DIR, $workDir)) $isErr = true;
			}
			
			if ($isErr){
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			} else {
				$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
			}
			// システムパラメータを更新
			$gEnvManager->loadSystemParams();
			
			// 値を再取得
			$this->defaultLang		= $gEnvManager->getDefaultLanguage();
			$canDetailConfig	= $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
			$regenerateSession	= $this->db->getSystemConfig(self::REGENERATE_SESSION);
			$scriptCacheInBrowser = $this->db->getSystemConfig(self::SCRIPT_CACHE_IN_BROWSER);
			$workDir = $this->db->getSystemConfig(self::WORK_DIR);
		//	$menubarAlwaysVisible = $this->db->getSystemConfig(self::MENUBAR_ALWAYS_VISIBLE);
			
			// メニュー項目の制御
			$this->db->updateMenuVisible(self::MENU_ITEM_DEVELOP, $canDetailConfig);			// 「開発」メニュー
		} else if ($act == 'updateip'){		// IPアドレスを更新のとき
			$exceptIp = $request->trimValueOf('except_ip');

			// 入力チェック
			$this->checkIp($exceptIp, 'IP', true);
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$isErr = false;
				if (!$this->db->updateSystemConfig(self::SITE_ACCESS_EXCEPTION_IP, $exceptIp)) $isErr = true;
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			}
		} else if ($act == 'siteopen'){		// サイト運用開始のとき
			$this->db->updateSystemConfig(self::SITE_IN_PUBLIC, 1);
		} else if ($act == 'siteclose'){		// サイト運用停止のとき
			$this->db->updateSystemConfig(self::SITE_IN_PUBLIC, 0);
		} else {		// 初期表示の場合
			$canDetailConfig	= $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
			$regenerateSession	= $this->db->getSystemConfig(self::REGENERATE_SESSION);
			$scriptCacheInBrowser = $this->db->getSystemConfig(self::SCRIPT_CACHE_IN_BROWSER);
			$workDir				= $this->db->getSystemConfig(self::WORK_DIR);
		//	$menubarAlwaysVisible = $this->db->getSystemConfig(self::MENUBAR_ALWAYS_VISIBLE);
		}
		// 言語選択メニューを作成
		$this->db->getAllLang(array($this, 'langLoop'));
		
		// サイトURL
		$this->tmpl->addVar("_widget", "site_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "pc_access_url", $gEnvManager->getDefaultUrl());
		$this->tmpl->addVar("_widget", "mobile_access_url", $gEnvManager->getDefaultMobileUrl());
		$this->tmpl->addVar("_widget", "admin_access_url", $gEnvManager->getDefaultAdminUrl());
		// 携帯画面エンコード
		$this->tmpl->addVar("_widget", "mobile_encode", $gEnvManager->getMobileEncoding());
		
		// サイト運用状況を設定
		if ($this->db->getSystemConfig(self::SITE_IN_PUBLIC)){		// 運用中のとき
			$this->tmpl->addVar("_widget", "site_open", '公開中');
			$this->tmpl->addVar("_widget", "site_open_status", '0');
			$this->tmpl->addVar("_widget", "site_open_label", '公開停止');
		} else {
			$this->tmpl->addVar("_widget", "site_open", '非公開');
			$this->tmpl->addVar("_widget", "site_open_status", '1');
			$this->tmpl->addVar("_widget", "site_open_label", '公開開始');
		}
		$this->tmpl->addVar("_widget", "except_ip", $this->db->getSystemConfig(self::SITE_ACCESS_EXCEPTION_IP));
		
		// 画面に書き戻す
		$checked = '';
		if ($canDetailConfig) $checked = 'checked';
		$this->tmpl->addVar("_widget", "can_detail_config", $checked);
		
		$checked = '';
		if ($regenerateSession) $checked = 'checked';
		$this->tmpl->addVar("_widget", "regenerate_session", $checked);
		
		$checked = '';
		if ($scriptCacheInBrowser) $checked = 'checked';
		$this->tmpl->addVar("_widget", "script_cache_in_browser", $checked);
		
//		$checked = '';
//		if ($menubarAlwaysVisible) $checked = 'checked';
//		$this->tmpl->addVar("_widget", "menubar_always_visible", $checked);
		
		$limit = ini_get('upload_max_filesize') > ini_get('post_max_size') ? ini_get('post_max_size') : ini_get('upload_max_filesize');
		$limit = $limit > ini_get('memory_limit') ? ini_get('memory_limit') : $limit;
		$this->tmpl->addVar("_widget", "upload_filesize_limit", $limit);
		$this->tmpl->addVar("_widget", "memory_limit", ini_get('memory_limit'));
		$this->tmpl->addVar("_widget", "post_max_size", ini_get('post_max_size'));
		$this->tmpl->addVar("_widget", "upload_max_filesize", ini_get('upload_max_filesize'));
		
		// バージョン
		$this->tmpl->addVar("_widget", "magic3_version", M3_SYSTEM_VERSION);
		$this->tmpl->addVar("_widget", "php_version", phpversion());
		if ($this->db->getDbType() == M3_DB_TYPE_MYSQL){		// MySQLの場合
			$dbType = 'MySQL';
		} else if ($this->db->getDbType() == M3_DB_TYPE_PGSQL){// PostgreSQLの場合
			$dbType = 'PostgreSQL';
		} else {
			$dbType = 'DB未設定';
		}
		$this->tmpl->addVar("_widget", "db_type", $dbType);			// 使用しているDB種
		$this->tmpl->addVar("_widget", "db_version", $this->db->getDbVersion());
		$this->tmpl->addVar("_widget", "os_version", php_uname('s') . ' ' . php_uname('r') . ' ' . php_uname('m'));		// OSバージョン
		
		// DB接続
		$gConfigManager->getDbConnectDsnByList($dbType, $hostname, $dbname);
		$this->tmpl->addVar("_widget", "db_type", $dbType);			// DB種
		$this->tmpl->addVar("_widget", "db_host_name", $hostname);			// DBホスト名
		$this->tmpl->addVar("_widget", "db_name", $dbname);			// DB名
		$dbuser = $gConfigManager->getDbConnectUser();		// 接続ユーザ
		$this->tmpl->addVar("_widget", "db_user_name", $dbuser);			// 接続ユーザ名
				
		// mbstring
		if (extension_loaded('mbstring')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_mbstring", $data);
		// gd
		if (extension_loaded('gd')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_gd", $data);
		// xml
		if (extension_loaded('xml')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_xml", $data);
		
		// サーバ環境
		$hostname = exec('hostname');
		$this->tmpl->addVar("_widget", "host_name", $hostname);
		$dnsResolv = '解決できません';
		if ($hostname != 'localhost.localdomain'){
			$hosts = gethostbynamel($hostname);
			if (count($hosts) > 0) $dnsResolv = $hosts[0];
		}
		$this->tmpl->addVar("_widget", "dns_resolv", $dnsResolv);
		$this->tmpl->addVar("_widget", "server_id", $this->db->getSystemConfig(self::SERVER_ID));
		$this->tmpl->addVar("_widget", "install_dt", $this->db->getSystemConfig(self::INSTALL_DT));		// インストール日時
		$this->tmpl->addVar("_widget", "work_dir", $workDir);		// 一時ディレクトリ
		if (is_writable($workDir)){
			$data = '<b><font color="green">書き込み可能</font></b>';
		} else {
			$data = '<b><font color="red">書き込み不可</font></b>';
		}
		$this->tmpl->addVar("_widget","work_dir_access", $data);		// 一時ディレクトリの書き込み権限
		
		// phpinfo出力へのURL
		//$phpinfoUrl = '?task=phpinfo&menu=off';			// メニューは非表示にする
		$phpinfoUrl = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_SHOW_PHPINFO;			// phpinfo画面
		$this->tmpl->addVar("_widget", "phpinfo_url", $phpinfoUrl);
	}
	/**
	 * 取得した言語をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['ln_id'] == $this->defaultLang){
			$selected = 'selected';
		}
		//if ($gEnvManager->getCurrentLanguage() == 'ja'){		// 日本語表示の場合
			$name = $this->convertToDispString($fetchedRow['ln_name']) . ' - ';
		//} else {
			$name .= $this->convertToDispString($fetchedRow['ln_name_en']);
		//}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['ln_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		return true;
	}
}
?>
