<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainEditmenuWidgetContainer.php 977 2008-09-03 08:19:30Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_mainEditmenuWidgetContainer extends BaseWidgetContainer
{
	private $menuBasicItems;			// 元となるメニュー項目
	private $adminPages;			// 管理機能ウィジェットの選択可能画面
	
	// メニュー項目タイプ
	const ITEM_TYPE_TITLE		= 0;		// タイトル
	const ITEM_TYPE_CR			= 1;			// 改行
	const ITEM_TYPE_ADMIN_PAGE	= 10;	// 管理ウィジェットの管理画面
	const ITEM_TYPE_WIDGET_PAGE	= 11;	// ウィジェットの管理画面
	const ITEM_TYPE_LOGOUT	= 20;		// ログアウト処理
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// 元となるメニュー項目
		$this->menuBasicItems = array(	array('type' => self::ITEM_TYPE_TITLE,		'name' => 'タイトル',		'desc' => 'メニューのタイトル名項目を作成します。'),
										array('type' => self::ITEM_TYPE_CR,			'name' => '改行',			'desc' => 'メニューの項目ブロックを改行します。'),
										array('type' => self::ITEM_TYPE_ADMIN_PAGE,	'name' => '管理機能ウィジェットの画面を起動',		'desc' => '管理機能ウィジェットの画面を表示します。'),
										array('type' => self::ITEM_TYPE_WIDGET_PAGE,	'name' => '各種ウィジェットの管理画面を起動',	'desc' => '管理機能以外のウィジェットの管理画面を表示します。'),
										array('type' => self::ITEM_TYPE_LOGOUT,		'name' => 'ログアウト',		'desc' => 'ログアウト処理を行います。')
								);
		// 管理機能ウィジェットの選択可能画面
		$this->adminPages = array(	array('task' => 'pagedef',			'name' => 'PC用画面編集',		'desc' => 'PC用Webサイトの画面を作成します。'),
									array('task' => 'pagedef_mobile',	'name' => '携帯用画面編集',		'desc' => '携帯用Webサイトの画面を作成します。'),
									array('task' => 'widgetlist',		'name' => 'ウィジェット管理',	'desc' => 'ウィジェットの管理を行います。'),
									array('task' => 'templist',			'name' => 'テンプレート管理',	'desc' => 'テンプレートの管理を行います。'),
									array('task' => 'pageother',		'name' => 'システムマスター管理', 'desc' => 'システムに関するデータの管理を行います。'),
									array('task' => 'userlist',			'name' => 'ユーザ一覧',			'desc' => 'ログイン可能なユーザを管理します。'),
									array('task' => 'loginstatus',		'name' => 'ログイン状況',		'desc' => 'ユーザのログイン状況を表示します。'),
									array('task' => 'configsite',		'name' => '基本情報',			'desc' => 'サイト運営者の設定を行います。'),
									array('task' => 'configsys',		'name' => 'システム情報',		'desc' => 'システム全体の設定、運用状況を管理します。'),
									array('task' => 'initsystem',		'name' => 'DBメンテナンス',		'desc' => 'データの初期化などDBのメンテナンスを行います。'),
									array('task' => 'editsource',		'name' => 'ソース参照',			'desc' => 'ソース参照', 'ソースコードが参照できます。'),
									array('task' => 'createtable',		'name' => 'ユーザ定義テーブル', 'desc' => 'ユーザ定義テーブル', 'ユーザ定義のテーブルの作成、データの編集を行います。')
								);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'editmenu.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		// メニュー基本項目一覧作成
		$this->createMenuBasicItemList();
		
		// パスを設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}
	/**
	 * メニュー基本項目一覧作成
	 *
	 * @return なし						
	 */
	function createMenuBasicItemList()
	{
				// selectメニューの作成
				$this->tmpl->clearTemplate('sub_id_list');
				for ($j = 0; $j < count($this->adminPages); $j++){
					/*$selected = '';
					if ($rows[$j]['pg_default_sub_id'] == $this->adminPages[$j]['pg_id']){
						$selected = 'selected';
					}*/
					$menurow = array(
						'value'		=> $this->adminPages[$j]['task'],			// 機能値
						'name'		=> $this->adminPages[$j]['name'],			// 機能名
						'selected'	=> $selected														// 選択中かどうか
					);
					$this->tmpl->addVars('sub_id_list', $menurow);
					$this->tmpl->parseTemplate('sub_id_list', 'a');
				}
				
		for ($i = 0; $i < count($this->menuBasicItems); $i++){
			$targetObj = $this->menuBasicItems[$i];


			if ($targetObj['type'] == self::ITEM_TYPE_ADMIN_PAGE){		// 管理機能画面への遷移項目のとき
				$this->tmpl->addVar('menubasiclist', 'type', 'admin_page');// 管理機能画面
//$this->tmpl->setAttribute('select_admin_page', 'visibility', 'visible');// デフォルトサブページ選択メニュー表示
//$this->tmpl->setAttribute('aaa', 'visibility', 'visible');// デフォルトサブページ選択メニュー表示

				// selectメニューのIDを設定
				/*$this->tmpl->clearTemplate('default_sub_page');
				$row2 = array(		
						'id'		=> $id			// ID
				);
				$this->tmpl->addVars('default_sub_page', $row2);
				$this->tmpl->parseTemplate('default_sub_page', 'a');*/
		
			} else {
//$this->tmpl->setAttribute('select_admin_page', 'visibility', 'hidden');// デフォルトサブページ選択メニュー表示
//$this->tmpl->setAttribute('aaa', 'visibility', 'hidden');// デフォルトサブページ選択メニュー表示
			}
			$row = array(
				'name' => $targetObj['name'],		// 名前
				'desc' => $targetObj['desc']		// 説明
			);
			$this->tmpl->addVars('menubasiclist', $row);
			$this->tmpl->parseTemplate('menubasiclist', 'a');
		}
	}
}
?>
