<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: wiki_mainWidgetContainer.php 1053 2008-10-01 07:53:18Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/wiki_mainDb.php');
// Magic3追加ファイル
require_once($gEnvManager->getCurrentWidgetLibPath() . '/wikiConfig.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/wikiPage.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/wikiParam.php');

// PukiWikiファイル
require_once($gEnvManager->getCurrentWidgetLibPath() . '/func.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/file.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/plugin.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/html.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/backup.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/convert_html.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/make_link.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/diff.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/config.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/link.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/auth.php');
require_once($gEnvManager->getCurrentWidgetLibPath() . '/proxy.php');
//require_once($gEnvManager->getCurrentWidgetIncludePath() . '/conf/pukiwiki.ini.php');		// 初期設定ファイル
//require_once($gEnvManager->getCurrentWidgetLibPath() . '/init.php');
//if (!extension_loaded('mbstring')){
//	require($gEnvManager->getCurrentWidgetLibPath() . '/mbstring.php');
//}

class wiki_mainWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $langId;		// 現在の言語
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new wiki_mainDb();

		// クラス初期化
		WikiConfig::init($this->db);
		WikiPage::init($this->db);
		WikiParam::init($this->db);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		// PukiWiki用グローバル変数		// add for Magic3 by naoki on 2008/9/28
		global $vars;
		
		// 初期設定が完了していなときは、初期データ読み込み
		WikiPage::readInitData();
		
		$this->langId = $gEnvManager->getCurrentLanguage();
		$wikiLibDir = $gEnvManager->getCurrentWidgetLibPath();
		
		// Defaults
		$notify = $trackback = $referer = 0;

		// Load *.ini.php files and init PukiWiki
		require($wikiLibDir . '/init.php');

		// Load optional libraries
		if ($notify) {
			require($wikiLibDir . '/mail.php'); // Mail notification
		}
		if ($trackback || $referer) {
			// Referer functionality uses trackback functions
			// without functional reason now
			require($wikiLibDir . '/trackback.php'); // TrackBack
		}

		$retvars = array();
		$is_cmd = FALSE;
		$cmd = WikiParam::getCmd();
		$plugin = WikiParam::getPlugin();
		//if (isset($vars['cmd'])) {
		if (!empty($cmd)) {
			$is_cmd  = TRUE;
			//$plugin = & $vars['cmd'];
			$plugin = $cmd;
		//} else if (isset($vars['plugin'])) {
		//} else if (!empty($plugin)) {
		//	$plugin = & $vars['plugin'];
		//} else {
		//	$plugin = '';
		}
		// プラグイン、コマンドの実行。プラグインでグローバル変数$varsを使用。
		if ($plugin != '') {
			if (exist_plugin_action($plugin)) {
				// Found and exec
				$retvars = do_plugin_action($plugin);
				if ($retvars === FALSE) exit; // Done

				if ($is_cmd) {
					//$base = isset($vars['page'])  ? $vars['page']  : '';
					$base = WikiParam::getPage();
				} else {
					//$base = isset($vars['refer']) ? $vars['refer'] : '';
					$base = WikiParam::getRefer();
				}
			} else {
				// Not found
				$msg = 'plugin=' . htmlspecialchars($plugin) .
					' is not implemented.';
				$retvars = array('msg'=>$msg,'body'=>$msg);
				//$base    = & $defaultpage;
				$base = WikiConfig::getDefaultPage();
			}
		}
		$title = htmlspecialchars(strip_bracket($base));
		$page  = make_search($base);
		if (isset($retvars['msg']) && $retvars['msg'] != '') {
			$title = str_replace('$1', $title, $retvars['msg']);
			$page  = str_replace('$1', $page,  $retvars['msg']);
		}
		if (isset($retvars['body']) && $retvars['body'] != '') {
			$body = & $retvars['body'];
		} else {
			if ($base == '' || !is_page($base)){
				//$base  = & $defaultpage;
				$base = WikiConfig::getDefaultPage();
				$title = htmlspecialchars(strip_bracket($base));
				$page  = make_search($base);
			}

			// グローバル変数に値を格納
			$vars['cmd']  = 'read';
			$vars['page'] = $base;
			$body  = convert_html(get_source($base));

			if ($trackback) $body .= tb_get_rdf($base); // Add TrackBack-Ping URI
			if ($referer) ref_save($base);
		}

		// Output
		//catbody($title, $page, $body);
		list($body, $notes) = catbody($body);
		
		// テンプレートに出力
		$this->tmpl->addVar("_widget", "title", '実装中');	// タイトル
		$this->tmpl->addVar("_widget", "content", $body);	// メインコンテンツ
		$this->tmpl->addVar("_widget", "note", $notes);		// 追記
	}
}
?>
