<?php
/**
 * Wikiページ作成、アクセスクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: wikiPage.php 1052 2008-10-01 02:37:45Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/wiki_mainDb.php');

class WikiPage
{
	private static $db;		// DBオブジェクト
	const CONFIG_ENTITY_DATA = 'entities_dat';		// 判定用データ定義名
	const CONFIG_INIT = 'initialized';		// 初期設定(初期データインストール等)が完了しているかどうか
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
	}
	/**
	 * オブジェクトを初期化
	 *
	 * @param object $db	DBオブジェクト
	 * @return				なし
	 */
	public static function init($db)
	{
		self::$db = $db;
	}
	/**
	 * 初期データ読み込み
	 *
	 * @return bool			true=成功、false=失敗
	 */
	public static function readInitData()
	{
		global $gEnvManager;
		
		// 初期化が完了しているかチェック
		$init = self::$db->getConfig(self::CONFIG_INIT);
		if (empty($init)){
			// 初期データディレクトリ内のページデータファイルをすべて読み込む
			$path = $gEnvManager->getCurrentWidgetIncludePath() . '/data';
			if (is_dir($path)){
				$dir = dir($path);
				while (($file = $dir->read()) !== false){
					$filePath = $path . '/' . $file;
					$pathParts = pathinfo($file);
					$ext = $pathParts['extension'];		// 拡張子
					// ファイルかどうかチェック
					if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath) &&
						strncmp($file, '_', 1) != 0 &&	// 「_」で始まる名前のファイルは読み込まない
						$ext == 'txt'){		// 拡張子が「.txt」のファイルだけを読み込む
						$name = decode(basename($file, '.txt'));
						if (!empty($name)){
							$ret = self::getPageFile($name, $data);		// ファイルから初期データを読み込む
							if ($ret) self::initPage($name, $data);
						}
					}
				}
				$dir->close();
			}
			self::$db->updateConfig(self::CONFIG_INIT, '1');
		}
	}
	/**
	 * ページが存在するかどうかをチェック
	 *
	 * @param  string $name		Wiki名
	 * @return bool				true=存在する、false=存在しない
	 */
	public static function isPage($name)
	{
		return self::$db->isExistsPage($name);
	}
	/**
	 * ページを初期作成
	 *
	 * @param  string $name		Wiki名
	 * @param  string $data		初期データ
	 * @return bool			true=成功、false=失敗
	 */
	public static function initPage($name, $data='')
	{
		return self::$db->updatePage($name, $data);
	}
	/**
	 * ページの初期データファイルを読み込む
	 *
	 * @param  string $name		Wiki名
	 * @param  string $data		初期データ
	 * @return bool				true=成功、false=失敗
	 */
	public static function getPageFile($name, &$data)
	{
		global $gEnvManager;
		//global $gLogManager;
		
		$data = '';		// データ初期化
					
		// パラメータエラーチェック
		if (empty($name)) return false;
		
		$path = $gEnvManager->getCurrentWidgetIncludePath() . '/data/' . encode($name) . '.txt';
		if ($fData = @file_get_contents($path)){		// ファイルが読み込めないときはファイルがないとする
			$data = $fData;
			return true;
		} else {
			return false;
		}
		/*if (!($file = @fopen($path, "r"))){
 			$gLogManager->error(__METHOD__, 'ファイルのオープンに失敗しました ファイル=' . $path);
 			return false;
		}
		$data = @fread($file, filesize($path));
		@fclose($file);
		return true;*/
	}
	/**
	 * ページデータを取得
	 *
	 * @param string $name		ページ名
	 * @param bool $join		データ連結するかどうか
	 * @return string,array		取得データ
	 */
	public static function getPage($name, $join=false)
	{
		$retVal = $join ? '' : array();

		$ret = self::$db->getPage($name, $row);
		if ($ret){
			if ($join){		// 文字列を返すとき
				$retVal = $row['wc_data'];
			} else {		// 行単位の配列にして返すとき
				$retVal = explode("\n", $row['wc_data']);
			}
		}
		return $retVal;
	}
	/**
	 * ページ名を取得
	 *
	 * @return array		ページ名
	 */
	public static function getPages()
	{
		$retVal = self::$db->getAvailablePages();
		return $retVal;
	}
	/**
	 * ページ更新日時を取得
	 *
	 * @param string $name		ページ名
	 * @return int				UNIXタイムスタンプ
	 */
	public static function getPageUpdateTime($name)
	{
		$retVal = 0;
		$ret = self::$db->getPage($name, $row);
		if ($ret){
			$retVal = strtotime($row['wc_create_dt']);
		}
		return $retVal;
	}
	/**
	 * 判定用データが存在するかどうかをチェック
	 *
	 * @return bool			true=存在する、false=存在しない
	 */
	public static function isEntity()
	{
		return self::$db->isExistsPage($name);
	}
	/**
	 * 判定用データファイル(entities.dat)を読み込む
	 *
	 * @return string		取得データ
	 */
	public static function getEntityData()
	{
		global $gEnvManager;
		
		// DBをチェックする
		if (self::$db->isExistsConfig(self::CONFIG_ENTITY_DATA)){
			return self::$db->getConfig(self::CONFIG_ENTITY_DATA);
		} else {
			// DBに存在しない場合は初期化
			$path = $gEnvManager->getCurrentWidgetIncludePath() . '/data/entities.dat';
			if ($fData = file_get_contents($path)){
				//if ($db->updateConfig(self::CONFIG_ENTITY_DATA, $fData)){
				if (self::$db->updateConfig(self::CONFIG_ENTITY_DATA, $fData)){
					return $fData;
				} else {
					return '';
				}
			} else {
				return '';
			}
		}
	}
}
?>
