<?php
/**
 * システム制御マネージャー
 *
 *  主にシステムの動作に関わる制御の仲介を行う
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: systemManager.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
class SystemManager
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// システムDBオブジェクト取得
		$this->db = $gInstanceManager->getSytemDbObject();
	}
	
	/**
	 * システム初期化可能どうかを返す
	 *
	 * @return bool		true=システム初期化モード、false=システム初期化しない
	 */
	public function canInitSystem()
	{
		$retValue = $this->db->getSystemConfig('permit_init_system');
		if ($retValue == '1'){
			return true;
		} else {
			return false;
		}
	}
	/**
	 * システム初期化可能にする
	 *
	 * @return 		なし
	 */
	public function enableInitSystem()
	{
		$this->db->updateSystemConfig('permit_init_system', 1);
	}
	/**
	 * セッションを毎回更新するかどうかを返す
	 *
	 * @return bool		true=毎回更新、false=更新しない
	 */
	public function regenerateSessionId()
	{
		$retValue = $this->db->getSystemConfig('regenerate_session_id');
		if ($retValue == '1'){
			return true;
		} else {
			return false;
		}
	}
	/**
	 * アップロード可能なファイルの最大サイズを返す
	 *
	 * @return string		バイトサイズ
	 */
	public function getMaxFileSizeForUpload()
	{	
		$limit = ini_get('upload_max_filesize') > ini_get('post_max_size') ? ini_get('post_max_size') : ini_get('upload_max_filesize');
		$limit = $limit > ini_get('memory_limit') ? ini_get('memory_limit') : $limit;
		return $limit;
	}
}
?>
