<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: bbs_mainDb.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class bbs_mainDb extends BaseDb
{
	/**
	 * BBS定義値を取得
	 *
	 * @param string $key		キーとなる項目値
	 * @return string $value	値
	 */
	function getConfig($key)
	{
		$retValue = '';
		$queryStr = 'SELECT sf_value FROM bbs_config ';
		$queryStr .=  'WHERE sf_id  = ?';
		$ret = $this->selectRecord($queryStr, array($key), $row);
		if ($ret) $retValue = $row['sf_value'];
		return $retValue;
	}
	/**
	 * BBS定義値を更新
	 *
	 * @param string $key		キーとなる項目値
	 * @param string $value		値
	 * @return					true = 正常、false=異常
	 */
	function updateConfig($key, $value)
	{
		// データの確認
		$queryStr = 'SELECT sf_value FROM bbs_config ';
		$queryStr .=  'WHERE sf_id  = ?';
		$ret = $this->isRecordExists($queryStr, array($key));
		if ($ret){
			$queryStr = "UPDATE bbs_config SET sf_value = ? WHERE sf_id = ?";
			return $this->execStatement($queryStr, array($value, $key));
		} else {
			$queryStr = "INSERT INTO bbs_config (sf_id, sf_value) VALUES (?, ?)";
			return $this->execStatement($queryStr, array($key, $value));
		}
	}
	/**
	 * 投稿数を更新
	 *
	 * @param int	$userId					更新者ユーザID
	 * @return bool							true = 成功、false = 失敗
	 */
	function updatePostLog($userId)
	{
		// トランザクション開始
		$this->startTransaction();
		
		$queryStr = 'SELECT * FROM bbs_post_log ';
		$queryStr .=  'WHERE sl_user_id = ? ';
		$ret = $this->selectRecord($queryStr, array($userId), $row);
		if ($ret){
			$queryStr  = 'UPDATE bbs_post_log ';
			$queryStr .=   'SET sl_count = ?, ';
			$queryStr .=     'sl_update_dt = now() ';
			$queryStr .=  'WHERE sl_user_id = ? ';
			$this->execStatement($queryStr, array($row['sl_count'] + 1, $userId));
		} else {
			// 新規レコード追加
			$queryStr = 'INSERT INTO bbs_post_log ';
			$queryStr .=  '(';
			$queryStr .=  'sl_user_id, ';
			$queryStr .=  'sl_count, ';
			$queryStr .=  'sl_update_dt) ';
			$queryStr .=  'VALUES ';
			$queryStr .=  '(?, ?, now())';
			$this->execStatement($queryStr, array($userId, 1));
		}
		
		// トランザクション確定
		$ret = $this->endTransaction();
		return $ret;
	}
}
?>
