<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_flatrateWidgetContainer.php 86 2007-12-12 05:15:36Z naoki $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseIWidgetContainer.php');

class admin_flatrateWidgetContainer extends BaseIWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param string         $act			実行処理
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, $act, &$param)
	{
		global $gEnvManager;

		if ($act == 'update'){		// 設定更新のとき
			// 入力値を取得
			$price	= $request->valueOf('iw_price');			// 定額料金
			$useMin = ($request->valueOf('iw_use_min') == 'on') ? 1 : 0;		// 無料となる購入額を使用するかどうか
			$minPrice = $request->valueOf('iw_min_price');	// 最小購入額			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj->price	= $price;		// 定額料金
				$paramObj->useMin	= $useMin;		// 無料となる購入額を使用するかどうか
				$paramObj->minPrice	= $minPrice;	// 最小購入額
				$ret = $this->updateParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}				
			}
		} else {		// 初期表示の場合
			// デフォルト値設定
			$price = 0;
			$useMin = 0;		// 無料となる購入額を使用するかどうか
			$minPrice = 5000;	// 最小購入額
			$paramObj = $this->getParamObj();
			if (!empty($paramObj)){
				$price	= $paramObj->price;			// 定額料金
				$useMin = $paramObj->useMin;		// 無料となる購入額を使用するかどうか
				$minPrice = $paramObj->minPrice;	// 最小購入額
			}
		}
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "price",	$price);
		$this->tmpl->addVar("_widget", "min_price",	$minPrice);
		if ($useMin == 1) $this->tmpl->addVar("_widget", "use_min",	"checked");
	}
}
?>
