<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainOpelogWidgetContainer.php 1303 2008-12-01 03:29:05Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainOpelogWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $serialNo;	// シリアルNo
	private $serialArray = array();		// 表示されているコンテンツシリアル番号
	private $logLevelArray;				// 表示するログレベル
	private $logStatusArray;				// 表示するログステータス
	private $logLevel;					// 現在のログ表示レベル
	private $logStatus;					// 現在のログ表示ステータス
	const DEFAULT_LIST_COUNT = 30;			// 最大リスト表示数
	const MAX_PAGE_COUNT = 20;				// 最大ページ数
	const INFO_ICON_FILE = '/images/system/info16.png';			// 情報アイコン
	const NOTICE_ICON_FILE = '/images/system/notice16.png';		// 注意アイコン
	const ERROR_ICON_FILE = '/images/system/error16.png';		// エラーアイコン
	const ICON_SIZE = 16;		// アイコンのサイズ
	const DEFAULT_LOG_LEVEL = '1';		// デフォルトのログレベル
	const DEFAULT_LOG_STATUS = '1';		// デフォルトのログステータス

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
		
		// ログレベルタイプ
		$this->logLevelArray = array(	array(	'name' => 'すべて',		'value' => '0'),
										array(	'name' => '要確認項目のみ',	'value' => '1'));
		// ログステータスタイプ
		$this->logStatusArray = array(	array(	'name' => 'すべて',		'value' => '0'),
										array(	'name' => '未確認項目',	'value' => '1'),
										array(	'name' => '確認済項目',	'value' => '2'));
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'opelog_detail'){		// 詳細画面
			return 'opelog_detail.tmpl.html';
		} else {			// 一覧画面
			return 'opelog.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'opelog_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		$act = $request->trimValueOf('act');
		$this->logLevel = $request->trimValueOf('loglevel');// 現在のログ表示レベル
		if ($this->logLevel == '') $this->logLevel = self::DEFAULT_LOG_LEVEL;		// 現在のログ表示レベル
		$this->logStatus = $request->trimValueOf('logstatus');// 現在のログ表示ステータス
		if ($this->logStatus == '') $this->logStatus = self::DEFAULT_LOG_STATUS;		// 現在のログ表示ステータス(0=すべて、1=未確認のみ、2=確認済みのみ)
		
		// 表示するログを制限
		$viewLevel = 0;				// 表示メッセージレベル(0すべて、1=注意以上、10=要確認)
		if ($this->logLevel == '1') $viewLevel = 10;

		// 表示条件
		$viewCount = $request->trimValueOf('viewcount');// 表示項目数
		if ($viewCount == '') $viewCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		
		if ($act == 'delete'){		// 項目を参照済みに設定
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
			/*
				$ret = $this->db->delUserBySerial($delItems);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}*/
			}
		}
		// 表示するログレベル、ログステータス選択メニュー作成
		$this->createLogLevelMenu();
		$this->createLogStatusMenu();
		
		// 総数を取得
		$totalCount = $this->db->getOpeLogCount($viewLevel, $this->logStatus);

		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $viewCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;
		$this->firstNo = ($pageNo -1) * $viewCount + 1;		// 先頭番号
		
		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			for ($i = 1; $i <= $pageCount; $i++){
				if ($i > self::MAX_PAGE_COUNT) break;			// 最大ページ数以上のときは終了
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
				}
				$pageLink .= $link;
			}
		}
		$this->tmpl->addVar("_widget", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "total_count", $totalCount);
		$this->tmpl->addVar("_widget", "page", $pageNo);	// ページ番号
		$this->tmpl->addVar("_widget", "view_count", $viewCount);	// 最大表示項目数
		
		// 運用ログを取得
		$this->db->getOpeLogList($viewLevel, $this->logStatus, $viewCount, $pageNo, array($this, 'logListLoop'));
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		if (count($this->serialArray) == 0) $this->tmpl->setAttribute('loglist', 'visibility', 'hidden');		// ログがないときは非表示
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		// 表示条件
		$viewCount = $request->trimValueOf('viewcount');// 表示項目数
		$page = $request->trimValueOf('page');				// ページ番号
		$logLevel = $request->trimValueOf('loglevel');// 現在のログ表示レベル
		$logStatus = $request->trimValueOf('logstatus');// 現在のログ表示ステータス
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$isMsgChecked = ($request->trimValueOf('item_msgchecked') == 'on') ? 1 : 0;			// 確認済みかどうか
			
		$reloadData = false;		// データの再読み込み
		if ($act == 'update'){		// 行更新のとき
			// 入力チェック
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateOpeLogChecked($this->serialNo, $isMsgChecked);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else {
			if (!empty($this->serialNo)) $reloadData = true;		// データの再読み込み
		}
		if ($reloadData){		// データの再読み込み
			// 設定データを取得
			$ret = $this->db->getOpeLog($this->serialNo, $row);
			if ($ret){
				$iconUrl = '';
				switch ($row['ot_level']){
					case 0:		// 情報
						$iconUrl = $this->gEnv->getRootUrl() . self::INFO_ICON_FILE;
						break;
					case 1:		// 注意
						$iconUrl = $this->gEnv->getRootUrl() . self::NOTICE_ICON_FILE;
						break;
					case 10:	// 要確認
						$iconUrl = $this->gEnv->getRootUrl() . self::ERROR_ICON_FILE;
						break;
					default:
						break;
				}
				$iconTitle = $row['ot_name'];
				$iconTag = '<img src="' . $iconUrl . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
				$msgType = $row['ot_name'];
				$isMsgChecked = $row['ol_checked'];		// 確認済みかどうか
				$logMsg = $row['ol_message'];		// メッセージ
				$logMsgDetail = $row['ol_message_ext'];// メッセージ詳細
				$accessLogSerial = $row['ol_access_log_serial'];// アクセスログシリアル番号
				$time = $this->convertToDispDateTime($row['ol_dt']);	// 出力日時
			}
		}
		// 取得データを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "type_image", $iconTag);
		$this->tmpl->addVar("_widget", "type", $msgType);
		$isChecked = '';
		if ($isMsgChecked) $isChecked = 'checked';
		$this->tmpl->addVar("_widget", "msg_checked", $isChecked);
		$this->tmpl->addVar("_widget", "message", $this->convertToDispString($logMsg));
		$this->tmpl->addVar("_widget", "detail", $this->convertToDispString($logMsgDetail));
		$this->tmpl->addVar("_widget", "access_log_serial", $accessLogSerial);
		$this->tmpl->addVar("_widget", "time", $time);

		// 一覧の表示条件
		$this->tmpl->addVar("_widget", "page", $page);	// ページ番号
		$this->tmpl->addVar("_widget", "view_count", $viewCount);	// 最大表示項目数
		$this->tmpl->addVar("_widget", "log_level", $logLevel);	// ログ表示レベル
		$this->tmpl->addVar("_widget", "log_status", $logStatus);	// ログ表示ステータス
		
		$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 更新ボタン表示
	}
	/**
	 * 運用ログ一覧取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function logListLoop($index, $fetchedRow, $param)
	{
		$msgChecked = '';
		if ($fetchedRow['ol_checked']){
			$msgChecked = 'checked';
		}
		// メッセージレベルの設定
		$iconUrl = '';
		switch ($fetchedRow['ot_level']){
			case 0:		// 情報
				$iconUrl = $this->gEnv->getRootUrl() . self::INFO_ICON_FILE;
				break;
			case 1:		// 注意
				$iconUrl = $this->gEnv->getRootUrl() . self::NOTICE_ICON_FILE;
				break;
			case 10:	// 要確認
				$iconUrl = $this->gEnv->getRootUrl() . self::ERROR_ICON_FILE;
				break;
			default:
				break;
		}
		$iconTitle = $fetchedRow['ot_name'];
		$iconTag = '<img src="' . $iconUrl . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
		$row = array(
			'index' => $index,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['ol_serial']),			// シリアル番号
			'type' => $iconTag,			// メッセージタイプを示すアイコン
			'message' => $this->convertToDispString($fetchedRow['ol_message']),		// メッセージ
			'access_log' => $this->convertToDispString($fetchedRow['ol_access_log_serial']),		// アクセスログ番号
			'output_dt' => $this->convertToDispDateTime($fetchedRow['ol_dt']),	// 出力日時
			'msg_checked' => $msgChecked,										// メッセージを確認したかどうか
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('loglist', $row);
		$this->tmpl->parseTemplate('loglist', 'a');
		
		// 表示中のコンテンツIDを保存
		$this->serialArray[] = $fetchedRow['ol_serial'];
		return true;
	}
	/**
	 * 表示ログレベル選択メニュー作成
	 *
	 * @return なし
	 */
	function createLogLevelMenu()
	{
		for ($i = 0; $i < count($this->logLevelArray); $i++){
			$value = $this->logLevelArray[$i]['value'];
			$name = $this->logLevelArray[$i]['name'];
			
			$selected = '';
			if ($value == $this->logLevel) $selected = 'selected';
			
			$row = array(
				'value'    => $value,			// ログレベル
				'name'     => $name,			// ログレベル名
				'selected' => $selected			// 選択中かどうか
			);
			$this->tmpl->addVars('loglevel_list', $row);
			$this->tmpl->parseTemplate('loglevel_list', 'a');
		}
	}
	/**
	 * 表示ログステータス選択メニュー作成
	 *
	 * @return なし
	 */
	function createLogStatusMenu()
	{
		for ($i = 0; $i < count($this->logStatusArray); $i++){
			$value = $this->logStatusArray[$i]['value'];
			$name = $this->logStatusArray[$i]['name'];
			
			$selected = '';
			if ($value == $this->logStatus) $selected = 'selected';
			
			$row = array(
				'value'    => $value,			// ログレベル
				'name'     => $name,			// ログレベル名
				'selected' => $selected			// 選択中かどうか
			);
			$this->tmpl->addVars('logstatus_list', $row);
			$this->tmpl->parseTemplate('logstatus_list', 'a');
		}
	}
}
?>
