-- *
-- * バージョンアップ用スクリプト
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2008 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _2008120601_to_2008120801.sql 1332 2008-12-09 06:59:01Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- --------------------------------------------------------------------------------------------------
-- バージョンアップ用スクリプト
-- --------------------------------------------------------------------------------------------------

-- *** システムベーステーブル ***
-- メニュー定義マスター
DROP TABLE IF EXISTS _menu_def;
CREATE TABLE _menu_def (
    md_id                INT            DEFAULT 0                     NOT NULL,      -- 項目ID
    md_parent_id         INT            DEFAULT 0                     NOT NULL,      -- 親項目ID(親がないときは0)
    md_index             INT            DEFAULT 0                     NOT NULL,      -- 表示順(0～)、md_parent_id=0のときは親間の表示順
    md_menu_id           VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- メニュー種別ID
    md_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 名前
    md_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 説明
    md_link_type         INT            DEFAULT 0                     NOT NULL,      -- リンクタイプ(0=同ウィンドウ、1=別ウィンドウ)
    md_link_url          TEXT                                         NOT NULL,      -- リンク先
    md_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示するかどうか
    md_enable            BOOLEAN        DEFAULT true                  NOT NULL,      -- 使用可能かどうか

    md_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    md_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    PRIMARY KEY          (md_id)
) TYPE=innodb;

-- *** システム標準テーブル ***
