<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: banner2Db.php 1475 2009-01-27 07:35:38Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class banner2Db extends BaseDb
{
	/**
	 * 画像リンク一覧を取得
	 *
	 * @param int		$limit				取得する項目数
	 * @param int		$page				取得するページ(1～)
	 * @param function	$callback			コールバック関数
	 * @return 			なし
	 */
	function getImageList($limit, $page, $callback)
	{
		$offset = $limit * ($page -1);
		if ($offset < 0) $offset = 0;
		
		$queryStr  = 'SELECT * FROM bn_item ';
		$queryStr .=   'WHERE bi_deleted = false ';
		$queryStr .=   'ORDER BY bi_id limit ' . $limit . ' offset ' . $offset;
		$this->selectLoop($queryStr, array(), $callback, null);
	}
	/**
	 * 画像リンク数を取得
	 *
	 * @return int		項目数
	 */
	function getImageCount()
	{
		$queryStr  = 'SELECT * FROM bn_item ';
		$queryStr .=   'WHERE bi_deleted = false ';
		return $this->selectRecordCount($queryStr, array());
	}
	/**
	 * バナー項目のビューカウント総数を取得
	 *
	 * @param  int $serial				バナー項目シリアル番号
	 * @return int						総数
	 */
	function getTotalViewCount($serial)
	{
		$count = 0;
		$params = array();
		$queryStr  = 'SELECT * FROM bn_item_view ';
		$queryStr .=   'WHERE bv_item_serial = ? ';	$params[] = $serial;
		return $this->selectRecordCount($queryStr, $params);
	}
	/**
	 * バナー表示ログの記録
	 *
	 * @param int    $bannerItemSerial		バナー項目シリアル番号
	 * @param int    $accessLogSerial    	アクセスログシリアル番号
	 * @return string						公開キー
	 */
	function viewBannerItemLog($bannerItemSerial, $accessLogSerial)
	{
		// トランザクション開始
		$this->startTransaction();
		
		$max = 0;
		$queryStr = 'SELECT MAX(bv_serial) AS m FROM bn_item_view';
		$ret = $this->selectRecord($queryStr, array(), $row);
		if ($ret) $max = $row['m'];
		
		// 公開キーの作成
		$key = md5($this->gRequest->trimServerValueOf('REMOTE_ADDR') . ($max + 1));
		
		$queryStr  = 'INSERT INTO bn_item_view (';
		$queryStr .=   'bv_public_key, ';
		$queryStr .=   'bv_item_serial, ';
		$queryStr .=   'bv_log_serial, ';
		$queryStr .=   'bv_dt ';
		$queryStr .= ') VALUES (';
		$queryStr .=   '?, ?, ?, now()';
		$queryStr .= ')';
		$ret = $this->execStatement($queryStr, array($key, $bannerItemSerial, $accessLogSerial));
		
		// トランザクション終了
		$ret = $this->endTransaction();
		if ($ret){
			return $key;
		} else {
			return '';
		}
	}
	/**
	 * バナークリックログの記録
	 *
	 * @param string    $stamp				公開ID
	 * @param string    $url   				リダイレクト先URL
	 * @param int       $accessLogSerial    アクセスログシリアル番号
	 * @return bool							true = 成功、false = 失敗
	 */
	function clickBannerItemLog($stamp, $url, $accessLogSerial)
	{	
		// トランザクション開始
		$this->startTransaction();
		
		$queryStr  = 'INSERT INTO bn_item_access (';
		$queryStr .=   'ba_public_key, ';
		$queryStr .=   'ba_redirect_url, ';
		$queryStr .=   'ba_log_serial, ';
		$queryStr .=   'ba_dt ';
		$queryStr .= ') VALUES (';
		$queryStr .=   '?, ?, ?, now()';
		$queryStr .= ')';
		$ret = $this->execStatement($queryStr, array($stamp, $url, $accessLogSerial));
		
		// トランザクション終了
		$ret = $this->endTransaction();
		return $ret;
	}
}
?>
