<?php
/**
 * 共通インスタンス管理マネージャー
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: instanceManager.php 1287 2008-11-27 05:00:49Z fishbone $
 * @link       http://www.magic3.org
 */
require_once(M3_SYSTEM_INCLUDE_PATH . '/db/systemDb.php');		// システムDBアクセスクラス
require_once(M3_SYSTEM_INCLUDE_PATH . '/common/core.php');
/**
 * 共通インスタンス管理クラス
 *
 * 共通で使用するインスタンスオブジェクトの生成、破棄、取得を管理する
 */
class InstanceManager extends Core
{
    private $systemDb;		// システムDBオブジェクト
	private $userInfo;		// ユーザ情報オブジェクト
	private $addonDir;		// 追加クラスインストールディレクトリ
	private $addonArray;	// ロード済みの追加クラス
	private $mobileAgent;	// 携帯判定用オブジェクト
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->systemDb = new SystemDb();
		
		// 変数初期化
		$this->addonArray = array();
	}
	/**
	 * システムDBオブジェクトを取得
	 */
	public function getSytemDbObject()
	{
		return $this->systemDb;
	}
	/**
	 * ユーザ情報設定
	 *
	 * @param UseInfo	$obj		ユーザ情報オブジェクト
	 */
	public function setUserInfo($obj)
	{
		$this->userInfo = $obj;
	}
	/**
	 * ユーザ情報取得
	 *
	 * @return UserInfo		ユーザ情報オブジェクト
	 */
	public function getUserInfo()
	{
		return $this->userInfo;
	}
	/**
	 * 携帯判定オブジェクト取得
	 *
	 * @return object			取得したオブジェクト
	 */
	public function getMobileAgent()
	{
		global $gEnvManager;
		
		if (!isset($this->mobileAgent)){
			require_once($gEnvManager->getLibPath() . '/Net_UserAgent_Mobile-1.0.0RC1/Mobile.php');
			$this->mobileAgent = Net_UserAgent_Mobile::singleton();
		}
		return $this->mobileAgent;
	}
	/**
	 * オブジェクト取得
	 *
	 * @param string	$id		オブジェクト識別ID
	 * @return object			取得したオブジェクト
	 */
	public function getObject($id)
	{
		return $this->addonArray[$id];
	}
	/**
	 * 追加クラスをインスタンス化
	 */
	public function loadAddonClass()
	{
		global $gEnvManager;
		
		// DB接続不可のときは終了
		if (!$gEnvManager->canUseDb()) return;
		
		// 追加クラス格納ディレクトリを取得
		$this->addonDir = $gEnvManager->getAddonsPath();
		
		$ret = $this->systemDb->getAllAddons($rows);
		if ($ret){
			for ($i = 0; $i < count($rows); $i++){
				// 追加クラスID
				$addonId = $rows[$i]['ao_id'];
				// クラス名
				$loadClass = $rows[$i]['ao_class_name'];
				// クラスファイルパス
				$loadClassFile = $this->addonDir . '/' . $addonId . '/' . $loadClass . '.php';
		
				if (file_exists($loadClassFile)){
					// ファイル読み込み
					require_once($loadClassFile);
			
					// クラス作成
					$this->addonArray[$addonId] = new $loadClass();
				} else {
					echo 'addon load error: id=' . $addonId;
				}
			}
		}
	}
}
?>
