<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: bbs_mainRegistWidgetContainer.php 48 2007-11-24 00:31:32Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainMemberDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainDb.php');

class bbs_mainRegistWidgetContainer extends BaseWidgetContainer
{
	private $db;		// DB接続オブジェクト
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $langId;	// 表示言語
	const ADMIN_NAME	= 'admin_name';			// 管理者名
	const USE_EMAIL		= 'use_email';		// EMAIL機能が使用可能かどうか
	const SEND_PASSWORD_ON_REGIST	= 'send_password_on_regist';		// 会員登録時にパスワードを自動送信するかどうか
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
	const REGIST_MEMBER_FORM = 'regist_member';		// パスワード送信用フォーム
	const THIS_WIDGET_ID = 'bbs_main';		// ウィジェットID
						
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bbs_mainMemberDb();
		$this->mainDb = new bbs_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'regist.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gMailManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
				
		$act = $request->trimValueOf('act');
		if ($act == 'post'){		// 会員登録
			$name = $request->trimValueOf('item_name');
			$email = $request->trimValueOf('item_email');
			
			// 入力チェック
			$this->checkInput($name, 'お名前');
			$this->checkMailAddress($email, 'アカウント(Eメール)');
			
			// 存在チェック
			if ($this->getMsgCount() == 0){
				// 表示名の重複チェック
				if ($this->db->isExistsMemberName($name)) $this->setAppErrorMsg('同名の会員が存在します');
				
				// メールアドレスのチェック
				if ($this->sysDb->isExistsAccount($email)) $this->setUserErrorMsg('このEメールアドレスは既に登録されています');
			}
			// エラーなしの場合は、会員登録
			if ($this->getMsgCount() == 0){
				// パスワード生成
				$password = $this->makePassword();
				
				// トランザクションスタート
				$this->db->startTransaction();

				// ログインユーザを作成
				$userId = 0;		// 登録ユーザ
				$ret = $this->db->addUser(0/* 仮会員 */, $name, $email, $password, self::THIS_WIDGET_ID, $userId, $now, $loginUserId);		// 新規ログインユーザIDを取得

				// 会員情報を登録
				if ($ret) $ret = $this->db->updateMember(0, $this->langId, 0/*仮会員*/, $loginUserId, $name, '1'/*ゲストグループ*/, '', '', 0, $userId, $now, $newSerial);

				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){
					$this->setGuidanceMsg('会員登録完了しました');
					
					// メール送信設定のときはメールを送信
					if ($this->mainDb->getConfig(self::USE_EMAIL) == '1' && $this->mainDb->getConfig(self::SEND_PASSWORD_ON_REGIST) == '1'){	// メール送信機能使用かつメール自動送信許可
						$fromAddress = $this->mainDb->getConfig(self::AUTO_EMAIL_SENDER);	// 自動送信送信元
						$toAddress = $email;			// eメール(ログインアカウント)
						$mailParam = array();
						$mailParam['PASSWORD'] = $password;
						$ret = $gMailManager->sendFormMail(1, self::THIS_WIDGET_ID, $toAddress, $fromAddress, '', '', self::REGIST_MEMBER_FORM, $mailParam);// 自動送信
						$this->tmpl->addVar("_widget", "message", '登録完了しました。指定のメールアドレス宛てにパスワードが送信されます。<br>再度ログインしてください。');
					} else {
						$this->tmpl->addVar("_widget", "message", '登録完了しました。ログイン画面よりログインしてください。パスワード:' . $password);
					}
				
					$this->tmpl->addVar("_widget", "name_readonly", 'readonly');
					$this->tmpl->addVar("_widget", "email_readonly", 'readonly');
					$this->tmpl->addVar("_widget", "disable_regist", 'disabled');		// ボタン使用不可
//					$this->tmpl->addVar("_widget", "message", '新規パスワード: ' . $password);
				} else {
					$this->setAppErrorMsg('会員登録に失敗しました');
				}
			}
			$this->tmpl->addVar("_widget", "name", $name);
			$this->tmpl->addVar("_widget", "email", $email);			
		} else {
			// ログイン中かチェック
			$userId = $gEnvManager->getCurrentUserId();
			if ($userId != 0){		// ログイン中の場合は入力不可にする
				// 会員情報を取得
				$memberName = '';
				$loginAccount = '';
				if ($this->db->getMemberByUserId($userId, $memberRow)){		// BBS会員として登録されている場合
					$memberName = $memberRow['sv_name'];
					$loginAccount = $memberRow['login_user_account'];
				} else {			// BBS会員として登録されていない場合は、管理者
					if ($this->sysDb->getLoginUserRecordById($userId, $row)) $loginAccount = $row['lu_account'];
				}
				if (empty($memberName) && $gEnvManager->isSystemAdmin()){			// 管理権限ありの場合
					$memberName = $this->mainDb->getConfig(self::ADMIN_NAME);		// BBS管理者名
				}
				
				$this->tmpl->addVar("_widget", "name", $memberName);
				$this->tmpl->addVar("_widget", "email", $loginAccount);
				$this->tmpl->addVar("_widget", "name_readonly", 'readonly');
				$this->tmpl->addVar("_widget", "email_readonly", 'readonly');
				$this->tmpl->addVar("_widget", "disable_regist", 'disabled');		// ボタン使用不可
				$this->tmpl->addVar("_widget", "message", 'すでにBBSにログイン中です');
			}
		}
	}
}
?>
